<?php

namespace EnumType;

/**
 * This class stands for AdministrativeRoleTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of allowed values for RESPONSIBILITY ROLEs.
 * @subpackage Enumerations
 */
class AdministrativeRoleTypeEnumeration
{
    /**
     * Constant for value 'all'
     * @return string 'all'
     */
    const VALUE_ALL = 'all';
    /**
     * Constant for value 'collects'
     * @return string 'collects'
     */
    const VALUE_COLLECTS = 'collects';
    /**
     * Constant for value 'validates'
     * @return string 'validates'
     */
    const VALUE_VALIDATES = 'validates';
    /**
     * Constant for value 'aggregates'
     * @return string 'aggregates'
     */
    const VALUE_AGGREGATES = 'aggregates';
    /**
     * Constant for value 'distributes'
     * @return string 'distributes'
     */
    const VALUE_DISTRIBUTES = 'distributes';
    /**
     * Constant for value 'redistributes'
     * @return string 'redistributes'
     */
    const VALUE_REDISTRIBUTES = 'redistributes';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_COLLECTS
     * @uses self::VALUE_VALIDATES
     * @uses self::VALUE_AGGREGATES
     * @uses self::VALUE_DISTRIBUTES
     * @uses self::VALUE_REDISTRIBUTES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_COLLECTS,
            self::VALUE_VALIDATES,
            self::VALUE_AGGREGATES,
            self::VALUE_DISTRIBUTES,
            self::VALUE_REDISTRIBUTES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
