<?php

namespace EnumType;

/**
 * This class stands for AccidentCauseEnum EnumType
 * @subpackage Enumerations
 */
class AccidentCauseEnum
{
    /**
     * Constant for value 'avoidanceOfObstacles'
     * @return string 'avoidanceOfObstacles'
     */
    const VALUE_AVOIDANCE_OF_OBSTACLES = 'avoidanceOfObstacles';
    /**
     * Constant for value 'driverDistraction'
     * @return string 'driverDistraction'
     */
    const VALUE_DRIVER_DISTRACTION = 'driverDistraction';
    /**
     * Constant for value 'driverDrugAbuse'
     * @return string 'driverDrugAbuse'
     */
    const VALUE_DRIVER_DRUG_ABUSE = 'driverDrugAbuse';
    /**
     * Constant for value 'driverIllness'
     * @return string 'driverIllness'
     */
    const VALUE_DRIVER_ILLNESS = 'driverIllness';
    /**
     * Constant for value 'exceedingSpeedsLimits'
     * @return string 'exceedingSpeedsLimits'
     */
    const VALUE_EXCEEDING_SPEEDS_LIMITS = 'exceedingSpeedsLimits';
    /**
     * Constant for value 'excessAlcohol'
     * @return string 'excessAlcohol'
     */
    const VALUE_EXCESS_ALCOHOL = 'excessAlcohol';
    /**
     * Constant for value 'excessiveDriverTiredness'
     * @return string 'excessiveDriverTiredness'
     */
    const VALUE_EXCESSIVE_DRIVER_TIREDNESS = 'excessiveDriverTiredness';
    /**
     * Constant for value 'impermissibleManoeuvre'
     * @return string 'impermissibleManoeuvre'
     */
    const VALUE_IMPERMISSIBLE_MANOEUVRE = 'impermissibleManoeuvre';
    /**
     * Constant for value 'limitedVisibility'
     * @return string 'limitedVisibility'
     */
    const VALUE_LIMITED_VISIBILITY = 'limitedVisibility';
    /**
     * Constant for value 'notKeepingASafeDistance'
     * @return string 'notKeepingASafeDistance'
     */
    const VALUE_NOT_KEEPING_ASAFE_DISTANCE = 'notKeepingASafeDistance';
    /**
     * Constant for value 'onTheWrongSideOfTheRoad'
     * @return string 'onTheWrongSideOfTheRoad'
     */
    const VALUE_ON_THE_WRONG_SIDE_OF_THE_ROAD = 'onTheWrongSideOfTheRoad';
    /**
     * Constant for value 'pedestrianInRoad'
     * @return string 'pedestrianInRoad'
     */
    const VALUE_PEDESTRIAN_IN_ROAD = 'pedestrianInRoad';
    /**
     * Constant for value 'poorLaneAdherence'
     * @return string 'poorLaneAdherence'
     */
    const VALUE_POOR_LANE_ADHERENCE = 'poorLaneAdherence';
    /**
     * Constant for value 'poorMergeEntryOrExitJudgement'
     * @return string 'poorMergeEntryOrExitJudgement'
     */
    const VALUE_POOR_MERGE_ENTRY_OR_EXIT_JUDGEMENT = 'poorMergeEntryOrExitJudgement';
    /**
     * Constant for value 'poorRoadSurfaceCondition'
     * @return string 'poorRoadSurfaceCondition'
     */
    const VALUE_POOR_ROAD_SURFACE_CONDITION = 'poorRoadSurfaceCondition';
    /**
     * Constant for value 'poorSurfaceAdherence'
     * @return string 'poorSurfaceAdherence'
     */
    const VALUE_POOR_SURFACE_ADHERENCE = 'poorSurfaceAdherence';
    /**
     * Constant for value 'undisclosed'
     * @return string 'undisclosed'
     */
    const VALUE_UNDISCLOSED = 'undisclosed';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'vehicleFailure'
     * @return string 'vehicleFailure'
     */
    const VALUE_VEHICLE_FAILURE = 'vehicleFailure';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVOIDANCE_OF_OBSTACLES
     * @uses self::VALUE_DRIVER_DISTRACTION
     * @uses self::VALUE_DRIVER_DRUG_ABUSE
     * @uses self::VALUE_DRIVER_ILLNESS
     * @uses self::VALUE_EXCEEDING_SPEEDS_LIMITS
     * @uses self::VALUE_EXCESS_ALCOHOL
     * @uses self::VALUE_EXCESSIVE_DRIVER_TIREDNESS
     * @uses self::VALUE_IMPERMISSIBLE_MANOEUVRE
     * @uses self::VALUE_LIMITED_VISIBILITY
     * @uses self::VALUE_NOT_KEEPING_ASAFE_DISTANCE
     * @uses self::VALUE_ON_THE_WRONG_SIDE_OF_THE_ROAD
     * @uses self::VALUE_PEDESTRIAN_IN_ROAD
     * @uses self::VALUE_POOR_LANE_ADHERENCE
     * @uses self::VALUE_POOR_MERGE_ENTRY_OR_EXIT_JUDGEMENT
     * @uses self::VALUE_POOR_ROAD_SURFACE_CONDITION
     * @uses self::VALUE_POOR_SURFACE_ADHERENCE
     * @uses self::VALUE_UNDISCLOSED
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_VEHICLE_FAILURE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVOIDANCE_OF_OBSTACLES,
            self::VALUE_DRIVER_DISTRACTION,
            self::VALUE_DRIVER_DRUG_ABUSE,
            self::VALUE_DRIVER_ILLNESS,
            self::VALUE_EXCEEDING_SPEEDS_LIMITS,
            self::VALUE_EXCESS_ALCOHOL,
            self::VALUE_EXCESSIVE_DRIVER_TIREDNESS,
            self::VALUE_IMPERMISSIBLE_MANOEUVRE,
            self::VALUE_LIMITED_VISIBILITY,
            self::VALUE_NOT_KEEPING_ASAFE_DISTANCE,
            self::VALUE_ON_THE_WRONG_SIDE_OF_THE_ROAD,
            self::VALUE_PEDESTRIAN_IN_ROAD,
            self::VALUE_POOR_LANE_ADHERENCE,
            self::VALUE_POOR_MERGE_ENTRY_OR_EXIT_JUDGEMENT,
            self::VALUE_POOR_ROAD_SURFACE_CONDITION,
            self::VALUE_POOR_SURFACE_ADHERENCE,
            self::VALUE_UNDISCLOSED,
            self::VALUE_UNKNOWN,
            self::VALUE_VEHICLE_FAILURE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
