<?php

namespace EnumType;

/**
 * This class stands for AccessFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Access Facility.
 * @subpackage Enumerations
 */
class AccessFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'lift'
     * @return string 'lift'
     */
    const VALUE_LIFT = 'lift';
    /**
     * Constant for value 'escalator'
     * @return string 'escalator'
     */
    const VALUE_ESCALATOR = 'escalator';
    /**
     * Constant for value 'travelator'
     * @return string 'travelator'
     */
    const VALUE_TRAVELATOR = 'travelator';
    /**
     * Constant for value 'ramp'
     * @return string 'ramp'
     */
    const VALUE_RAMP = 'ramp';
    /**
     * Constant for value 'stairs'
     * @return string 'stairs'
     */
    const VALUE_STAIRS = 'stairs';
    /**
     * Constant for value 'shuttle'
     * @return string 'shuttle'
     */
    const VALUE_SHUTTLE = 'shuttle';
    /**
     * Constant for value 'narrowEntrance'
     * @return string 'narrowEntrance'
     */
    const VALUE_NARROW_ENTRANCE = 'narrowEntrance';
    /**
     * Constant for value 'barrier'
     * @return string 'barrier'
     */
    const VALUE_BARRIER = 'barrier';
    /**
     * Constant for value 'palletAccess_lowFloor'
     * @return string 'palletAccess_lowFloor'
     */
    const VALUE_PALLET_ACCESS_LOW_FLOOR = 'palletAccess_lowFloor';
    /**
     * Constant for value 'validator'
     * @return string 'validator'
     */
    const VALUE_VALIDATOR = 'validator';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_LIFT
     * @uses self::VALUE_ESCALATOR
     * @uses self::VALUE_TRAVELATOR
     * @uses self::VALUE_RAMP
     * @uses self::VALUE_STAIRS
     * @uses self::VALUE_SHUTTLE
     * @uses self::VALUE_NARROW_ENTRANCE
     * @uses self::VALUE_BARRIER
     * @uses self::VALUE_PALLET_ACCESS_LOW_FLOOR
     * @uses self::VALUE_VALIDATOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_LIFT,
            self::VALUE_ESCALATOR,
            self::VALUE_TRAVELATOR,
            self::VALUE_RAMP,
            self::VALUE_STAIRS,
            self::VALUE_SHUTTLE,
            self::VALUE_NARROW_ENTRANCE,
            self::VALUE_BARRIER,
            self::VALUE_PALLET_ACCESS_LOW_FLOOR,
            self::VALUE_VALIDATOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
