<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ExtensionsStructure' => '\\StructType\\ExtensionsStructure',
            'CoordinatesStructure' => '\\StructType\\CoordinatesStructure',
            'LocationStructure' => '\\StructType\\LocationStructure',
            'BoundingBoxStructure' => '\\StructType\\BoundingBoxStructure',
            'LineShapeStructure' => '\\StructType\\LineShapeStructure',
            'NaturalLanguageStringStructure' => '\\StructType\\NaturalLanguageStringStructure',
            'NaturalLanguagePlaceNameStructure' => '\\StructType\\NaturalLanguagePlaceNameStructure',
            'ParticipantRefStructure' => '\\StructType\\ParticipantRefStructure',
            'MessageQualifierStructure' => '\\StructType\\MessageQualifierStructure',
            'MessageRefStructure' => '\\StructType\\MessageRefStructure',
            'SubscriptionQualifierStructure' => '\\StructType\\SubscriptionQualifierStructure',
            'SubscriptionFilterStructure' => '\\StructType\\SubscriptionFilterStructure',
            'SubscriptionFilterRefStructure' => '\\StructType\\SubscriptionFilterRefStructure',
            'ItemRefStructure' => '\\StructType\\ItemRefStructure',
            'CapabilityRefStructure' => '\\StructType\\CapabilityRefStructure',
            'ErrorConditionStructure' => '\\StructType\\ErrorConditionStructure',
            'ErrorConditionElementStructure' => '\\StructType\\ErrorConditionElementStructure',
            'ErrorDescriptionStructure' => '\\StructType\\ErrorDescriptionStructure',
            'ErrorCodeStructure' => '\\StructType\\ErrorCodeStructure',
            'ServiceDeliveryErrorConditionStructure' => '\\StructType\\ServiceDeliveryErrorConditionStructure',
            'UnapprovedKeyAccessStructure' => '\\StructType\\UnapprovedKeyAccessStructure',
            'UnknownParticipantErrorStructure' => '\\StructType\\UnknownParticipantErrorStructure',
            'UnknownEndpointErrorStructure' => '\\StructType\\UnknownEndpointErrorStructure',
            'EndpointDeniedAccessStructure' => '\\StructType\\EndpointDeniedAccessStructure',
            'EndpointNotAvailableAccessStructure' => '\\StructType\\EndpointNotAvailableAccessStructure',
            'ServiceNotAvailableErrorStructure' => '\\StructType\\ServiceNotAvailableErrorStructure',
            'CapabilityNotSupportedErrorStructure' => '\\StructType\\CapabilityNotSupportedErrorStructure',
            'BeyondDataHorizonErrorStructure' => '\\StructType\\BeyondDataHorizonErrorStructure',
            'AccessNotAllowedErrorStructure' => '\\StructType\\AccessNotAllowedErrorStructure',
            'NoInfoForTopicErrorStructure' => '\\StructType\\NoInfoForTopicErrorStructure',
            'InvalidDataReferencesErrorStructure' => '\\StructType\\InvalidDataReferencesErrorStructure',
            'ParametersIgnoredErrorStructure' => '\\StructType\\ParametersIgnoredErrorStructure',
            'UnknownExtensionsErrorStructure' => '\\StructType\\UnknownExtensionsErrorStructure',
            'AllowedResourceUsageExceededErrorStructure' => '\\StructType\\AllowedResourceUsageExceededErrorStructure',
            'UnknownSubscriberErrorStructure' => '\\StructType\\UnknownSubscriberErrorStructure',
            'UnknownSubscriptionErrorStructure' => '\\StructType\\UnknownSubscriptionErrorStructure',
            'OtherErrorStructure' => '\\StructType\\OtherErrorStructure',
            'AbstractRequestStructure' => '\\StructType\\AbstractRequestStructure',
            'AuthenticatedRequestStructure' => '\\StructType\\AuthenticatedRequestStructure',
            'RequestStructure' => '\\StructType\\RequestStructure',
            'AbstractServiceRequestStructure' => '\\StructType\\AbstractServiceRequestStructure',
            'AbstractFunctionalServiceRequestStructure' => '\\StructType\\AbstractFunctionalServiceRequestStructure',
            'AbstractSubscriptionStructure' => '\\StructType\\AbstractSubscriptionStructure',
            'SubscriptionContextStructure' => '\\StructType\\SubscriptionContextStructure',
            'AbstractSubscriptionRequestStructure' => '\\StructType\\AbstractSubscriptionRequestStructure',
            'ResponseStructure' => '\\StructType\\ResponseStructure',
            'ErrorCondition' => '\\StructType\\ErrorCondition',
            'ProducerResponseStructure' => '\\StructType\\ProducerResponseStructure',
            'AbstractNotificationStructure' => '\\StructType\\AbstractNotificationStructure',
            'AbstractServiceDeliveryStructure' => '\\StructType\\AbstractServiceDeliveryStructure',
            'ConsumerRequestEndpointStructure' => '\\StructType\\ConsumerRequestEndpointStructure',
            'ConsumerResponseEndpointStructure' => '\\StructType\\ConsumerResponseEndpointStructure',
            'ProducerRequestEndpointStructure' => '\\StructType\\ProducerRequestEndpointStructure',
            'ResponseEndpointStructure' => '\\StructType\\ResponseEndpointStructure',
            'ProducerResponseEndpointStructure' => '\\StructType\\ProducerResponseEndpointStructure',
            'AbstractItemStructure' => '\\StructType\\AbstractItemStructure',
            'AbstractIdentifiedItemStructure' => '\\StructType\\AbstractIdentifiedItemStructure',
            'AbstractRequiredIdentifiedItemStructure' => '\\StructType\\AbstractRequiredIdentifiedItemStructure',
            'AbstractReferencingItemStructure' => '\\StructType\\AbstractReferencingItemStructure',
            'AbstractRequiredReferencingItemStructure' => '\\StructType\\AbstractRequiredReferencingItemStructure',
            'ServiceCapabilitiesRequestStructure' => '\\StructType\\ServiceCapabilitiesRequestStructure',
            'AbstractServiceCapabilitiesResponseStructure' => '\\StructType\\AbstractServiceCapabilitiesResponseStructure',
            'AbstractCapabilitiesStructure' => '\\StructType\\AbstractCapabilitiesStructure',
            'CapabilityGeneralInteractionStructure' => '\\StructType\\CapabilityGeneralInteractionStructure',
            'Interaction' => '\\StructType\\Interaction',
            'Delivery' => '\\StructType\\Delivery',
            'CapabilityRequestPolicyStructure' => '\\StructType\\CapabilityRequestPolicyStructure',
            'CapabilitySubscriptionPolicyStructure' => '\\StructType\\CapabilitySubscriptionPolicyStructure',
            'TransportDescriptionStructure' => '\\StructType\\TransportDescriptionStructure',
            'AbstractDiscoveryRequestStructure' => '\\StructType\\AbstractDiscoveryRequestStructure',
            'AbstractDiscoveryDeliveryStructure' => '\\StructType\\AbstractDiscoveryDeliveryStructure',
            'ContextualisedRequestStructure' => '\\StructType\\ContextualisedRequestStructure',
            'ServiceRequestContextStructure' => '\\StructType\\ServiceRequestContextStructure',
            'DataNameSpacesStructure' => '\\StructType\\DataNameSpacesStructure',
            'TerminateSubscriptionRequestStructure' => '\\StructType\\TerminateSubscriptionRequestStructure',
            'TerminateSubscriptionResponseStructure' => '\\StructType\\TerminateSubscriptionResponseStructure',
            'TerminationResponseStatusStructure' => '\\StructType\\TerminationResponseStatusStructure',
            'SubscriptionTerminatedNotificationStructure' => '\\StructType\\SubscriptionTerminatedNotificationStructure',
            'StatusResponseStructure' => '\\StructType\\StatusResponseStructure',
            'SubscriptionResponseStructure' => '\\StructType\\SubscriptionResponseStructure',
            'DataReadyRequestStructure' => '\\StructType\\DataReadyRequestStructure',
            'DataReadyResponseStructure' => '\\StructType\\DataReadyResponseStructure',
            'DataSupplyRequestStructure' => '\\StructType\\DataSupplyRequestStructure',
            'DataReceivedResponseStructure' => '\\StructType\\DataReceivedResponseStructure',
            'CheckStatusRequestStructure' => '\\StructType\\CheckStatusRequestStructure',
            'CheckStatusResponseStructure' => '\\StructType\\CheckStatusResponseStructure',
            'HeartbeatNotificationStructure' => '\\StructType\\HeartbeatNotificationStructure',
            'SubscriptionResponseBodyStructure' => '\\StructType\\SubscriptionResponseBodyStructure',
            'TerminateSubscriptionRequestBodyStructure' => '\\StructType\\TerminateSubscriptionRequestBodyStructure',
            'DataSupplyRequestBodyStructure' => '\\StructType\\DataSupplyRequestBodyStructure',
            'CheckStatusResponseBodyStructure' => '\\StructType\\CheckStatusResponseBodyStructure',
            'AllFacilitiesFeatureStructure' => '\\StructType\\AllFacilitiesFeatureStructure',
            'OperatorRefStructure' => '\\StructType\\OperatorRefStructure',
            'OrganisationRefStructure' => '\\StructType\\OrganisationRefStructure',
            'ClosedTimestampRangeStructure' => '\\StructType\\ClosedTimestampRangeStructure',
            'ClosedTimeRangeStructure' => '\\StructType\\ClosedTimeRangeStructure',
            'HalfOpenTimeRangeStructure' => '\\StructType\\HalfOpenTimeRangeStructure',
            'HalfOpenTimestampInputRangeStructure' => '\\StructType\\HalfOpenTimestampInputRangeStructure',
            'HalfOpenTimestampOutputRangeStructure' => '\\StructType\\HalfOpenTimestampOutputRangeStructure',
            'AccessibilityStructure' => '\\StructType\\AccessibilityStructure',
            'PassengerAccessibilityNeedsStructure' => '\\StructType\\PassengerAccessibilityNeedsStructure',
            'UserNeedStructure' => '\\StructType\\UserNeedStructure',
            'SuitabilityStructure' => '\\StructType\\SuitabilityStructure',
            'Extensions' => '\\StructType\\Extensions',
            'InfoLinkStructure' => '\\StructType\\InfoLinkStructure',
            'InfoLinksStructure' => '\\StructType\\InfoLinksStructure',
            'ValidityConditionStructure' => '\\StructType\\ValidityConditionStructure',
            'Timebands' => '\\StructType\\Timebands',
            'TimebandStructure' => '\\StructType\\TimebandStructure',
            'ValidityConditionsStructure' => '\\StructType\\ValidityConditionsStructure',
            'LimitationRefStructure' => '\\StructType\\LimitationRefStructure',
            'AccessibilityLimitationStructure' => '\\StructType\\AccessibilityLimitationStructure',
            'AccessibilityAssessmentStructure' => '\\StructType\\AccessibilityAssessmentStructure',
            'Limitations' => '\\StructType\\Limitations',
            'Suitabilities' => '\\StructType\\Suitabilities',
            'CountryRefStructure' => '\\StructType\\CountryRefStructure',
            'AdministratorRefStructure' => '\\StructType\\AdministratorRefStructure',
            'AdministratorVersionedRefStructure' => '\\StructType\\AdministratorVersionedRefStructure',
            'AdministrativeAreaRefStructure' => '\\StructType\\AdministrativeAreaRefStructure',
            'AdministrativeAreaVersionedRefStructure' => '\\StructType\\AdministrativeAreaVersionedRefStructure',
            'AdministrativeAreaRefsStructure' => '\\StructType\\AdministrativeAreaRefsStructure',
            'NamespaceTypeRefStructure' => '\\StructType\\NamespaceTypeRefStructure',
            'RegionRefStructure' => '\\StructType\\RegionRefStructure',
            'AuthorityRefStructure' => '\\StructType\\AuthorityRefStructure',
            'VersionedObjectStructure' => '\\StructType\\VersionedObjectStructure',
            'DataManagedObjectStructure' => '\\StructType\\DataManagedObjectStructure',
            'AbstractProjection' => '\\StructType\\AbstractProjection',
            'Features' => '\\StructType\\Features',
            'FeatureRefStructure' => '\\StructType\\FeatureRefStructure',
            'FeatureIdRefStructure' => '\\StructType\\FeatureIdRefStructure',
            'PointProjectionStructure' => '\\StructType\\PointProjectionStructure',
            'LinkProjectionStructure' => '\\StructType\\LinkProjectionStructure',
            'Line' => '\\StructType\\Line',
            'ZoneProjectionStructure' => '\\StructType\\ZoneProjectionStructure',
            'Boundary' => '\\StructType\\Boundary',
            'PathJunctionRefStructure' => '\\StructType\\PathJunctionRefStructure',
            'AccessLinkRefStructure' => '\\StructType\\AccessLinkRefStructure',
            'NavigationPathRefStructure' => '\\StructType\\NavigationPathRefStructure',
            'ProductCategoryRefStructure' => '\\StructType\\ProductCategoryRefStructure',
            'ServiceFeatureRefStructure' => '\\StructType\\ServiceFeatureRefStructure',
            'VehicleFeatureRefStructure' => '\\StructType\\VehicleFeatureRefStructure',
            'EquipmentRefStructure' => '\\StructType\\EquipmentRefStructure',
            'EquipmentTypeRefStructure' => '\\StructType\\EquipmentTypeRefStructure',
            'AbstractEquipmentStructure' => '\\StructType\\AbstractEquipmentStructure',
            'InstalledEquipmentStructure' => '\\StructType\\InstalledEquipmentStructure',
            'PlaceEquipmentStructure' => '\\StructType\\PlaceEquipmentStructure',
            'FeatureRefs' => '\\StructType\\FeatureRefs',
            'LocalServiceStructure' => '\\StructType\\LocalServiceStructure',
            'StopPlaceRefStructure' => '\\StructType\\StopPlaceRefStructure',
            'StopPlaceRefsStructure' => '\\StructType\\StopPlaceRefsStructure',
            'StopPlaceComponentRefStructure' => '\\StructType\\StopPlaceComponentRefStructure',
            'StopPlaceSpaceRefStructure' => '\\StructType\\StopPlaceSpaceRefStructure',
            'QuayRefStructure' => '\\StructType\\QuayRefStructure',
            'AccessSpaceRefStructure' => '\\StructType\\AccessSpaceRefStructure',
            'BoardingPositionRefStructure' => '\\StructType\\BoardingPositionRefStructure',
            'StopPlaceEntranceRefStructure' => '\\StructType\\StopPlaceEntranceRefStructure',
            'VehicleStoppingPlaceRefStructure' => '\\StructType\\VehicleStoppingPlaceRefStructure',
            'VehicleStoppingPositionRefStructure' => '\\StructType\\VehicleStoppingPositionRefStructure',
            'LevelRefStructure' => '\\StructType\\LevelRefStructure',
            'AccessPathLinkRefStructure' => '\\StructType\\AccessPathLinkRefStructure',
            'StopPathLinkRefStructure' => '\\StructType\\StopPathLinkRefStructure',
            'AliasStructure' => '\\StructType\\AliasStructure',
            'CheckPointRefStructure' => '\\StructType\\CheckPointRefStructure',
            'CheckPointStructure' => '\\StructType\\CheckPointStructure',
            'SituationRefStructure' => '\\StructType\\SituationRefStructure',
            'SituationSimpleRefStructure' => '\\StructType\\SituationSimpleRefStructure',
            'EntryQualifierStructure' => '\\StructType\\EntryQualifierStructure',
            'SituationVersion' => '\\StructType\\SituationVersion',
            'SituationFullRefStructure' => '\\StructType\\SituationFullRefStructure',
            'SituationSharedRefStructure' => '\\StructType\\SituationSharedRefStructure',
            'VersionRefStructure' => '\\StructType\\VersionRefStructure',
            'StopPointRefStructure' => '\\StructType\\StopPointRefStructure',
            'ClearDownRefStructure' => '\\StructType\\ClearDownRefStructure',
            'StopAreaRefStructure' => '\\StructType\\StopAreaRefStructure',
            'MonitoringRefStructure' => '\\StructType\\MonitoringRefStructure',
            'ConnectionLinkRefStructure' => '\\StructType\\ConnectionLinkRefStructure',
            'ModesStructure' => '\\StructType\\ModesStructure',
            'JourneyPatternRefStructure' => '\\StructType\\JourneyPatternRefStructure',
            'LineDirectionStructure' => '\\StructType\\LineDirectionStructure',
            'LineRefStructure' => '\\StructType\\LineRefStructure',
            'GroupOfLinesRefStructure' => '\\StructType\\GroupOfLinesRefStructure',
            'RouteRefStructure' => '\\StructType\\RouteRefStructure',
            'DirectionRefStructure' => '\\StructType\\DirectionRefStructure',
            'RouteLinkRefStructure' => '\\StructType\\RouteLinkRefStructure',
            'JourneyPlaceRefStructure' => '\\StructType\\JourneyPlaceRefStructure',
            'PlaceNameStructure' => '\\StructType\\PlaceNameStructure',
            'VehicleRefStructure' => '\\StructType\\VehicleRefStructure',
            'DriverRefStructure' => '\\StructType\\DriverRefStructure',
            'NoteStructure' => '\\StructType\\NoteStructure',
            'InfoChannelRefStructure' => '\\StructType\\InfoChannelRefStructure',
            'VehicleJourneyRefStructure' => '\\StructType\\VehicleJourneyRefStructure',
            'DatedVehicleJourneyRefStructure' => '\\StructType\\DatedVehicleJourneyRefStructure',
            'ConnectingJourneyRefStructure' => '\\StructType\\ConnectingJourneyRefStructure',
            'InterchangeRefStructure' => '\\StructType\\InterchangeRefStructure',
            'FramedVehicleJourneyRefStructure' => '\\StructType\\FramedVehicleJourneyRefStructure',
            'DataFrameRefStructure' => '\\StructType\\DataFrameRefStructure',
            'TrainPartRefStructure' => '\\StructType\\TrainPartRefStructure',
            'BlockRefStructure' => '\\StructType\\BlockRefStructure',
            'CourseOfJourneyRefStructure' => '\\StructType\\CourseOfJourneyRefStructure',
            'JourneyPartRefStructure' => '\\StructType\\JourneyPartRefStructure',
            'TrainNumberRefStructure' => '\\StructType\\TrainNumberRefStructure',
            'DestinationRefStructure' => '\\StructType\\DestinationRefStructure',
            'FacilityRefStructure' => '\\StructType\\FacilityRefStructure',
            'FacilityStructure' => '\\StructType\\FacilityStructure',
            'AnnotatedFacilityStructure' => '\\StructType\\AnnotatedFacilityStructure',
            'FacilityStatusStructure' => '\\StructType\\FacilityStatusStructure',
            'FacilityLocationStructure' => '\\StructType\\FacilityLocationStructure',
            'FacilityConditionStructure' => '\\StructType\\FacilityConditionStructure',
            'RemedyStructure' => '\\StructType\\RemedyStructure',
            'MonitoringInformationStructure' => '\\StructType\\MonitoringInformationStructure',
            'MonitoringValidityConditionStructure' => '\\StructType\\MonitoringValidityConditionStructure',
            'EquipmentAvailabilityStructure' => '\\StructType\\EquipmentAvailabilityStructure',
            'EquipmentFeatures' => '\\StructType\\EquipmentFeatures',
            'FacilityChangeStructure' => '\\StructType\\FacilityChangeStructure',
            'MobilityDisruptionStructure' => '\\StructType\\MobilityDisruptionStructure',
            'SimpleContactStructure' => '\\StructType\\SimpleContactStructure',
            'ViaNameStructure' => '\\StructType\\ViaNameStructure',
            'DestinationStructure' => '\\StructType\\DestinationStructure',
            'DirectionStructure' => '\\StructType\\DirectionStructure',
            'ProgressBetweenStopsStructure' => '\\StructType\\ProgressBetweenStopsStructure',
            'AbstractCallStructure' => '\\StructType\\AbstractCallStructure',
            'AbstractMonitoredCallStructure' => '\\StructType\\AbstractMonitoredCallStructure',
            'OnwardCallsStructure' => '\\StructType\\OnwardCallsStructure',
            'OnwardCallStructure' => '\\StructType\\OnwardCallStructure',
            'PredictionQualityStructure' => '\\StructType\\PredictionQualityStructure',
            'StopAssignmentStructure' => '\\StructType\\StopAssignmentStructure',
            'PlannedStopAssignmentStructure' => '\\StructType\\PlannedStopAssignmentStructure',
            'DatedVehicleJourneyStructure' => '\\StructType\\DatedVehicleJourneyStructure',
            'DatedCalls' => '\\StructType\\DatedCalls',
            'AbstractServiceJourneyInterchangeStructure' => '\\StructType\\AbstractServiceJourneyInterchangeStructure',
            'FromServiceJourneyInterchangeStructure' => '\\StructType\\FromServiceJourneyInterchangeStructure',
            'ToServiceJourneyInterchangeStructure' => '\\StructType\\ToServiceJourneyInterchangeStructure',
            'ServiceJourneyInterchangeStructure' => '\\StructType\\ServiceJourneyInterchangeStructure',
            'DatedCallStructure' => '\\StructType\\DatedCallStructure',
            'TargetedInterchangeStructure' => '\\StructType\\TargetedInterchangeStructure',
            'ContextualisedConnectionLinkStructure' => '\\StructType\\ContextualisedConnectionLinkStructure',
            'AbstractTopicPermissionStructure' => '\\StructType\\AbstractTopicPermissionStructure',
            'CapabilityAccessControlStructure' => '\\StructType\\CapabilityAccessControlStructure',
            'AbstractPermissionStructure' => '\\StructType\\AbstractPermissionStructure',
            'GeneralCapabilities' => '\\StructType\\GeneralCapabilities',
            'PermissionsStructure' => '\\StructType\\PermissionsStructure',
            'LinePermissions' => '\\StructType\\LinePermissions',
            'LinePermissionStructure' => '\\StructType\\LinePermissionStructure',
            'OperatorPermissions' => '\\StructType\\OperatorPermissions',
            'OperatorPermissionStructure' => '\\StructType\\OperatorPermissionStructure',
            'ConnectionLinkPermissions' => '\\StructType\\ConnectionLinkPermissions',
            'ConnectionLinkPermissionStructure' => '\\StructType\\ConnectionLinkPermissionStructure',
            'StopMonitorPermissionStructure' => '\\StructType\\StopMonitorPermissionStructure',
            'MonitoringCapabilityAccessControlStructure' => '\\StructType\\MonitoringCapabilityAccessControlStructure',
            'ConnectionServicePermissionStructure' => '\\StructType\\ConnectionServicePermissionStructure',
            'ConnectionCapabilityAccessControlStructure' => '\\StructType\\ConnectionCapabilityAccessControlStructure',
            'ProductionTimetableRequestStructure' => '\\StructType\\ProductionTimetableRequestStructure',
            'Lines' => '\\StructType\\Lines',
            'ProductionTimetableSubscriptionRequest' => '\\StructType\\ProductionTimetableSubscriptionRequest',
            'ProductionTimetableSubscriptionStructure' => '\\StructType\\ProductionTimetableSubscriptionStructure',
            'ProductionTimetableDeliveryStructure' => '\\StructType\\ProductionTimetableDeliveryStructure',
            'DatedTimetableVersionFrameStructure' => '\\StructType\\DatedTimetableVersionFrameStructure',
            'ProductionTimetableDeliveriesStructure' => '\\StructType\\ProductionTimetableDeliveriesStructure',
            'ProductionTimetableCapabilitiesRequest' => '\\StructType\\ProductionTimetableCapabilitiesRequest',
            'ProductionTimetableCapabilitiesResponseStructure' => '\\StructType\\ProductionTimetableCapabilitiesResponseStructure',
            'ProductionTimetableCapabilityRequestPolicyStructure' => '\\StructType\\ProductionTimetableCapabilityRequestPolicyStructure',
            'ProductionTimetableServiceCapabilitiesStructure' => '\\StructType\\ProductionTimetableServiceCapabilitiesStructure',
            'TopicFiltering' => '\\StructType\\TopicFiltering',
            'RequestPolicy' => '\\StructType\\RequestPolicy',
            'SubscriptionPolicy' => '\\StructType\\SubscriptionPolicy',
            'ProductionTimetablePermissions' => '\\StructType\\ProductionTimetablePermissions',
            'MonitoredVehicleJourneyStructure' => '\\StructType\\MonitoredVehicleJourneyStructure',
            'Origin' => '\\StructType\\Origin',
            'Via' => '\\StructType\\Via',
            'Destination' => '\\StructType\\Destination',
            'JourneyPartInfoStructure' => '\\StructType\\JourneyPartInfoStructure',
            'TrainBlockPartStructure' => '\\StructType\\TrainBlockPartStructure',
            'TrainNumbers' => '\\StructType\\TrainNumbers',
            'JourneyParts' => '\\StructType\\JourneyParts',
            'PreviousCallsStructure' => '\\StructType\\PreviousCallsStructure',
            'PreviousCallStructure' => '\\StructType\\PreviousCallStructure',
            'MonitoredCallStructure' => '\\StructType\\MonitoredCallStructure',
            'DatedVehicleJourneyIndirectRefStructure' => '\\StructType\\DatedVehicleJourneyIndirectRefStructure',
            'EstimatedServiceJourneyInterchangeStructure' => '\\StructType\\EstimatedServiceJourneyInterchangeStructure',
            'WillWaitStructure' => '\\StructType\\WillWaitStructure',
            'EstimatedVehicleJourneyStructure' => '\\StructType\\EstimatedVehicleJourneyStructure',
            'RecordedCalls' => '\\StructType\\RecordedCalls',
            'EstimatedCalls' => '\\StructType\\EstimatedCalls',
            'EstimatedCallStructure' => '\\StructType\\EstimatedCallStructure',
            'RecordedCallStructure' => '\\StructType\\RecordedCallStructure',
            'EstimatedTimetableRequestStructure' => '\\StructType\\EstimatedTimetableRequestStructure',
            'EstimatedTimetableSubscriptionStructure' => '\\StructType\\EstimatedTimetableSubscriptionStructure',
            'EstimatedTimetableDeliveryStructure' => '\\StructType\\EstimatedTimetableDeliveryStructure',
            'EstimatedVersionFrameStructure' => '\\StructType\\EstimatedVersionFrameStructure',
            'EstimatedTimetableDeliveriesStructure' => '\\StructType\\EstimatedTimetableDeliveriesStructure',
            'EstimatedTimetableCapabilitiesResponseStructure' => '\\StructType\\EstimatedTimetableCapabilitiesResponseStructure',
            'EstimatedTimetableCapabilityRequestPolicyStructure' => '\\StructType\\EstimatedTimetableCapabilityRequestPolicyStructure',
            'EstimatedTimetableServiceCapabilitiesStructure' => '\\StructType\\EstimatedTimetableServiceCapabilitiesStructure',
            'EstimatedTimetablePermissions' => '\\StructType\\EstimatedTimetablePermissions',
            'TargetedVehicleJourneyStructure' => '\\StructType\\TargetedVehicleJourneyStructure',
            'TargetedCallStructure' => '\\StructType\\TargetedCallStructure',
            'StopTimetableRequestStructure' => '\\StructType\\StopTimetableRequestStructure',
            'StopTimetableSubscriptionStructure' => '\\StructType\\StopTimetableSubscriptionStructure',
            'StopTimetableDeliveryStructure' => '\\StructType\\StopTimetableDeliveryStructure',
            'TimetabledStopVisitStructure' => '\\StructType\\TimetabledStopVisitStructure',
            'TimetabledStopVisitCancellationStructure' => '\\StructType\\TimetabledStopVisitCancellationStructure',
            'StopTimetableDeliveriesStructure' => '\\StructType\\StopTimetableDeliveriesStructure',
            'StopTimetableCapabilitiesResponseStructure' => '\\StructType\\StopTimetableCapabilitiesResponseStructure',
            'StopTimetableServiceCapabilitiesStructure' => '\\StructType\\StopTimetableServiceCapabilitiesStructure',
            'AccessControl' => '\\StructType\\AccessControl',
            'StopTimetableCapabilityRequestPolicyStructure' => '\\StructType\\StopTimetableCapabilityRequestPolicyStructure',
            'StopTimetablePermissions' => '\\StructType\\StopTimetablePermissions',
            'StopTimetableServicePermissionStructure' => '\\StructType\\StopTimetableServicePermissionStructure',
            'StopMonitorPermissions' => '\\StructType\\StopMonitorPermissions',
            'MaximumNumberOfCalls' => '\\StructType\\MaximumNumberOfCalls',
            'StopMonitoringRequestStructure' => '\\StructType\\StopMonitoringRequestStructure',
            'StopMonitoringMultipleRequestStructure' => '\\StructType\\StopMonitoringMultipleRequestStructure',
            'StopMonitoringFilterStructure' => '\\StructType\\StopMonitoringFilterStructure',
            'StopMonitoringSubscriptionStructure' => '\\StructType\\StopMonitoringSubscriptionStructure',
            'StopMonitoringDeliveryStructure' => '\\StructType\\StopMonitoringDeliveryStructure',
            'MonitoredStopVisitStructure' => '\\StructType\\MonitoredStopVisitStructure',
            'MonitoredStopVisitCancellationStructure' => '\\StructType\\MonitoredStopVisitCancellationStructure',
            'StopLineNoticeStructure' => '\\StructType\\StopLineNoticeStructure',
            'DeliveryVariantStructure' => '\\StructType\\DeliveryVariantStructure',
            'StopLineNoticeCancellationStructure' => '\\StructType\\StopLineNoticeCancellationStructure',
            'StopNoticeStructure' => '\\StructType\\StopNoticeStructure',
            'StopNoticeCancellationStructure' => '\\StructType\\StopNoticeCancellationStructure',
            'ServiceExceptionStructure' => '\\StructType\\ServiceExceptionStructure',
            'StopMonitoringDeliveriesStructure' => '\\StructType\\StopMonitoringDeliveriesStructure',
            'StopMonitoringCapabilitiesResponseStructure' => '\\StructType\\StopMonitoringCapabilitiesResponseStructure',
            'StopMonitoringServiceCapabilitiesStructure' => '\\StructType\\StopMonitoringServiceCapabilitiesStructure',
            'ResponseFeatures' => '\\StructType\\ResponseFeatures',
            'StopMonitoringCapabilityRequestPolicyStructure' => '\\StructType\\StopMonitoringCapabilityRequestPolicyStructure',
            'StopMonitoringPermissions' => '\\StructType\\StopMonitoringPermissions',
            'StopMonitoringServicePermissionStructure' => '\\StructType\\StopMonitoringServicePermissionStructure',
            'VehicleMonitoringRequestStructure' => '\\StructType\\VehicleMonitoringRequestStructure',
            'VehicleMonitoringSubscriptionStructure' => '\\StructType\\VehicleMonitoringSubscriptionStructure',
            'VehicleMonitoringDeliveryStructure' => '\\StructType\\VehicleMonitoringDeliveryStructure',
            'VehicleActivityStructure' => '\\StructType\\VehicleActivityStructure',
            'MonitoredVehicleJourney' => '\\StructType\\MonitoredVehicleJourney',
            'VehicleMonitoringRefStructure' => '\\StructType\\VehicleMonitoringRefStructure',
            'VehicleActivityCancellationStructure' => '\\StructType\\VehicleActivityCancellationStructure',
            'VehicleMonitoringDeliveriesStructure' => '\\StructType\\VehicleMonitoringDeliveriesStructure',
            'VehicleMonitoringCapabilityRequestPolicyStructure' => '\\StructType\\VehicleMonitoringCapabilityRequestPolicyStructure',
            'VehicleMonitoringCapabilitiesResponseStructure' => '\\StructType\\VehicleMonitoringCapabilitiesResponseStructure',
            'VehicleMonitoringServiceCapabilitiesStructure' => '\\StructType\\VehicleMonitoringServiceCapabilitiesStructure',
            'VehicleMonitoringPermissions' => '\\StructType\\VehicleMonitoringPermissions',
            'VehicleMonitoringServicePermissionStructure' => '\\StructType\\VehicleMonitoringServicePermissionStructure',
            'VehicleMonitorPermissionStructure' => '\\StructType\\VehicleMonitorPermissionStructure',
            'InterchangeJourneyStructure' => '\\StructType\\InterchangeJourneyStructure',
            'ConnectionTimetableRequestStructure' => '\\StructType\\ConnectionTimetableRequestStructure',
            'ConnectionTimetableSubscriptionStructure' => '\\StructType\\ConnectionTimetableSubscriptionStructure',
            'ConnectionTimetableDeliveryStructure' => '\\StructType\\ConnectionTimetableDeliveryStructure',
            'AbstractFeederItemStructure' => '\\StructType\\AbstractFeederItemStructure',
            'TimetabledFeederArrivalStructure' => '\\StructType\\TimetabledFeederArrivalStructure',
            'TimetabledFeederArrivalCancellationStructure' => '\\StructType\\TimetabledFeederArrivalCancellationStructure',
            'ConnectionTimetableDeliveriesStructure' => '\\StructType\\ConnectionTimetableDeliveriesStructure',
            'ConnectionTimetableCapabilitiesResponseStructure' => '\\StructType\\ConnectionTimetableCapabilitiesResponseStructure',
            'ConnectionTimetablePermissions' => '\\StructType\\ConnectionTimetablePermissions',
            'ConnectionTimetableCapabilityRequestPolicyStructure' => '\\StructType\\ConnectionTimetableCapabilityRequestPolicyStructure',
            'ConnectionTimetableServiceCapabilitiesStructure' => '\\StructType\\ConnectionTimetableServiceCapabilitiesStructure',
            'ConnectionMonitoringRequestStructure' => '\\StructType\\ConnectionMonitoringRequestStructure',
            'ConnectingJourneyFilterStructure' => '\\StructType\\ConnectingJourneyFilterStructure',
            'ConnectingTimeFilterStructure' => '\\StructType\\ConnectingTimeFilterStructure',
            'ConnectionMonitoringSubscriptionRequestStructure' => '\\StructType\\ConnectionMonitoringSubscriptionRequestStructure',
            'ConnectionMonitoringFeederDeliveryStructure' => '\\StructType\\ConnectionMonitoringFeederDeliveryStructure',
            'MonitoredFeederArrivalStructure' => '\\StructType\\MonitoredFeederArrivalStructure',
            'MonitoredFeederArrivalCancellationStructure' => '\\StructType\\MonitoredFeederArrivalCancellationStructure',
            'ConnectionMonitoringDistributorDeliveryStructure' => '\\StructType\\ConnectionMonitoringDistributorDeliveryStructure',
            'AbstractDistributorItemStructure' => '\\StructType\\AbstractDistributorItemStructure',
            'DistributorDepartureCancellationStructure' => '\\StructType\\DistributorDepartureCancellationStructure',
            'WaitProlongedDepartureStructure' => '\\StructType\\WaitProlongedDepartureStructure',
            'StoppingPositionChangedDepartureStructure' => '\\StructType\\StoppingPositionChangedDepartureStructure',
            'ConnectionMonitoringDeliveriesStructure' => '\\StructType\\ConnectionMonitoringDeliveriesStructure',
            'ConnectionMonitoringCapabilitiesResponseStructure' => '\\StructType\\ConnectionMonitoringCapabilitiesResponseStructure',
            'ConnectionMonitoringCapabilityRequestPolicyStructure' => '\\StructType\\ConnectionMonitoringCapabilityRequestPolicyStructure',
            'ConnectionMonitoringServiceCapabilitiesStructure' => '\\StructType\\ConnectionMonitoringServiceCapabilitiesStructure',
            'ConnectionMonitoringPermissions' => '\\StructType\\ConnectionMonitoringPermissions',
            'GeneralMessageRequestStructure' => '\\StructType\\GeneralMessageRequestStructure',
            'GeneralMessageSubscriptionStructure' => '\\StructType\\GeneralMessageSubscriptionStructure',
            'GeneralMessageDeliveryStructure' => '\\StructType\\GeneralMessageDeliveryStructure',
            'InfoMessageStructure' => '\\StructType\\InfoMessageStructure',
            'InfoMessageCancellationStructure' => '\\StructType\\InfoMessageCancellationStructure',
            'InfoMessageRefStructure' => '\\StructType\\InfoMessageRefStructure',
            'GeneralMessageDeliveriesStructure' => '\\StructType\\GeneralMessageDeliveriesStructure',
            'GeneralMessageCapabilitiesResponseStructure' => '\\StructType\\GeneralMessageCapabilitiesResponseStructure',
            'GeneralMessageServiceCapabilitiesStructure' => '\\StructType\\GeneralMessageServiceCapabilitiesStructure',
            'GeneralMessagePermissions' => '\\StructType\\GeneralMessagePermissions',
            'GeneralMessageServicePermissionStructure' => '\\StructType\\GeneralMessageServicePermissionStructure',
            'InfoChannelPermissions' => '\\StructType\\InfoChannelPermissions',
            'GeneralMessageCapabilityAccessControlStructure' => '\\StructType\\GeneralMessageCapabilityAccessControlStructure',
            'InfoChannelPermissionStructure' => '\\StructType\\InfoChannelPermissionStructure',
            'FacilityMonitoringRequestStructure' => '\\StructType\\FacilityMonitoringRequestStructure',
            'AccessibilityNeedsFilterStructure' => '\\StructType\\AccessibilityNeedsFilterStructure',
            'FacilityMonitoringSubscriptionStructure' => '\\StructType\\FacilityMonitoringSubscriptionStructure',
            'FacilityMonitoringDeliveryStructure' => '\\StructType\\FacilityMonitoringDeliveryStructure',
            'FacilityMonitoringDeliveriesStructure' => '\\StructType\\FacilityMonitoringDeliveriesStructure',
            'FacilityMonitoringCapabilitiesResponseStructure' => '\\StructType\\FacilityMonitoringCapabilitiesResponseStructure',
            'FacilityMonitoringServiceCapabilitiesStructure' => '\\StructType\\FacilityMonitoringServiceCapabilitiesStructure',
            'FacilityMonitoringPermissions' => '\\StructType\\FacilityMonitoringPermissions',
            'FacilityMonitoringServicePermissionStructure' => '\\StructType\\FacilityMonitoringServicePermissionStructure',
            'AbnormalTraffic' => '\\StructType\\AbnormalTraffic',
            'Accident' => '\\StructType\\Accident',
            'Activity' => '\\StructType\\Activity',
            'AlertCArea' => '\\StructType\\AlertCArea',
            'AlertCDirection' => '\\StructType\\AlertCDirection',
            'AlertCLinear' => '\\StructType\\AlertCLinear',
            'AlertCLinearByCode' => '\\StructType\\AlertCLinearByCode',
            'AlertCLocation' => '\\StructType\\AlertCLocation',
            'AlertCMethod2Linear' => '\\StructType\\AlertCMethod2Linear',
            'AlertCMethod2Point' => '\\StructType\\AlertCMethod2Point',
            'AlertCMethod2PrimaryPointLocation' => '\\StructType\\AlertCMethod2PrimaryPointLocation',
            'AlertCMethod2SecondaryPointLocation' => '\\StructType\\AlertCMethod2SecondaryPointLocation',
            'AlertCMethod4Linear' => '\\StructType\\AlertCMethod4Linear',
            'AlertCMethod4Point' => '\\StructType\\AlertCMethod4Point',
            'AlertCMethod4PrimaryPointLocation' => '\\StructType\\AlertCMethod4PrimaryPointLocation',
            'AlertCMethod4SecondaryPointLocation' => '\\StructType\\AlertCMethod4SecondaryPointLocation',
            'AlertCPoint' => '\\StructType\\AlertCPoint',
            'AnimalPresenceObstruction' => '\\StructType\\AnimalPresenceObstruction',
            'Area' => '\\StructType\\Area',
            'AreaDestination' => '\\StructType\\AreaDestination',
            'AuthorityOperation' => '\\StructType\\AuthorityOperation',
            'AxleSpacing' => '\\StructType\\AxleSpacing',
            'AxleWeight' => '\\StructType\\AxleWeight',
            'BasicDataValue' => '\\StructType\\BasicDataValue',
            'CarParks' => '\\StructType\\CarParks',
            'CatalogueReference' => '\\StructType\\CatalogueReference',
            'Cause' => '\\StructType\\Cause',
            'Comment' => '\\StructType\\Comment',
            'Conditions' => '\\StructType\\Conditions',
            'ConstructionWorks' => '\\StructType\\ConstructionWorks',
            'D2LogicalModel' => '\\StructType\\D2LogicalModel',
            'DayWeekMonth' => '\\StructType\\DayWeekMonth',
            'Delays' => '\\StructType\\Delays',
            'DisturbanceActivity' => '\\StructType\\DisturbanceActivity',
            'ElaboratedData' => '\\StructType\\ElaboratedData',
            'ElaboratedDataPublication' => '\\StructType\\ElaboratedDataPublication',
            'EnvironmentalObstruction' => '\\StructType\\EnvironmentalObstruction',
            'EquipmentOrSystemFault' => '\\StructType\\EquipmentOrSystemFault',
            'Exchange' => '\\StructType\\Exchange',
            'ExtensionType' => '\\StructType\\ExtensionType',
            'ExternalReferencing' => '\\StructType\\ExternalReferencing',
            'FilterExitManagement' => '\\StructType\\FilterExitManagement',
            'FilterReference' => '\\StructType\\FilterReference',
            'GeneralInstructionToRoadUsers' => '\\StructType\\GeneralInstructionToRoadUsers',
            'GeneralNetworkManagement' => '\\StructType\\GeneralNetworkManagement',
            'GeneralObstruction' => '\\StructType\\GeneralObstruction',
            'GenericPublication' => '\\StructType\\GenericPublication',
            'GenericSituationRecord' => '\\StructType\\GenericSituationRecord',
            'GrossWeightCharacteristic' => '\\StructType\\GrossWeightCharacteristic',
            'GroupOfLocations' => '\\StructType\\GroupOfLocations',
            'GroupOfLocationsByReference' => '\\StructType\\GroupOfLocationsByReference',
            'GroupOfNonOrderedLocations' => '\\StructType\\GroupOfNonOrderedLocations',
            'GroupOfPeopleInvolved' => '\\StructType\\GroupOfPeopleInvolved',
            'GroupOfVehiclesInvolved' => '\\StructType\\GroupOfVehiclesInvolved',
            'HazardousMaterials' => '\\StructType\\HazardousMaterials',
            'HeaderInformation' => '\\StructType\\HeaderInformation',
            'HeaviestAxleWeightCharacteristic' => '\\StructType\\HeaviestAxleWeightCharacteristic',
            'HeightCharacteristic' => '\\StructType\\HeightCharacteristic',
            'Humidity' => '\\StructType\\Humidity',
            'HumidityInformation' => '\\StructType\\HumidityInformation',
            'Impact' => '\\StructType\\Impact',
            'IndividualVehicleMeasurements' => '\\StructType\\IndividualVehicleMeasurements',
            'InfrastructureDamageObstruction' => '\\StructType\\InfrastructureDamageObstruction',
            'InternationalIdentifier' => '\\StructType\\InternationalIdentifier',
            'Itinerary' => '\\StructType\\Itinerary',
            'locationContainedInItinerary' => '\\StructType\\LocationContainedInItinerary',
            'LengthCharacteristic' => '\\StructType\\LengthCharacteristic',
            'LifeCycleManagement' => '\\StructType\\LifeCycleManagement',
            'Linear' => '\\StructType\\Linear',
            'LinearTrafficView' => '\\StructType\\LinearTrafficView',
            'Location' => '\\StructType\\Location',
            'LocationByReference' => '\\StructType\\LocationByReference',
            'LocationCharacteristicsOverride' => '\\StructType\\LocationCharacteristicsOverride',
            'MaintenanceVehicles' => '\\StructType\\MaintenanceVehicles',
            'MaintenanceWorks' => '\\StructType\\MaintenanceWorks',
            'ManagedCause' => '\\StructType\\ManagedCause',
            'Management' => '\\StructType\\Management',
            'MatrixSignSetting' => '\\StructType\\MatrixSignSetting',
            'MeasuredDataPublication' => '\\StructType\\MeasuredDataPublication',
            'MeasuredValue' => '\\StructType\\MeasuredValue',
            'MeasurementSiteRecord' => '\\StructType\\MeasurementSiteRecord',
            'measurementSpecificCharacteristics' => '\\StructType\\MeasurementSpecificCharacteristics',
            'MeasurementSiteTable' => '\\StructType\\MeasurementSiteTable',
            'MeasurementSiteTablePublication' => '\\StructType\\MeasurementSiteTablePublication',
            'MeasurementSpecificCharacteristics' => '\\StructType\\MeasurementSpecificCharacteristics_1',
            'Mobility' => '\\StructType\\Mobility',
            'MultilingualString' => '\\StructType\\MultilingualString',
            'values' => '\\StructType\\Values',
            'MultilingualStringValue' => '\\StructType\\MultilingualStringValue',
            'NetworkLocation' => '\\StructType\\NetworkLocation',
            'NetworkManagement' => '\\StructType\\NetworkManagement',
            'NonManagedCause' => '\\StructType\\NonManagedCause',
            'NonRoadEventInformation' => '\\StructType\\NonRoadEventInformation',
            'NonWeatherRelatedRoadConditions' => '\\StructType\\NonWeatherRelatedRoadConditions',
            'NumberOfAxlesCharacteristic' => '\\StructType\\NumberOfAxlesCharacteristic',
            'Obstruction' => '\\StructType\\Obstruction',
            'OffsetDistance' => '\\StructType\\OffsetDistance',
            'OperatorAction' => '\\StructType\\OperatorAction',
            'OverallPeriod' => '\\StructType\\OverallPeriod',
            'PayloadPublication' => '\\StructType\\PayloadPublication',
            'Period' => '\\StructType\\Period',
            'Point' => '\\StructType\\Point',
            'PointByCoordinates' => '\\StructType\\PointByCoordinates',
            'PointCoordinates' => '\\StructType\\PointCoordinates',
            'PointDestination' => '\\StructType\\PointDestination',
            'PollutionInformation' => '\\StructType\\PollutionInformation',
            'PollutionMeasurement' => '\\StructType\\PollutionMeasurement',
            'PoorEnvironmentConditions' => '\\StructType\\PoorEnvironmentConditions',
            'PrecipitationDetail' => '\\StructType\\PrecipitationDetail',
            'PrecipitationInformation' => '\\StructType\\PrecipitationInformation',
            'PredefinedLocation' => '\\StructType\\PredefinedLocation',
            'PredefinedLocationSet' => '\\StructType\\PredefinedLocationSet',
            'PredefinedLocationsPublication' => '\\StructType\\PredefinedLocationsPublication',
            'PublicEvent' => '\\StructType\\PublicEvent',
            'ReferenceSettings' => '\\StructType\\ReferenceSettings',
            'ReroutingManagement' => '\\StructType\\ReroutingManagement',
            'RoadConditions' => '\\StructType\\RoadConditions',
            'RoadOperatorServiceDisruption' => '\\StructType\\RoadOperatorServiceDisruption',
            'RoadOrCarriagewayOrLaneManagement' => '\\StructType\\RoadOrCarriagewayOrLaneManagement',
            'RoadsideAssistance' => '\\StructType\\RoadsideAssistance',
            'RoadsideReferencePoint' => '\\StructType\\RoadsideReferencePoint',
            'RoadsideReferencePointLinear' => '\\StructType\\RoadsideReferencePointLinear',
            'RoadsideReferencePointPrimaryLocation' => '\\StructType\\RoadsideReferencePointPrimaryLocation',
            'RoadsideReferencePointSecondaryLocation' => '\\StructType\\RoadsideReferencePointSecondaryLocation',
            'RoadsideServiceDisruption' => '\\StructType\\RoadsideServiceDisruption',
            'RoadSurfaceConditionInformation' => '\\StructType\\RoadSurfaceConditionInformation',
            'RoadSurfaceConditionMeasurements' => '\\StructType\\RoadSurfaceConditionMeasurements',
            'Roadworks' => '\\StructType\\Roadworks',
            'SignSetting' => '\\StructType\\SignSetting',
            'SiteMeasurements' => '\\StructType\\SiteMeasurements',
            'measuredValue' => '\\StructType\\MeasuredValue_1',
            'Situation' => '\\StructType\\Situation',
            'SituationPublication' => '\\StructType\\SituationPublication',
            'SituationRecord' => '\\StructType\\SituationRecord',
            'Source' => '\\StructType\\Source',
            'SpeedManagement' => '\\StructType\\SpeedManagement',
            'SpeedPercentile' => '\\StructType\\SpeedPercentile',
            'Subjects' => '\\StructType\\Subjects',
            'Subscription' => '\\StructType\\Subscription',
            'SupplementaryPositionalDescription' => '\\StructType\\SupplementaryPositionalDescription',
            'Target' => '\\StructType\\Target',
            'Temperature' => '\\StructType\\Temperature',
            'TemperatureInformation' => '\\StructType\\TemperatureInformation',
            'TimePeriodByHour' => '\\StructType\\TimePeriodByHour',
            'TimePeriodOfDay' => '\\StructType\\TimePeriodOfDay',
            'TpegAreaDescriptor' => '\\StructType\\TpegAreaDescriptor',
            'TpegAreaLocation' => '\\StructType\\TpegAreaLocation',
            'TpegDescriptor' => '\\StructType\\TpegDescriptor',
            'TpegFramedPoint' => '\\StructType\\TpegFramedPoint',
            'TpegGeometricArea' => '\\StructType\\TpegGeometricArea',
            'TpegHeight' => '\\StructType\\TpegHeight',
            'TpegIlcPointDescriptor' => '\\StructType\\TpegIlcPointDescriptor',
            'TpegJunction' => '\\StructType\\TpegJunction',
            'TpegJunctionPointDescriptor' => '\\StructType\\TpegJunctionPointDescriptor',
            'TpegLinearLocation' => '\\StructType\\TpegLinearLocation',
            'TpegNamedOnlyArea' => '\\StructType\\TpegNamedOnlyArea',
            'TpegNonJunctionPoint' => '\\StructType\\TpegNonJunctionPoint',
            'TpegOtherPointDescriptor' => '\\StructType\\TpegOtherPointDescriptor',
            'TpegPoint' => '\\StructType\\TpegPoint',
            'TpegPointDescriptor' => '\\StructType\\TpegPointDescriptor',
            'TpegPointLocation' => '\\StructType\\TpegPointLocation',
            'TpegSimplePoint' => '\\StructType\\TpegSimplePoint',
            'TrafficConcentration' => '\\StructType\\TrafficConcentration',
            'TrafficElement' => '\\StructType\\TrafficElement',
            'TrafficFlow' => '\\StructType\\TrafficFlow',
            'TrafficHeadway' => '\\StructType\\TrafficHeadway',
            'TrafficSpeed' => '\\StructType\\TrafficSpeed',
            'TrafficStatusValue' => '\\StructType\\TrafficStatusValue',
            'TrafficValue' => '\\StructType\\TrafficValue',
            'TrafficView' => '\\StructType\\TrafficView',
            'TrafficViewPublication' => '\\StructType\\TrafficViewPublication',
            'TrafficViewRecord' => '\\StructType\\TrafficViewRecord',
            'TransitInformation' => '\\StructType\\TransitInformation',
            'TravelTimeValue' => '\\StructType\\TravelTimeValue',
            'UrlLink' => '\\StructType\\UrlLink',
            'Validity' => '\\StructType\\Validity',
            'VariableMessageSignSetting' => '\\StructType\\VariableMessageSignSetting',
            'Vehicle' => '\\StructType\\Vehicle',
            'VehicleCharacteristics' => '\\StructType\\VehicleCharacteristics',
            'VehicleDetectionTime' => '\\StructType\\VehicleDetectionTime',
            'VehicleHeadway' => '\\StructType\\VehicleHeadway',
            'VehicleObstruction' => '\\StructType\\VehicleObstruction',
            'VehicleSpeed' => '\\StructType\\VehicleSpeed',
            'Visibility' => '\\StructType\\Visibility',
            'VisibilityInformation' => '\\StructType\\VisibilityInformation',
            'WeatherRelatedRoadConditions' => '\\StructType\\WeatherRelatedRoadConditions',
            'WeatherValue' => '\\StructType\\WeatherValue',
            'WidthCharacteristic' => '\\StructType\\WidthCharacteristic',
            'Wind' => '\\StructType\\Wind',
            'WindInformation' => '\\StructType\\WindInformation',
            'WinterDrivingManagement' => '\\StructType\\WinterDrivingManagement',
            'AffectedStopPointStructure' => '\\StructType\\AffectedStopPointStructure',
            'ConnectionLinks' => '\\StructType\\ConnectionLinks',
            'AffectedModesStructure' => '\\StructType\\AffectedModesStructure',
            'Mode' => '\\StructType\\Mode',
            'ZoneRefStructure' => '\\StructType\\ZoneRefStructure',
            'AffectedConnectionLinkStructure' => '\\StructType\\AffectedConnectionLinkStructure',
            'AffectedPathLinkStructure' => '\\StructType\\AffectedPathLinkStructure',
            'AffectedInterchangeStructure' => '\\StructType\\AffectedInterchangeStructure',
            'NetworkRefStructure' => '\\StructType\\NetworkRefStructure',
            'OperationalUnitRefStructure' => '\\StructType\\OperationalUnitRefStructure',
            'AffectedOperatorStructure' => '\\StructType\\AffectedOperatorStructure',
            'NetworkStructure' => '\\StructType\\NetworkStructure',
            'SectionRefStructure' => '\\StructType\\SectionRefStructure',
            'AdviceRefStructure' => '\\StructType\\AdviceRefStructure',
            'OffsetStructure' => '\\StructType\\OffsetStructure',
            'AffectedNetworkStructure' => '\\StructType\\AffectedNetworkStructure',
            'AffectedLineStructure' => '\\StructType\\AffectedLineStructure',
            'Routes' => '\\StructType\\Routes',
            'Sections' => '\\StructType\\Sections',
            'AffectedSectionStructure' => '\\StructType\\AffectedSectionStructure',
            'AffectedRouteStructure' => '\\StructType\\AffectedRouteStructure',
            'StopPoints' => '\\StructType\\StopPoints',
            'RouteLinks' => '\\StructType\\RouteLinks',
            'AffectedVehicleJourneyStructure' => '\\StructType\\AffectedVehicleJourneyStructure',
            'Calls' => '\\StructType\\Calls',
            'Facilities' => '\\StructType\\Facilities',
            'AffectedVehicleStructure' => '\\StructType\\AffectedVehicleStructure',
            'AffectedCallStructure' => '\\StructType\\AffectedCallStructure',
            'AffectedFacilityStructure' => '\\StructType\\AffectedFacilityStructure',
            'AffectedPlaceStructure' => '\\StructType\\AffectedPlaceStructure',
            'AffectedStopPlaceElementStructure' => '\\StructType\\AffectedStopPlaceElementStructure',
            'AffectedStopPlaceStructure' => '\\StructType\\AffectedStopPlaceStructure',
            'AffectedFacilities' => '\\StructType\\AffectedFacilities',
            'AffectedComponents' => '\\StructType\\AffectedComponents',
            'AffectedNavigationPaths' => '\\StructType\\AffectedNavigationPaths',
            'AffectedStopPlaceComponentStructure' => '\\StructType\\AffectedStopPlaceComponentStructure',
            'CasualtiesStructure' => '\\StructType\\CasualtiesStructure',
            'ActionsStructure' => '\\StructType\\ActionsStructure',
            'SimpleActionStructure' => '\\StructType\\SimpleActionStructure',
            'ParameterisedActionStructure' => '\\StructType\\ParameterisedActionStructure',
            'PushedActionStructure' => '\\StructType\\PushedActionStructure',
            'BeforeNotices' => '\\StructType\\BeforeNotices',
            'ActionDataStructure' => '\\StructType\\ActionDataStructure',
            'PublishToWebActionStructure' => '\\StructType\\PublishToWebActionStructure',
            'PublishToMobileActionStructure' => '\\StructType\\PublishToMobileActionStructure',
            'PublishToDisplayActionStructure' => '\\StructType\\PublishToDisplayActionStructure',
            'PublishToAlertsActionStructure' => '\\StructType\\PublishToAlertsActionStructure',
            'PublishToTvActionStructure' => '\\StructType\\PublishToTvActionStructure',
            'ManualAction' => '\\StructType\\ManualAction',
            'ManualActionStructure' => '\\StructType\\ManualActionStructure',
            'NotifyBySmsActionStructure' => '\\StructType\\NotifyBySmsActionStructure',
            'NotifyByEmailActionStructure' => '\\StructType\\NotifyByEmailActionStructure',
            'NotifyByPagerActionStructure' => '\\StructType\\NotifyByPagerActionStructure',
            'NotifyUserActionStructure' => '\\StructType\\NotifyUserActionStructure',
            'AbstractSituationElementStructure' => '\\StructType\\AbstractSituationElementStructure',
            'SituationElementStructure' => '\\StructType\\SituationElementStructure',
            'ReferencesStructure' => '\\StructType\\ReferencesStructure',
            'RelatedSituationStructure' => '\\StructType\\RelatedSituationStructure',
            'PtSituationElementStructure' => '\\StructType\\PtSituationElementStructure',
            'RoadSituationElementStructure' => '\\StructType\\RoadSituationElementStructure',
            'AffectedRoadStructure' => '\\StructType\\AffectedRoadStructure',
            'OptionalTrafficElementStructure' => '\\StructType\\OptionalTrafficElementStructure',
            'SituationSourceStructure' => '\\StructType\\SituationSourceStructure',
            'Repetitions' => '\\StructType\\Repetitions',
            'SecondaryReasons' => '\\StructType\\SecondaryReasons',
            'Reason' => '\\StructType\\Reason',
            'AffectsScopeStructure' => '\\StructType\\AffectsScopeStructure',
            'Operators' => '\\StructType\\Operators',
            'Networks' => '\\StructType\\Networks',
            'AffectedNetwork' => '\\StructType\\AffectedNetwork',
            'StopPlaces' => '\\StructType\\StopPlaces',
            'Places' => '\\StructType\\Places',
            'VehicleJourneys' => '\\StructType\\VehicleJourneys',
            'Vehicles' => '\\StructType\\Vehicles',
            'AffectedRoadsStructure' => '\\StructType\\AffectedRoadsStructure',
            'ImageStructure' => '\\StructType\\ImageStructure',
            'Images' => '\\StructType\\Images',
            'Image' => '\\StructType\\Image',
            'InfoLinks' => '\\StructType\\InfoLinks',
            'DefaultedTextStructure' => '\\StructType\\DefaultedTextStructure',
            'PtConsequencesStructure' => '\\StructType\\PtConsequencesStructure',
            'PtConsequenceStructure' => '\\StructType\\PtConsequenceStructure',
            'BoardingStructure' => '\\StructType\\BoardingStructure',
            'PtAdviceStructure' => '\\StructType\\PtAdviceStructure',
            'BlockingStructure' => '\\StructType\\BlockingStructure',
            'EasementsStructure' => '\\StructType\\EasementsStructure',
            'DelaysStructure' => '\\StructType\\DelaysStructure',
            'SituationExchangeRequestStructure' => '\\StructType\\SituationExchangeRequestStructure',
            'SituationRoadFilter' => '\\StructType\\SituationRoadFilter',
            'RoadFilterStructure' => '\\StructType\\RoadFilterStructure',
            'SituationExchangeSubscriptionStructure' => '\\StructType\\SituationExchangeSubscriptionStructure',
            'Situations' => '\\StructType\\Situations',
            'SituationExchangeDeliveryStructure' => '\\StructType\\SituationExchangeDeliveryStructure',
            'ContextStructure' => '\\StructType\\ContextStructure',
            'NetworkContextStructure' => '\\StructType\\NetworkContextStructure',
            'SituationExchangeDeliveriesStructure' => '\\StructType\\SituationExchangeDeliveriesStructure',
            'SituationExchangeCapabilitiesResponseStructure' => '\\StructType\\SituationExchangeCapabilitiesResponseStructure',
            'SituationExchangeServiceCapabilitiesStructure' => '\\StructType\\SituationExchangeServiceCapabilitiesStructure',
            'SituationExchangePermissions' => '\\StructType\\SituationExchangePermissions',
            'SituationExchangeServicePermissionStructure' => '\\StructType\\SituationExchangeServicePermissionStructure',
            'ProductCategoryStructure' => '\\StructType\\ProductCategoryStructure',
            'ServiceFeatureStructure' => '\\StructType\\ServiceFeatureStructure',
            'VehicleFeaturesStructure' => '\\StructType\\VehicleFeaturesStructure',
            'AnnotatedStopPointStructure' => '\\StructType\\AnnotatedStopPointStructure',
            'AnnotatedLineStructure' => '\\StructType\\AnnotatedLineStructure',
            'Destinations' => '\\StructType\\Destinations',
            'Directions' => '\\StructType\\Directions',
            'RouteDirectionStructure' => '\\StructType\\RouteDirectionStructure',
            'JourneyPatterns' => '\\StructType\\JourneyPatterns',
            'JourneyPattern' => '\\StructType\\JourneyPattern',
            'StopsInPattern' => '\\StructType\\StopsInPattern',
            'StopPointInPatternStructure' => '\\StructType\\StopPointInPatternStructure',
            'AnnotatedDestinationStructure' => '\\StructType\\AnnotatedDestinationStructure',
            'InfoChannelStructure' => '\\StructType\\InfoChannelStructure',
            'AnnotatedConnectionLinkStructure' => '\\StructType\\AnnotatedConnectionLinkStructure',
            'StopPointsRequest' => '\\StructType\\StopPointsRequest',
            'StopPointsDiscoveryRequestStructure' => '\\StructType\\StopPointsDiscoveryRequestStructure',
            'StopPointsDeliveryStructure' => '\\StructType\\StopPointsDeliveryStructure',
            'LinesDiscoveryRequestStructure' => '\\StructType\\LinesDiscoveryRequestStructure',
            'LinesDeliveryStructure' => '\\StructType\\LinesDeliveryStructure',
            'ProductCategoriesDiscoveryRequestStructure' => '\\StructType\\ProductCategoriesDiscoveryRequestStructure',
            'ProductCategoriesDeliveryStructure' => '\\StructType\\ProductCategoriesDeliveryStructure',
            'VehicleFeaturesRequestStructure' => '\\StructType\\VehicleFeaturesRequestStructure',
            'VehicleFeaturesDeliveryStructure' => '\\StructType\\VehicleFeaturesDeliveryStructure',
            'InfoChannelDiscoveryRequestStructure' => '\\StructType\\InfoChannelDiscoveryRequestStructure',
            'InfoChannelDeliveryStructure' => '\\StructType\\InfoChannelDeliveryStructure',
            'FacilityRequestStructure' => '\\StructType\\FacilityRequestStructure',
            'FacilityDeliveryStructure' => '\\StructType\\FacilityDeliveryStructure',
            'ServiceFeaturesRequest' => '\\StructType\\ServiceFeaturesRequest',
            'ServiceFeaturesDiscoveryRequestStructure' => '\\StructType\\ServiceFeaturesDiscoveryRequestStructure',
            'ServiceFeaturesDeliveryStructure' => '\\StructType\\ServiceFeaturesDeliveryStructure',
            'ConnectionLinksDiscoveryRequestStructure' => '\\StructType\\ConnectionLinksDiscoveryRequestStructure',
            'ConnectionLinksDeliveryStructure' => '\\StructType\\ConnectionLinksDeliveryStructure',
            'Siri' => '\\StructType\\Siri',
            'ServiceRequest' => '\\StructType\\ServiceRequest',
            'ServiceRequestStructure' => '\\StructType\\ServiceRequestStructure',
            'SubscriptionRequest' => '\\StructType\\SubscriptionRequest',
            'SubscriptionRequestStructure' => '\\StructType\\SubscriptionRequestStructure',
            'SiriSubscriptionRequestStructure' => '\\StructType\\SiriSubscriptionRequestStructure',
            'ServiceDelivery' => '\\StructType\\ServiceDelivery',
            'ServiceDeliveryStructure' => '\\StructType\\ServiceDeliveryStructure',
            'ServiceDeliveryBodyStructure' => '\\StructType\\ServiceDeliveryBodyStructure',
            'SiriServiceDeliveryStructure' => '\\StructType\\SiriServiceDeliveryStructure',
            'CapabilitiesRequestStructure' => '\\StructType\\CapabilitiesRequestStructure',
            'CapabilitiesResponseStructure' => '\\StructType\\CapabilitiesResponseStructure',
            'WsSubscriptionRequestInfoStructure' => '\\StructType\\WsSubscriptionRequestInfoStructure',
            'WsServiceRequestInfoStructure' => '\\StructType\\WsServiceRequestInfoStructure',
        );
    }
}
