<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WindInformation StructType
 * @subpackage Structs
 */
class WindInformation extends WeatherValue
{
    /**
     * The wind
     * @var \StructType\Wind
     */
    public $wind;
    /**
     * The windInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $windInformationExtension;
    /**
     * Constructor method for WindInformation
     * @uses WindInformation::setWind()
     * @uses WindInformation::setWindInformationExtension()
     * @param \StructType\Wind $wind
     * @param \StructType\ExtensionType $windInformationExtension
     */
    public function __construct(\StructType\Wind $wind = null, \StructType\ExtensionType $windInformationExtension = null)
    {
        $this
            ->setWind($wind)
            ->setWindInformationExtension($windInformationExtension);
    }
    /**
     * Get wind value
     * @return \StructType\Wind|null
     */
    public function getWind()
    {
        return $this->wind;
    }
    /**
     * Set wind value
     * @param \StructType\Wind $wind
     * @return \StructType\WindInformation
     */
    public function setWind(\StructType\Wind $wind = null)
    {
        $this->wind = $wind;
        return $this;
    }
    /**
     * Get windInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getWindInformationExtension()
    {
        return $this->windInformationExtension;
    }
    /**
     * Set windInformationExtension value
     * @param \StructType\ExtensionType $windInformationExtension
     * @return \StructType\WindInformation
     */
    public function setWindInformationExtension(\StructType\ExtensionType $windInformationExtension = null)
    {
        $this->windInformationExtension = $windInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WindInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
