<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Wind StructType
 * @subpackage Structs
 */
class Wind extends AbstractStructBase
{
    /**
     * The maximumWindSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $maximumWindSpeed;
    /**
     * The windDirectionBearing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $windDirectionBearing;
    /**
     * The windDirectionCompass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $windDirectionCompass;
    /**
     * The windMeasurementHeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $windMeasurementHeight;
    /**
     * The windSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $windSpeed;
    /**
     * The windExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $windExtension;
    /**
     * Constructor method for Wind
     * @uses Wind::setMaximumWindSpeed()
     * @uses Wind::setWindDirectionBearing()
     * @uses Wind::setWindDirectionCompass()
     * @uses Wind::setWindMeasurementHeight()
     * @uses Wind::setWindSpeed()
     * @uses Wind::setWindExtension()
     * @param float $maximumWindSpeed
     * @param int $windDirectionBearing
     * @param string $windDirectionCompass
     * @param int $windMeasurementHeight
     * @param float $windSpeed
     * @param \StructType\ExtensionType $windExtension
     */
    public function __construct($maximumWindSpeed = null, $windDirectionBearing = null, $windDirectionCompass = null, $windMeasurementHeight = null, $windSpeed = null, \StructType\ExtensionType $windExtension = null)
    {
        $this
            ->setMaximumWindSpeed($maximumWindSpeed)
            ->setWindDirectionBearing($windDirectionBearing)
            ->setWindDirectionCompass($windDirectionCompass)
            ->setWindMeasurementHeight($windMeasurementHeight)
            ->setWindSpeed($windSpeed)
            ->setWindExtension($windExtension);
    }
    /**
     * Get maximumWindSpeed value
     * @return float|null
     */
    public function getMaximumWindSpeed()
    {
        return $this->maximumWindSpeed;
    }
    /**
     * Set maximumWindSpeed value
     * @param float $maximumWindSpeed
     * @return \StructType\Wind
     */
    public function setMaximumWindSpeed($maximumWindSpeed = null)
    {
        $this->maximumWindSpeed = $maximumWindSpeed;
        return $this;
    }
    /**
     * Get windDirectionBearing value
     * @return int|null
     */
    public function getWindDirectionBearing()
    {
        return $this->windDirectionBearing;
    }
    /**
     * Set windDirectionBearing value
     * @param int $windDirectionBearing
     * @return \StructType\Wind
     */
    public function setWindDirectionBearing($windDirectionBearing = null)
    {
        // validation for constraint: int
        if (!is_null($windDirectionBearing) && !is_numeric($windDirectionBearing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($windDirectionBearing)), __LINE__);
        }
        $this->windDirectionBearing = $windDirectionBearing;
        return $this;
    }
    /**
     * Get windDirectionCompass value
     * @return string|null
     */
    public function getWindDirectionCompass()
    {
        return $this->windDirectionCompass;
    }
    /**
     * Set windDirectionCompass value
     * @uses \EnumType\DirectionCompassEnum::valueIsValid()
     * @uses \EnumType\DirectionCompassEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $windDirectionCompass
     * @return \StructType\Wind
     */
    public function setWindDirectionCompass($windDirectionCompass = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DirectionCompassEnum::valueIsValid($windDirectionCompass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $windDirectionCompass, implode(', ', \EnumType\DirectionCompassEnum::getValidValues())), __LINE__);
        }
        $this->windDirectionCompass = $windDirectionCompass;
        return $this;
    }
    /**
     * Get windMeasurementHeight value
     * @return int|null
     */
    public function getWindMeasurementHeight()
    {
        return $this->windMeasurementHeight;
    }
    /**
     * Set windMeasurementHeight value
     * @param int $windMeasurementHeight
     * @return \StructType\Wind
     */
    public function setWindMeasurementHeight($windMeasurementHeight = null)
    {
        // validation for constraint: int
        if (!is_null($windMeasurementHeight) && !is_numeric($windMeasurementHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($windMeasurementHeight)), __LINE__);
        }
        $this->windMeasurementHeight = $windMeasurementHeight;
        return $this;
    }
    /**
     * Get windSpeed value
     * @return float|null
     */
    public function getWindSpeed()
    {
        return $this->windSpeed;
    }
    /**
     * Set windSpeed value
     * @param float $windSpeed
     * @return \StructType\Wind
     */
    public function setWindSpeed($windSpeed = null)
    {
        $this->windSpeed = $windSpeed;
        return $this;
    }
    /**
     * Get windExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getWindExtension()
    {
        return $this->windExtension;
    }
    /**
     * Set windExtension value
     * @param \StructType\ExtensionType $windExtension
     * @return \StructType\Wind
     */
    public function setWindExtension(\StructType\ExtensionType $windExtension = null)
    {
        $this->windExtension = $windExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Wind
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
