<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WillWaitStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Will Wait details
 * @subpackage Structs
 */
class WillWaitStructure extends AbstractStructBase
{
    /**
     * The WaitUntilTime
     * Meta informations extracted from the WSDL
     * - documentation: Time up until which the distributor will wait. +SIRI v2.0
     * @var string
     */
    public $WaitUntilTime;
    /**
     * The DriverHasAcknowledgeWIllWait
     * Meta informations extracted from the WSDL
     * - documentation: Whether an acknowledgement has been received that the driver will wait. +SIRI v2.0
     * - minOccurs: 0
     * @var bool
     */
    public $DriverHasAcknowledgeWIllWait;
    /**
     * Constructor method for WillWaitStructure
     * @uses WillWaitStructure::setWaitUntilTime()
     * @uses WillWaitStructure::setDriverHasAcknowledgeWIllWait()
     * @param string $waitUntilTime
     * @param bool $driverHasAcknowledgeWIllWait
     */
    public function __construct($waitUntilTime = null, $driverHasAcknowledgeWIllWait = null)
    {
        $this
            ->setWaitUntilTime($waitUntilTime)
            ->setDriverHasAcknowledgeWIllWait($driverHasAcknowledgeWIllWait);
    }
    /**
     * Get WaitUntilTime value
     * @return string|null
     */
    public function getWaitUntilTime()
    {
        return $this->WaitUntilTime;
    }
    /**
     * Set WaitUntilTime value
     * @param string $waitUntilTime
     * @return \StructType\WillWaitStructure
     */
    public function setWaitUntilTime($waitUntilTime = null)
    {
        // validation for constraint: string
        if (!is_null($waitUntilTime) && !is_string($waitUntilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waitUntilTime)), __LINE__);
        }
        $this->WaitUntilTime = $waitUntilTime;
        return $this;
    }
    /**
     * Get DriverHasAcknowledgeWIllWait value
     * @return bool|null
     */
    public function getDriverHasAcknowledgeWIllWait()
    {
        return $this->DriverHasAcknowledgeWIllWait;
    }
    /**
     * Set DriverHasAcknowledgeWIllWait value
     * @param bool $driverHasAcknowledgeWIllWait
     * @return \StructType\WillWaitStructure
     */
    public function setDriverHasAcknowledgeWIllWait($driverHasAcknowledgeWIllWait = null)
    {
        // validation for constraint: boolean
        if (!is_null($driverHasAcknowledgeWIllWait) && !is_bool($driverHasAcknowledgeWIllWait)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($driverHasAcknowledgeWIllWait)), __LINE__);
        }
        $this->DriverHasAcknowledgeWIllWait = $driverHasAcknowledgeWIllWait;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WillWaitStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
