<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WidthCharacteristic StructType
 * @subpackage Structs
 */
class WidthCharacteristic extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comparisonOperator;
    /**
     * The vehicleWidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $vehicleWidth;
    /**
     * The widthCharacteristicExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $widthCharacteristicExtension;
    /**
     * Constructor method for WidthCharacteristic
     * @uses WidthCharacteristic::setComparisonOperator()
     * @uses WidthCharacteristic::setVehicleWidth()
     * @uses WidthCharacteristic::setWidthCharacteristicExtension()
     * @param string $comparisonOperator
     * @param float $vehicleWidth
     * @param \StructType\ExtensionType $widthCharacteristicExtension
     */
    public function __construct($comparisonOperator = null, $vehicleWidth = null, \StructType\ExtensionType $widthCharacteristicExtension = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setVehicleWidth($vehicleWidth)
            ->setWidthCharacteristicExtension($widthCharacteristicExtension);
    }
    /**
     * Get comparisonOperator value
     * @return string
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \EnumType\ComparisonOperatorEnum::valueIsValid()
     * @uses \EnumType\ComparisonOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \StructType\WidthCharacteristic
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonOperatorEnum::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \EnumType\ComparisonOperatorEnum::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get vehicleWidth value
     * @return float
     */
    public function getVehicleWidth()
    {
        return $this->vehicleWidth;
    }
    /**
     * Set vehicleWidth value
     * @param float $vehicleWidth
     * @return \StructType\WidthCharacteristic
     */
    public function setVehicleWidth($vehicleWidth = null)
    {
        $this->vehicleWidth = $vehicleWidth;
        return $this;
    }
    /**
     * Get widthCharacteristicExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getWidthCharacteristicExtension()
    {
        return $this->widthCharacteristicExtension;
    }
    /**
     * Set widthCharacteristicExtension value
     * @param \StructType\ExtensionType $widthCharacteristicExtension
     * @return \StructType\WidthCharacteristic
     */
    public function setWidthCharacteristicExtension(\StructType\ExtensionType $widthCharacteristicExtension = null)
    {
        $this->widthCharacteristicExtension = $widthCharacteristicExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WidthCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
