<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicles StructType
 * Meta informations extracted from the WSDL
 * - documentation: Specific vehicles affected by SITUATION. (+SIRI v2.0)
 * @subpackage Structs
 */
class Vehicles extends AbstractStructBase
{
    /**
     * The AffectedVehicle
     * Meta informations extracted from the WSDL
     * - documentation: Vehicles affected by the SITUATION. (+SIRi v2.0)
     * - maxOccurs: unbounded
     * @var \StructType\AffectedVehicleStructure[]
     */
    public $AffectedVehicle;
    /**
     * Constructor method for Vehicles
     * @uses Vehicles::setAffectedVehicle()
     * @param \StructType\AffectedVehicleStructure[] $affectedVehicle
     */
    public function __construct(array $affectedVehicle = array())
    {
        $this
            ->setAffectedVehicle($affectedVehicle);
    }
    /**
     * Get AffectedVehicle value
     * @return \StructType\AffectedVehicleStructure[]|null
     */
    public function getAffectedVehicle()
    {
        return $this->AffectedVehicle;
    }
    /**
     * Set AffectedVehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedVehicleStructure[] $affectedVehicle
     * @return \StructType\Vehicles
     */
    public function setAffectedVehicle(array $affectedVehicle = array())
    {
        foreach ($affectedVehicle as $vehiclesAffectedVehicleItem) {
            // validation for constraint: itemType
            if (!$vehiclesAffectedVehicleItem instanceof \StructType\AffectedVehicleStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedVehicle property can only contain items of \StructType\AffectedVehicleStructure, "%s" given', is_object($vehiclesAffectedVehicleItem) ? get_class($vehiclesAffectedVehicleItem) : gettype($vehiclesAffectedVehicleItem)), __LINE__);
            }
        }
        $this->AffectedVehicle = $affectedVehicle;
        return $this;
    }
    /**
     * Add item to AffectedVehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedVehicleStructure $item
     * @return \StructType\Vehicles
     */
    public function addToAffectedVehicle(\StructType\AffectedVehicleStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedVehicleStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedVehicle property can only contain items of \StructType\AffectedVehicleStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedVehicle[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
