<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleMonitoringRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Vehicle Monitoring Service.
 * @subpackage Structs
 */
class VehicleMonitoringRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The VehicleMonitoringRef
     * @var \StructType\VehicleMonitoringRefStructure
     */
    public $VehicleMonitoringRef;
    /**
     * The VehicleRef
     * @var \StructType\VehicleRefStructure
     */
    public $VehicleRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The MaximumVehicles
     * @var int
     */
    public $MaximumVehicles;
    /**
     * The VehicleMonitoringDetailLevel
     * @var string
     */
    public $VehicleMonitoringDetailLevel;
    /**
     * The MaximumNumberOfCalls
     * @var \StructType\MaximumNumberOfCalls
     */
    public $MaximumNumberOfCalls;
    /**
     * The IncludeSituations
     * @var bool
     */
    public $IncludeSituations;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for VehicleMonitoringRequestStructure
     * @uses VehicleMonitoringRequestStructure::setVehicleMonitoringRef()
     * @uses VehicleMonitoringRequestStructure::setVehicleRef()
     * @uses VehicleMonitoringRequestStructure::setLineRef()
     * @uses VehicleMonitoringRequestStructure::setDirectionRef()
     * @uses VehicleMonitoringRequestStructure::setLanguage()
     * @uses VehicleMonitoringRequestStructure::setIncludeTranslations()
     * @uses VehicleMonitoringRequestStructure::setMaximumVehicles()
     * @uses VehicleMonitoringRequestStructure::setVehicleMonitoringDetailLevel()
     * @uses VehicleMonitoringRequestStructure::setMaximumNumberOfCalls()
     * @uses VehicleMonitoringRequestStructure::setIncludeSituations()
     * @uses VehicleMonitoringRequestStructure::setExtensions()
     * @uses VehicleMonitoringRequestStructure::setVersion()
     * @param \StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param string $language
     * @param bool $includeTranslations
     * @param int $maximumVehicles
     * @param string $vehicleMonitoringDetailLevel
     * @param \StructType\MaximumNumberOfCalls $maximumNumberOfCalls
     * @param bool $includeSituations
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(\StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef = null, \StructType\VehicleRefStructure $vehicleRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, $language = null, $includeTranslations = null, $maximumVehicles = null, $vehicleMonitoringDetailLevel = null, \StructType\MaximumNumberOfCalls $maximumNumberOfCalls = null, $includeSituations = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setVehicleMonitoringRef($vehicleMonitoringRef)
            ->setVehicleRef($vehicleRef)
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setMaximumVehicles($maximumVehicles)
            ->setVehicleMonitoringDetailLevel($vehicleMonitoringDetailLevel)
            ->setMaximumNumberOfCalls($maximumNumberOfCalls)
            ->setIncludeSituations($includeSituations)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get VehicleMonitoringRef value
     * @return \StructType\VehicleMonitoringRefStructure|null
     */
    public function getVehicleMonitoringRef()
    {
        return $this->VehicleMonitoringRef;
    }
    /**
     * Set VehicleMonitoringRef value
     * @param \StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setVehicleMonitoringRef(\StructType\VehicleMonitoringRefStructure $vehicleMonitoringRef = null)
    {
        $this->VehicleMonitoringRef = $vehicleMonitoringRef;
        return $this;
    }
    /**
     * Get VehicleRef value
     * @return \StructType\VehicleRefStructure|null
     */
    public function getVehicleRef()
    {
        return $this->VehicleRef;
    }
    /**
     * Set VehicleRef value
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setVehicleRef(\StructType\VehicleRefStructure $vehicleRef = null)
    {
        $this->VehicleRef = $vehicleRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get MaximumVehicles value
     * @return int|null
     */
    public function getMaximumVehicles()
    {
        return $this->MaximumVehicles;
    }
    /**
     * Set MaximumVehicles value
     * @param int $maximumVehicles
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setMaximumVehicles($maximumVehicles = null)
    {
        // validation for constraint: int
        if (!is_null($maximumVehicles) && !is_numeric($maximumVehicles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumVehicles)), __LINE__);
        }
        $this->MaximumVehicles = $maximumVehicles;
        return $this;
    }
    /**
     * Get VehicleMonitoringDetailLevel value
     * @return string|null
     */
    public function getVehicleMonitoringDetailLevel()
    {
        return $this->VehicleMonitoringDetailLevel;
    }
    /**
     * Set VehicleMonitoringDetailLevel value
     * @uses \EnumType\VehicleMonitoringDetailEnumeration::valueIsValid()
     * @uses \EnumType\VehicleMonitoringDetailEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMonitoringDetailLevel
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setVehicleMonitoringDetailLevel($vehicleMonitoringDetailLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleMonitoringDetailEnumeration::valueIsValid($vehicleMonitoringDetailLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMonitoringDetailLevel, implode(', ', \EnumType\VehicleMonitoringDetailEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMonitoringDetailLevel = $vehicleMonitoringDetailLevel;
        return $this;
    }
    /**
     * Get MaximumNumberOfCalls value
     * @return \StructType\MaximumNumberOfCalls|null
     */
    public function getMaximumNumberOfCalls()
    {
        return $this->MaximumNumberOfCalls;
    }
    /**
     * Set MaximumNumberOfCalls value
     * @param \StructType\MaximumNumberOfCalls $maximumNumberOfCalls
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setMaximumNumberOfCalls(\StructType\MaximumNumberOfCalls $maximumNumberOfCalls = null)
    {
        $this->MaximumNumberOfCalls = $maximumNumberOfCalls;
        return $this;
    }
    /**
     * Get IncludeSituations value
     * @return bool|null
     */
    public function getIncludeSituations()
    {
        return $this->IncludeSituations;
    }
    /**
     * Set IncludeSituations value
     * @param bool $includeSituations
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setIncludeSituations($includeSituations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeSituations) && !is_bool($includeSituations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeSituations)), __LINE__);
        }
        $this->IncludeSituations = $includeSituations;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleMonitoringRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
