<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleDetectionTime StructType
 * @subpackage Structs
 */
class VehicleDetectionTime extends AbstractStructBase
{
    /**
     * The arrivalTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $arrivalTime;
    /**
     * The exitTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $exitTime;
    /**
     * The passageTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $passageTime;
    /**
     * The presenceTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presenceTime;
    /**
     * The timeGap
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $timeGap;
    /**
     * The timeHeadway
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $timeHeadway;
    /**
     * The vehicleDetectionTimeExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $vehicleDetectionTimeExtension;
    /**
     * Constructor method for VehicleDetectionTime
     * @uses VehicleDetectionTime::setArrivalTime()
     * @uses VehicleDetectionTime::setExitTime()
     * @uses VehicleDetectionTime::setPassageTime()
     * @uses VehicleDetectionTime::setPresenceTime()
     * @uses VehicleDetectionTime::setTimeGap()
     * @uses VehicleDetectionTime::setTimeHeadway()
     * @uses VehicleDetectionTime::setVehicleDetectionTimeExtension()
     * @param string $arrivalTime
     * @param string $exitTime
     * @param string $passageTime
     * @param string $presenceTime
     * @param float $timeGap
     * @param float $timeHeadway
     * @param \StructType\ExtensionType $vehicleDetectionTimeExtension
     */
    public function __construct($arrivalTime = null, $exitTime = null, $passageTime = null, $presenceTime = null, $timeGap = null, $timeHeadway = null, \StructType\ExtensionType $vehicleDetectionTimeExtension = null)
    {
        $this
            ->setArrivalTime($arrivalTime)
            ->setExitTime($exitTime)
            ->setPassageTime($passageTime)
            ->setPresenceTime($presenceTime)
            ->setTimeGap($timeGap)
            ->setTimeHeadway($timeHeadway)
            ->setVehicleDetectionTimeExtension($vehicleDetectionTimeExtension);
    }
    /**
     * Get arrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->arrivalTime;
    }
    /**
     * Set arrivalTime value
     * @param string $arrivalTime
     * @return \StructType\VehicleDetectionTime
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalTime)), __LINE__);
        }
        $this->arrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get exitTime value
     * @return string|null
     */
    public function getExitTime()
    {
        return $this->exitTime;
    }
    /**
     * Set exitTime value
     * @param string $exitTime
     * @return \StructType\VehicleDetectionTime
     */
    public function setExitTime($exitTime = null)
    {
        // validation for constraint: string
        if (!is_null($exitTime) && !is_string($exitTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exitTime)), __LINE__);
        }
        $this->exitTime = $exitTime;
        return $this;
    }
    /**
     * Get passageTime value
     * @return string|null
     */
    public function getPassageTime()
    {
        return $this->passageTime;
    }
    /**
     * Set passageTime value
     * @param string $passageTime
     * @return \StructType\VehicleDetectionTime
     */
    public function setPassageTime($passageTime = null)
    {
        // validation for constraint: string
        if (!is_null($passageTime) && !is_string($passageTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passageTime)), __LINE__);
        }
        $this->passageTime = $passageTime;
        return $this;
    }
    /**
     * Get presenceTime value
     * @return string|null
     */
    public function getPresenceTime()
    {
        return $this->presenceTime;
    }
    /**
     * Set presenceTime value
     * @param string $presenceTime
     * @return \StructType\VehicleDetectionTime
     */
    public function setPresenceTime($presenceTime = null)
    {
        // validation for constraint: string
        if (!is_null($presenceTime) && !is_string($presenceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($presenceTime)), __LINE__);
        }
        $this->presenceTime = $presenceTime;
        return $this;
    }
    /**
     * Get timeGap value
     * @return float|null
     */
    public function getTimeGap()
    {
        return $this->timeGap;
    }
    /**
     * Set timeGap value
     * @param float $timeGap
     * @return \StructType\VehicleDetectionTime
     */
    public function setTimeGap($timeGap = null)
    {
        $this->timeGap = $timeGap;
        return $this;
    }
    /**
     * Get timeHeadway value
     * @return float|null
     */
    public function getTimeHeadway()
    {
        return $this->timeHeadway;
    }
    /**
     * Set timeHeadway value
     * @param float $timeHeadway
     * @return \StructType\VehicleDetectionTime
     */
    public function setTimeHeadway($timeHeadway = null)
    {
        $this->timeHeadway = $timeHeadway;
        return $this;
    }
    /**
     * Get vehicleDetectionTimeExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getVehicleDetectionTimeExtension()
    {
        return $this->vehicleDetectionTimeExtension;
    }
    /**
     * Set vehicleDetectionTimeExtension value
     * @param \StructType\ExtensionType $vehicleDetectionTimeExtension
     * @return \StructType\VehicleDetectionTime
     */
    public function setVehicleDetectionTimeExtension(\StructType\ExtensionType $vehicleDetectionTimeExtension = null)
    {
        $this->vehicleDetectionTimeExtension = $vehicleDetectionTimeExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleDetectionTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
