<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle StructType
 * @subpackage Structs
 */
class Vehicle extends AbstractStructBase
{
    /**
     * The vehicleColour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $vehicleColour;
    /**
     * The vehicleCountryOfOrigin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $vehicleCountryOfOrigin;
    /**
     * The vehicleIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $vehicleIdentifier;
    /**
     * The vehicleManufacturer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $vehicleManufacturer;
    /**
     * The vehicleModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $vehicleModel;
    /**
     * The vehicleRegistrationPlateIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $vehicleRegistrationPlateIdentifier;
    /**
     * The vehicleStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vehicleStatus;
    /**
     * The vehicleCharacteristics
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleCharacteristics
     */
    public $vehicleCharacteristics;
    /**
     * The axleSpacingOnVehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AxleSpacing[]
     */
    public $axleSpacingOnVehicle;
    /**
     * The specificAxleWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AxleWeight[]
     */
    public $specificAxleWeight;
    /**
     * The hazardousGoodsAssociatedWithVehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HazardousMaterials
     */
    public $hazardousGoodsAssociatedWithVehicle;
    /**
     * The vehicleExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $vehicleExtension;
    /**
     * Constructor method for Vehicle
     * @uses Vehicle::setVehicleColour()
     * @uses Vehicle::setVehicleCountryOfOrigin()
     * @uses Vehicle::setVehicleIdentifier()
     * @uses Vehicle::setVehicleManufacturer()
     * @uses Vehicle::setVehicleModel()
     * @uses Vehicle::setVehicleRegistrationPlateIdentifier()
     * @uses Vehicle::setVehicleStatus()
     * @uses Vehicle::setVehicleCharacteristics()
     * @uses Vehicle::setAxleSpacingOnVehicle()
     * @uses Vehicle::setSpecificAxleWeight()
     * @uses Vehicle::setHazardousGoodsAssociatedWithVehicle()
     * @uses Vehicle::setVehicleExtension()
     * @param \StructType\MultilingualString $vehicleColour
     * @param \StructType\MultilingualString $vehicleCountryOfOrigin
     * @param string $vehicleIdentifier
     * @param string $vehicleManufacturer
     * @param string $vehicleModel
     * @param string $vehicleRegistrationPlateIdentifier
     * @param string $vehicleStatus
     * @param \StructType\VehicleCharacteristics $vehicleCharacteristics
     * @param \StructType\AxleSpacing[] $axleSpacingOnVehicle
     * @param \StructType\AxleWeight[] $specificAxleWeight
     * @param \StructType\HazardousMaterials $hazardousGoodsAssociatedWithVehicle
     * @param \StructType\ExtensionType $vehicleExtension
     */
    public function __construct(\StructType\MultilingualString $vehicleColour = null, \StructType\MultilingualString $vehicleCountryOfOrigin = null, $vehicleIdentifier = null, $vehicleManufacturer = null, $vehicleModel = null, $vehicleRegistrationPlateIdentifier = null, $vehicleStatus = null, \StructType\VehicleCharacteristics $vehicleCharacteristics = null, array $axleSpacingOnVehicle = array(), array $specificAxleWeight = array(), \StructType\HazardousMaterials $hazardousGoodsAssociatedWithVehicle = null, \StructType\ExtensionType $vehicleExtension = null)
    {
        $this
            ->setVehicleColour($vehicleColour)
            ->setVehicleCountryOfOrigin($vehicleCountryOfOrigin)
            ->setVehicleIdentifier($vehicleIdentifier)
            ->setVehicleManufacturer($vehicleManufacturer)
            ->setVehicleModel($vehicleModel)
            ->setVehicleRegistrationPlateIdentifier($vehicleRegistrationPlateIdentifier)
            ->setVehicleStatus($vehicleStatus)
            ->setVehicleCharacteristics($vehicleCharacteristics)
            ->setAxleSpacingOnVehicle($axleSpacingOnVehicle)
            ->setSpecificAxleWeight($specificAxleWeight)
            ->setHazardousGoodsAssociatedWithVehicle($hazardousGoodsAssociatedWithVehicle)
            ->setVehicleExtension($vehicleExtension);
    }
    /**
     * Get vehicleColour value
     * @return \StructType\MultilingualString|null
     */
    public function getVehicleColour()
    {
        return $this->vehicleColour;
    }
    /**
     * Set vehicleColour value
     * @param \StructType\MultilingualString $vehicleColour
     * @return \StructType\Vehicle
     */
    public function setVehicleColour(\StructType\MultilingualString $vehicleColour = null)
    {
        $this->vehicleColour = $vehicleColour;
        return $this;
    }
    /**
     * Get vehicleCountryOfOrigin value
     * @return \StructType\MultilingualString|null
     */
    public function getVehicleCountryOfOrigin()
    {
        return $this->vehicleCountryOfOrigin;
    }
    /**
     * Set vehicleCountryOfOrigin value
     * @param \StructType\MultilingualString $vehicleCountryOfOrigin
     * @return \StructType\Vehicle
     */
    public function setVehicleCountryOfOrigin(\StructType\MultilingualString $vehicleCountryOfOrigin = null)
    {
        $this->vehicleCountryOfOrigin = $vehicleCountryOfOrigin;
        return $this;
    }
    /**
     * Get vehicleIdentifier value
     * @return string|null
     */
    public function getVehicleIdentifier()
    {
        return $this->vehicleIdentifier;
    }
    /**
     * Set vehicleIdentifier value
     * @param string $vehicleIdentifier
     * @return \StructType\Vehicle
     */
    public function setVehicleIdentifier($vehicleIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vehicleIdentifier) && strlen($vehicleIdentifier) > 1024) || (is_array($vehicleIdentifier) && count($vehicleIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($vehicleIdentifier) ? strlen($vehicleIdentifier) : count($vehicleIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleIdentifier) && !is_string($vehicleIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleIdentifier)), __LINE__);
        }
        $this->vehicleIdentifier = $vehicleIdentifier;
        return $this;
    }
    /**
     * Get vehicleManufacturer value
     * @return string|null
     */
    public function getVehicleManufacturer()
    {
        return $this->vehicleManufacturer;
    }
    /**
     * Set vehicleManufacturer value
     * @param string $vehicleManufacturer
     * @return \StructType\Vehicle
     */
    public function setVehicleManufacturer($vehicleManufacturer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vehicleManufacturer) && strlen($vehicleManufacturer) > 1024) || (is_array($vehicleManufacturer) && count($vehicleManufacturer) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($vehicleManufacturer) ? strlen($vehicleManufacturer) : count($vehicleManufacturer)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleManufacturer) && !is_string($vehicleManufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleManufacturer)), __LINE__);
        }
        $this->vehicleManufacturer = $vehicleManufacturer;
        return $this;
    }
    /**
     * Get vehicleModel value
     * @return string|null
     */
    public function getVehicleModel()
    {
        return $this->vehicleModel;
    }
    /**
     * Set vehicleModel value
     * @param string $vehicleModel
     * @return \StructType\Vehicle
     */
    public function setVehicleModel($vehicleModel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vehicleModel) && strlen($vehicleModel) > 1024) || (is_array($vehicleModel) && count($vehicleModel) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($vehicleModel) ? strlen($vehicleModel) : count($vehicleModel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleModel) && !is_string($vehicleModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleModel)), __LINE__);
        }
        $this->vehicleModel = $vehicleModel;
        return $this;
    }
    /**
     * Get vehicleRegistrationPlateIdentifier value
     * @return string|null
     */
    public function getVehicleRegistrationPlateIdentifier()
    {
        return $this->vehicleRegistrationPlateIdentifier;
    }
    /**
     * Set vehicleRegistrationPlateIdentifier value
     * @param string $vehicleRegistrationPlateIdentifier
     * @return \StructType\Vehicle
     */
    public function setVehicleRegistrationPlateIdentifier($vehicleRegistrationPlateIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vehicleRegistrationPlateIdentifier) && strlen($vehicleRegistrationPlateIdentifier) > 1024) || (is_array($vehicleRegistrationPlateIdentifier) && count($vehicleRegistrationPlateIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($vehicleRegistrationPlateIdentifier) ? strlen($vehicleRegistrationPlateIdentifier) : count($vehicleRegistrationPlateIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vehicleRegistrationPlateIdentifier) && !is_string($vehicleRegistrationPlateIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleRegistrationPlateIdentifier)), __LINE__);
        }
        $this->vehicleRegistrationPlateIdentifier = $vehicleRegistrationPlateIdentifier;
        return $this;
    }
    /**
     * Get vehicleStatus value
     * @return string|null
     */
    public function getVehicleStatus()
    {
        return $this->vehicleStatus;
    }
    /**
     * Set vehicleStatus value
     * @uses \EnumType\VehicleStatusEnum::valueIsValid()
     * @uses \EnumType\VehicleStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleStatus
     * @return \StructType\Vehicle
     */
    public function setVehicleStatus($vehicleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleStatusEnum::valueIsValid($vehicleStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleStatus, implode(', ', \EnumType\VehicleStatusEnum::getValidValues())), __LINE__);
        }
        $this->vehicleStatus = $vehicleStatus;
        return $this;
    }
    /**
     * Get vehicleCharacteristics value
     * @return \StructType\VehicleCharacteristics|null
     */
    public function getVehicleCharacteristics()
    {
        return $this->vehicleCharacteristics;
    }
    /**
     * Set vehicleCharacteristics value
     * @param \StructType\VehicleCharacteristics $vehicleCharacteristics
     * @return \StructType\Vehicle
     */
    public function setVehicleCharacteristics(\StructType\VehicleCharacteristics $vehicleCharacteristics = null)
    {
        $this->vehicleCharacteristics = $vehicleCharacteristics;
        return $this;
    }
    /**
     * Get axleSpacingOnVehicle value
     * @return \StructType\AxleSpacing[]|null
     */
    public function getAxleSpacingOnVehicle()
    {
        return $this->axleSpacingOnVehicle;
    }
    /**
     * Set axleSpacingOnVehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\AxleSpacing[] $axleSpacingOnVehicle
     * @return \StructType\Vehicle
     */
    public function setAxleSpacingOnVehicle(array $axleSpacingOnVehicle = array())
    {
        foreach ($axleSpacingOnVehicle as $vehicleAxleSpacingOnVehicleItem) {
            // validation for constraint: itemType
            if (!$vehicleAxleSpacingOnVehicleItem instanceof \StructType\AxleSpacing) {
                throw new \InvalidArgumentException(sprintf('The axleSpacingOnVehicle property can only contain items of \StructType\AxleSpacing, "%s" given', is_object($vehicleAxleSpacingOnVehicleItem) ? get_class($vehicleAxleSpacingOnVehicleItem) : gettype($vehicleAxleSpacingOnVehicleItem)), __LINE__);
            }
        }
        $this->axleSpacingOnVehicle = $axleSpacingOnVehicle;
        return $this;
    }
    /**
     * Add item to axleSpacingOnVehicle value
     * @throws \InvalidArgumentException
     * @param \StructType\AxleSpacing $item
     * @return \StructType\Vehicle
     */
    public function addToAxleSpacingOnVehicle(\StructType\AxleSpacing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AxleSpacing) {
            throw new \InvalidArgumentException(sprintf('The axleSpacingOnVehicle property can only contain items of \StructType\AxleSpacing, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->axleSpacingOnVehicle[] = $item;
        return $this;
    }
    /**
     * Get specificAxleWeight value
     * @return \StructType\AxleWeight[]|null
     */
    public function getSpecificAxleWeight()
    {
        return $this->specificAxleWeight;
    }
    /**
     * Set specificAxleWeight value
     * @throws \InvalidArgumentException
     * @param \StructType\AxleWeight[] $specificAxleWeight
     * @return \StructType\Vehicle
     */
    public function setSpecificAxleWeight(array $specificAxleWeight = array())
    {
        foreach ($specificAxleWeight as $vehicleSpecificAxleWeightItem) {
            // validation for constraint: itemType
            if (!$vehicleSpecificAxleWeightItem instanceof \StructType\AxleWeight) {
                throw new \InvalidArgumentException(sprintf('The specificAxleWeight property can only contain items of \StructType\AxleWeight, "%s" given', is_object($vehicleSpecificAxleWeightItem) ? get_class($vehicleSpecificAxleWeightItem) : gettype($vehicleSpecificAxleWeightItem)), __LINE__);
            }
        }
        $this->specificAxleWeight = $specificAxleWeight;
        return $this;
    }
    /**
     * Add item to specificAxleWeight value
     * @throws \InvalidArgumentException
     * @param \StructType\AxleWeight $item
     * @return \StructType\Vehicle
     */
    public function addToSpecificAxleWeight(\StructType\AxleWeight $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AxleWeight) {
            throw new \InvalidArgumentException(sprintf('The specificAxleWeight property can only contain items of \StructType\AxleWeight, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->specificAxleWeight[] = $item;
        return $this;
    }
    /**
     * Get hazardousGoodsAssociatedWithVehicle value
     * @return \StructType\HazardousMaterials|null
     */
    public function getHazardousGoodsAssociatedWithVehicle()
    {
        return $this->hazardousGoodsAssociatedWithVehicle;
    }
    /**
     * Set hazardousGoodsAssociatedWithVehicle value
     * @param \StructType\HazardousMaterials $hazardousGoodsAssociatedWithVehicle
     * @return \StructType\Vehicle
     */
    public function setHazardousGoodsAssociatedWithVehicle(\StructType\HazardousMaterials $hazardousGoodsAssociatedWithVehicle = null)
    {
        $this->hazardousGoodsAssociatedWithVehicle = $hazardousGoodsAssociatedWithVehicle;
        return $this;
    }
    /**
     * Get vehicleExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getVehicleExtension()
    {
        return $this->vehicleExtension;
    }
    /**
     * Set vehicleExtension value
     * @param \StructType\ExtensionType $vehicleExtension
     * @return \StructType\Vehicle
     */
    public function setVehicleExtension(\StructType\ExtensionType $vehicleExtension = null)
    {
        $this->vehicleExtension = $vehicleExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
