<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VariableMessageSignSetting StructType
 * @subpackage Structs
 */
class VariableMessageSignSetting extends SignSetting
{
    /**
     * The numberOfCharacters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfCharacters;
    /**
     * The numberOfRows
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfRows;
    /**
     * The vmsFault
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $vmsFault;
    /**
     * The vmsIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $vmsIdentifier;
    /**
     * The vmsLegend
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultilingualString[]
     */
    public $vmsLegend;
    /**
     * The vmsType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vmsType;
    /**
     * The variableMessageSignSettingExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $variableMessageSignSettingExtension;
    /**
     * Constructor method for VariableMessageSignSetting
     * @uses VariableMessageSignSetting::setNumberOfCharacters()
     * @uses VariableMessageSignSetting::setNumberOfRows()
     * @uses VariableMessageSignSetting::setVmsFault()
     * @uses VariableMessageSignSetting::setVmsIdentifier()
     * @uses VariableMessageSignSetting::setVmsLegend()
     * @uses VariableMessageSignSetting::setVmsType()
     * @uses VariableMessageSignSetting::setVariableMessageSignSettingExtension()
     * @param int $numberOfCharacters
     * @param int $numberOfRows
     * @param string[] $vmsFault
     * @param string $vmsIdentifier
     * @param \StructType\MultilingualString[] $vmsLegend
     * @param string $vmsType
     * @param \StructType\ExtensionType $variableMessageSignSettingExtension
     */
    public function __construct($numberOfCharacters = null, $numberOfRows = null, array $vmsFault = array(), $vmsIdentifier = null, array $vmsLegend = array(), $vmsType = null, \StructType\ExtensionType $variableMessageSignSettingExtension = null)
    {
        $this
            ->setNumberOfCharacters($numberOfCharacters)
            ->setNumberOfRows($numberOfRows)
            ->setVmsFault($vmsFault)
            ->setVmsIdentifier($vmsIdentifier)
            ->setVmsLegend($vmsLegend)
            ->setVmsType($vmsType)
            ->setVariableMessageSignSettingExtension($variableMessageSignSettingExtension);
    }
    /**
     * Get numberOfCharacters value
     * @return int|null
     */
    public function getNumberOfCharacters()
    {
        return $this->numberOfCharacters;
    }
    /**
     * Set numberOfCharacters value
     * @param int $numberOfCharacters
     * @return \StructType\VariableMessageSignSetting
     */
    public function setNumberOfCharacters($numberOfCharacters = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCharacters) && !is_numeric($numberOfCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfCharacters)), __LINE__);
        }
        $this->numberOfCharacters = $numberOfCharacters;
        return $this;
    }
    /**
     * Get numberOfRows value
     * @return int|null
     */
    public function getNumberOfRows()
    {
        return $this->numberOfRows;
    }
    /**
     * Set numberOfRows value
     * @param int $numberOfRows
     * @return \StructType\VariableMessageSignSetting
     */
    public function setNumberOfRows($numberOfRows = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfRows) && !is_numeric($numberOfRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfRows)), __LINE__);
        }
        $this->numberOfRows = $numberOfRows;
        return $this;
    }
    /**
     * Get vmsFault value
     * @return string[]|null
     */
    public function getVmsFault()
    {
        return $this->vmsFault;
    }
    /**
     * Set vmsFault value
     * @uses \EnumType\VmsFaultEnum::valueIsValid()
     * @uses \EnumType\VmsFaultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $vmsFault
     * @return \StructType\VariableMessageSignSetting
     */
    public function setVmsFault(array $vmsFault = array())
    {
        $invalidValues = array();
        foreach ($vmsFault as $variableMessageSignSettingVmsFaultItem) {
            if (!\EnumType\VmsFaultEnum::valueIsValid($variableMessageSignSettingVmsFaultItem)) {
                $invalidValues[] = var_export($variableMessageSignSettingVmsFaultItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\VmsFaultEnum::getValidValues())), __LINE__);
        }
        $this->vmsFault = $vmsFault;
        return $this;
    }
    /**
     * Add item to vmsFault value
     * @uses \EnumType\VmsFaultEnum::valueIsValid()
     * @uses \EnumType\VmsFaultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VariableMessageSignSetting
     */
    public function addToVmsFault($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VmsFaultEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\VmsFaultEnum::getValidValues())), __LINE__);
        }
        $this->vmsFault[] = $item;
        return $this;
    }
    /**
     * Get vmsIdentifier value
     * @return string|null
     */
    public function getVmsIdentifier()
    {
        return $this->vmsIdentifier;
    }
    /**
     * Set vmsIdentifier value
     * @param string $vmsIdentifier
     * @return \StructType\VariableMessageSignSetting
     */
    public function setVmsIdentifier($vmsIdentifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vmsIdentifier) && strlen($vmsIdentifier) > 1024) || (is_array($vmsIdentifier) && count($vmsIdentifier) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($vmsIdentifier) ? strlen($vmsIdentifier) : count($vmsIdentifier)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vmsIdentifier) && !is_string($vmsIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vmsIdentifier)), __LINE__);
        }
        $this->vmsIdentifier = $vmsIdentifier;
        return $this;
    }
    /**
     * Get vmsLegend value
     * @return \StructType\MultilingualString[]|null
     */
    public function getVmsLegend()
    {
        return $this->vmsLegend;
    }
    /**
     * Set vmsLegend value
     * @throws \InvalidArgumentException
     * @param \StructType\MultilingualString[] $vmsLegend
     * @return \StructType\VariableMessageSignSetting
     */
    public function setVmsLegend(array $vmsLegend = array())
    {
        foreach ($vmsLegend as $variableMessageSignSettingVmsLegendItem) {
            // validation for constraint: itemType
            if (!$variableMessageSignSettingVmsLegendItem instanceof \StructType\MultilingualString) {
                throw new \InvalidArgumentException(sprintf('The vmsLegend property can only contain items of \StructType\MultilingualString, "%s" given', is_object($variableMessageSignSettingVmsLegendItem) ? get_class($variableMessageSignSettingVmsLegendItem) : gettype($variableMessageSignSettingVmsLegendItem)), __LINE__);
            }
        }
        $this->vmsLegend = $vmsLegend;
        return $this;
    }
    /**
     * Add item to vmsLegend value
     * @throws \InvalidArgumentException
     * @param \StructType\MultilingualString $item
     * @return \StructType\VariableMessageSignSetting
     */
    public function addToVmsLegend(\StructType\MultilingualString $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultilingualString) {
            throw new \InvalidArgumentException(sprintf('The vmsLegend property can only contain items of \StructType\MultilingualString, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vmsLegend[] = $item;
        return $this;
    }
    /**
     * Get vmsType value
     * @return string|null
     */
    public function getVmsType()
    {
        return $this->vmsType;
    }
    /**
     * Set vmsType value
     * @uses \EnumType\VmsTypeEnum::valueIsValid()
     * @uses \EnumType\VmsTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vmsType
     * @return \StructType\VariableMessageSignSetting
     */
    public function setVmsType($vmsType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VmsTypeEnum::valueIsValid($vmsType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vmsType, implode(', ', \EnumType\VmsTypeEnum::getValidValues())), __LINE__);
        }
        $this->vmsType = $vmsType;
        return $this;
    }
    /**
     * Get variableMessageSignSettingExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getVariableMessageSignSettingExtension()
    {
        return $this->variableMessageSignSettingExtension;
    }
    /**
     * Set variableMessageSignSettingExtension value
     * @param \StructType\ExtensionType $variableMessageSignSettingExtension
     * @return \StructType\VariableMessageSignSetting
     */
    public function setVariableMessageSignSettingExtension(\StructType\ExtensionType $variableMessageSignSettingExtension = null)
    {
        $this->variableMessageSignSettingExtension = $variableMessageSignSettingExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariableMessageSignSetting
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
