<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidityConditionsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: A collection of one or more validity conditions.
 * @subpackage Structs
 */
class ValidityConditionsStructure extends AbstractStructBase
{
    /**
     * The ValidityCondition
     * Meta informations extracted from the WSDL
     * - documentation: Reference to the identifier of an administrative area.
     * - maxOccurs: unbounded
     * @var \StructType\ValidityConditionStructure[]
     */
    public $ValidityCondition;
    /**
     * Constructor method for ValidityConditionsStructure
     * @uses ValidityConditionsStructure::setValidityCondition()
     * @param \StructType\ValidityConditionStructure[] $validityCondition
     */
    public function __construct(array $validityCondition = array())
    {
        $this
            ->setValidityCondition($validityCondition);
    }
    /**
     * Get ValidityCondition value
     * @return \StructType\ValidityConditionStructure[]|null
     */
    public function getValidityCondition()
    {
        return $this->ValidityCondition;
    }
    /**
     * Set ValidityCondition value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidityConditionStructure[] $validityCondition
     * @return \StructType\ValidityConditionsStructure
     */
    public function setValidityCondition(array $validityCondition = array())
    {
        foreach ($validityCondition as $validityConditionsStructureValidityConditionItem) {
            // validation for constraint: itemType
            if (!$validityConditionsStructureValidityConditionItem instanceof \StructType\ValidityConditionStructure) {
                throw new \InvalidArgumentException(sprintf('The ValidityCondition property can only contain items of \StructType\ValidityConditionStructure, "%s" given', is_object($validityConditionsStructureValidityConditionItem) ? get_class($validityConditionsStructureValidityConditionItem) : gettype($validityConditionsStructureValidityConditionItem)), __LINE__);
            }
        }
        $this->ValidityCondition = $validityCondition;
        return $this;
    }
    /**
     * Add item to ValidityCondition value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidityConditionStructure $item
     * @return \StructType\ValidityConditionsStructure
     */
    public function addToValidityCondition(\StructType\ValidityConditionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidityConditionStructure) {
            throw new \InvalidArgumentException(sprintf('The ValidityCondition property can only contain items of \StructType\ValidityConditionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValidityCondition[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidityConditionsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
