<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Validity StructType
 * @subpackage Structs
 */
class Validity extends AbstractStructBase
{
    /**
     * The validityStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $validityStatus;
    /**
     * The overrunning
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $overrunning;
    /**
     * The validityTimeSpecification
     * @var \StructType\OverallPeriod
     */
    public $validityTimeSpecification;
    /**
     * The validityExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $validityExtension;
    /**
     * Constructor method for Validity
     * @uses Validity::setValidityStatus()
     * @uses Validity::setOverrunning()
     * @uses Validity::setValidityTimeSpecification()
     * @uses Validity::setValidityExtension()
     * @param string $validityStatus
     * @param bool $overrunning
     * @param \StructType\OverallPeriod $validityTimeSpecification
     * @param \StructType\ExtensionType $validityExtension
     */
    public function __construct($validityStatus = null, $overrunning = null, \StructType\OverallPeriod $validityTimeSpecification = null, \StructType\ExtensionType $validityExtension = null)
    {
        $this
            ->setValidityStatus($validityStatus)
            ->setOverrunning($overrunning)
            ->setValidityTimeSpecification($validityTimeSpecification)
            ->setValidityExtension($validityExtension);
    }
    /**
     * Get validityStatus value
     * @return string
     */
    public function getValidityStatus()
    {
        return $this->validityStatus;
    }
    /**
     * Set validityStatus value
     * @uses \EnumType\ValidityStatusEnum::valueIsValid()
     * @uses \EnumType\ValidityStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validityStatus
     * @return \StructType\Validity
     */
    public function setValidityStatus($validityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidityStatusEnum::valueIsValid($validityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $validityStatus, implode(', ', \EnumType\ValidityStatusEnum::getValidValues())), __LINE__);
        }
        $this->validityStatus = $validityStatus;
        return $this;
    }
    /**
     * Get overrunning value
     * @return bool|null
     */
    public function getOverrunning()
    {
        return $this->overrunning;
    }
    /**
     * Set overrunning value
     * @param bool $overrunning
     * @return \StructType\Validity
     */
    public function setOverrunning($overrunning = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrunning) && !is_bool($overrunning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overrunning)), __LINE__);
        }
        $this->overrunning = $overrunning;
        return $this;
    }
    /**
     * Get validityTimeSpecification value
     * @return \StructType\OverallPeriod|null
     */
    public function getValidityTimeSpecification()
    {
        return $this->validityTimeSpecification;
    }
    /**
     * Set validityTimeSpecification value
     * @param \StructType\OverallPeriod $validityTimeSpecification
     * @return \StructType\Validity
     */
    public function setValidityTimeSpecification(\StructType\OverallPeriod $validityTimeSpecification = null)
    {
        $this->validityTimeSpecification = $validityTimeSpecification;
        return $this;
    }
    /**
     * Get validityExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getValidityExtension()
    {
        return $this->validityExtension;
    }
    /**
     * Set validityExtension value
     * @param \StructType\ExtensionType $validityExtension
     * @return \StructType\Validity
     */
    public function setValidityExtension(\StructType\ExtensionType $validityExtension = null)
    {
        $this->validityExtension = $validityExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Validity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
