<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UrlLink StructType
 * @subpackage Structs
 */
class UrlLink extends AbstractStructBase
{
    /**
     * The urlLinkAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $urlLinkAddress;
    /**
     * The urlLinkDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $urlLinkDescription;
    /**
     * The urlLinkType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlLinkType;
    /**
     * The urlLinkExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $urlLinkExtension;
    /**
     * Constructor method for UrlLink
     * @uses UrlLink::setUrlLinkAddress()
     * @uses UrlLink::setUrlLinkDescription()
     * @uses UrlLink::setUrlLinkType()
     * @uses UrlLink::setUrlLinkExtension()
     * @param string $urlLinkAddress
     * @param \StructType\MultilingualString $urlLinkDescription
     * @param string $urlLinkType
     * @param \StructType\ExtensionType $urlLinkExtension
     */
    public function __construct($urlLinkAddress = null, \StructType\MultilingualString $urlLinkDescription = null, $urlLinkType = null, \StructType\ExtensionType $urlLinkExtension = null)
    {
        $this
            ->setUrlLinkAddress($urlLinkAddress)
            ->setUrlLinkDescription($urlLinkDescription)
            ->setUrlLinkType($urlLinkType)
            ->setUrlLinkExtension($urlLinkExtension);
    }
    /**
     * Get urlLinkAddress value
     * @return string
     */
    public function getUrlLinkAddress()
    {
        return $this->urlLinkAddress;
    }
    /**
     * Set urlLinkAddress value
     * @param string $urlLinkAddress
     * @return \StructType\UrlLink
     */
    public function setUrlLinkAddress($urlLinkAddress = null)
    {
        // validation for constraint: string
        if (!is_null($urlLinkAddress) && !is_string($urlLinkAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($urlLinkAddress)), __LINE__);
        }
        $this->urlLinkAddress = $urlLinkAddress;
        return $this;
    }
    /**
     * Get urlLinkDescription value
     * @return \StructType\MultilingualString|null
     */
    public function getUrlLinkDescription()
    {
        return $this->urlLinkDescription;
    }
    /**
     * Set urlLinkDescription value
     * @param \StructType\MultilingualString $urlLinkDescription
     * @return \StructType\UrlLink
     */
    public function setUrlLinkDescription(\StructType\MultilingualString $urlLinkDescription = null)
    {
        $this->urlLinkDescription = $urlLinkDescription;
        return $this;
    }
    /**
     * Get urlLinkType value
     * @return string|null
     */
    public function getUrlLinkType()
    {
        return $this->urlLinkType;
    }
    /**
     * Set urlLinkType value
     * @uses \EnumType\UrlLinkTypeEnum::valueIsValid()
     * @uses \EnumType\UrlLinkTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urlLinkType
     * @return \StructType\UrlLink
     */
    public function setUrlLinkType($urlLinkType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UrlLinkTypeEnum::valueIsValid($urlLinkType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $urlLinkType, implode(', ', \EnumType\UrlLinkTypeEnum::getValidValues())), __LINE__);
        }
        $this->urlLinkType = $urlLinkType;
        return $this;
    }
    /**
     * Get urlLinkExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getUrlLinkExtension()
    {
        return $this->urlLinkExtension;
    }
    /**
     * Set urlLinkExtension value
     * @param \StructType\ExtensionType $urlLinkExtension
     * @return \StructType\UrlLink
     */
    public function setUrlLinkExtension(\StructType\ExtensionType $urlLinkExtension = null)
    {
        $this->urlLinkExtension = $urlLinkExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UrlLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
