<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportDescriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for implementation structure.
 * @subpackage Structs
 */
class TransportDescriptionStructure extends AbstractStructBase
{
    /**
     * The CommunicationsTransportMethod
     * Meta informations extracted from the WSDL
     * - default: httpPost
     * - documentation: Communications Transport method used to exchange messages. Default is 'httpPost'.
     * @var string
     */
    public $CommunicationsTransportMethod;
    /**
     * The CompressionMethod
     * Meta informations extracted from the WSDL
     * - default: none
     * - documentation: Compression method used to compress messages for transmission. Default is 'none'.
     * @var string
     */
    public $CompressionMethod;
    /**
     * Constructor method for TransportDescriptionStructure
     * @uses TransportDescriptionStructure::setCommunicationsTransportMethod()
     * @uses TransportDescriptionStructure::setCompressionMethod()
     * @param string $communicationsTransportMethod
     * @param string $compressionMethod
     */
    public function __construct($communicationsTransportMethod = 'httpPost', $compressionMethod = 'none')
    {
        $this
            ->setCommunicationsTransportMethod($communicationsTransportMethod)
            ->setCompressionMethod($compressionMethod);
    }
    /**
     * Get CommunicationsTransportMethod value
     * @return string|null
     */
    public function getCommunicationsTransportMethod()
    {
        return $this->CommunicationsTransportMethod;
    }
    /**
     * Set CommunicationsTransportMethod value
     * @uses \EnumType\CommunicationsTransportMethodEnumeration::valueIsValid()
     * @uses \EnumType\CommunicationsTransportMethodEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $communicationsTransportMethod
     * @return \StructType\TransportDescriptionStructure
     */
    public function setCommunicationsTransportMethod($communicationsTransportMethod = 'httpPost')
    {
        // validation for constraint: enumeration
        if (!\EnumType\CommunicationsTransportMethodEnumeration::valueIsValid($communicationsTransportMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $communicationsTransportMethod, implode(', ', \EnumType\CommunicationsTransportMethodEnumeration::getValidValues())), __LINE__);
        }
        $this->CommunicationsTransportMethod = $communicationsTransportMethod;
        return $this;
    }
    /**
     * Get CompressionMethod value
     * @return string|null
     */
    public function getCompressionMethod()
    {
        return $this->CompressionMethod;
    }
    /**
     * Set CompressionMethod value
     * @uses \EnumType\CompressionMethodEnumeration::valueIsValid()
     * @uses \EnumType\CompressionMethodEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $compressionMethod
     * @return \StructType\TransportDescriptionStructure
     */
    public function setCompressionMethod($compressionMethod = 'none')
    {
        // validation for constraint: enumeration
        if (!\EnumType\CompressionMethodEnumeration::valueIsValid($compressionMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $compressionMethod, implode(', ', \EnumType\CompressionMethodEnumeration::getValidValues())), __LINE__);
        }
        $this->CompressionMethod = $compressionMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransportDescriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
