<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrainNumbers StructType
 * Meta informations extracted from the WSDL
 * - documentation: TRAIN NUMBERs for journey. +SIRI v2.0 | TRAIN NUMBERs for journey. +SIRI v2.0
 * - minOccurs: 0
 * @subpackage Structs
 */
class TrainNumbers extends AbstractStructBase
{
    /**
     * The TrainNumberRef
     * Meta informations extracted from the WSDL
     * - documentation: TRAIN NUMBER assigned to VEHICLE JOURNEY. +SIRI 2.0 | TRAIN NUMBER assigned to VEHICLE JOURNEY. +SIRI 2.0
     * - maxOccurs: unbounded
     * @var \StructType\TrainNumberRefStructure[]
     */
    public $TrainNumberRef;
    /**
     * Constructor method for TrainNumbers
     * @uses TrainNumbers::setTrainNumberRef()
     * @param \StructType\TrainNumberRefStructure[] $trainNumberRef
     */
    public function __construct(array $trainNumberRef = array())
    {
        $this
            ->setTrainNumberRef($trainNumberRef);
    }
    /**
     * Get TrainNumberRef value
     * @return \StructType\TrainNumberRefStructure[]|null
     */
    public function getTrainNumberRef()
    {
        return $this->TrainNumberRef;
    }
    /**
     * Set TrainNumberRef value
     * @throws \InvalidArgumentException
     * @param \StructType\TrainNumberRefStructure[] $trainNumberRef
     * @return \StructType\TrainNumbers
     */
    public function setTrainNumberRef(array $trainNumberRef = array())
    {
        foreach ($trainNumberRef as $trainNumbersTrainNumberRefItem) {
            // validation for constraint: itemType
            if (!$trainNumbersTrainNumberRefItem instanceof \StructType\TrainNumberRefStructure) {
                throw new \InvalidArgumentException(sprintf('The TrainNumberRef property can only contain items of \StructType\TrainNumberRefStructure, "%s" given', is_object($trainNumbersTrainNumberRefItem) ? get_class($trainNumbersTrainNumberRefItem) : gettype($trainNumbersTrainNumberRefItem)), __LINE__);
            }
        }
        $this->TrainNumberRef = $trainNumberRef;
        return $this;
    }
    /**
     * Add item to TrainNumberRef value
     * @throws \InvalidArgumentException
     * @param \StructType\TrainNumberRefStructure $item
     * @return \StructType\TrainNumbers
     */
    public function addToTrainNumberRef(\StructType\TrainNumberRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrainNumberRefStructure) {
            throw new \InvalidArgumentException(sprintf('The TrainNumberRef property can only contain items of \StructType\TrainNumberRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrainNumberRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrainNumbers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
