<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficViewRecord StructType
 * @subpackage Structs
 */
class TrafficViewRecord extends AbstractStructBase
{
    /**
     * The recordSequenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $recordSequenceNumber;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The trafficElement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TrafficElement
     */
    public $trafficElement;
    /**
     * The operatorAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OperatorAction
     */
    public $operatorAction;
    /**
     * The elaboratedData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ElaboratedData
     */
    public $elaboratedData;
    /**
     * The urlLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UrlLink[]
     */
    public $urlLink;
    /**
     * The trafficViewRecordExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficViewRecordExtension;
    /**
     * Constructor method for TrafficViewRecord
     * @uses TrafficViewRecord::setRecordSequenceNumber()
     * @uses TrafficViewRecord::setId()
     * @uses TrafficViewRecord::setTrafficElement()
     * @uses TrafficViewRecord::setOperatorAction()
     * @uses TrafficViewRecord::setElaboratedData()
     * @uses TrafficViewRecord::setUrlLink()
     * @uses TrafficViewRecord::setTrafficViewRecordExtension()
     * @param int $recordSequenceNumber
     * @param string $id
     * @param \StructType\TrafficElement $trafficElement
     * @param \StructType\OperatorAction $operatorAction
     * @param \StructType\ElaboratedData $elaboratedData
     * @param \StructType\UrlLink[] $urlLink
     * @param \StructType\ExtensionType $trafficViewRecordExtension
     */
    public function __construct($recordSequenceNumber = null, $id = null, \StructType\TrafficElement $trafficElement = null, \StructType\OperatorAction $operatorAction = null, \StructType\ElaboratedData $elaboratedData = null, array $urlLink = array(), \StructType\ExtensionType $trafficViewRecordExtension = null)
    {
        $this
            ->setRecordSequenceNumber($recordSequenceNumber)
            ->setId($id)
            ->setTrafficElement($trafficElement)
            ->setOperatorAction($operatorAction)
            ->setElaboratedData($elaboratedData)
            ->setUrlLink($urlLink)
            ->setTrafficViewRecordExtension($trafficViewRecordExtension);
    }
    /**
     * Get recordSequenceNumber value
     * @return int
     */
    public function getRecordSequenceNumber()
    {
        return $this->recordSequenceNumber;
    }
    /**
     * Set recordSequenceNumber value
     * @param int $recordSequenceNumber
     * @return \StructType\TrafficViewRecord
     */
    public function setRecordSequenceNumber($recordSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordSequenceNumber) && !is_numeric($recordSequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordSequenceNumber)), __LINE__);
        }
        $this->recordSequenceNumber = $recordSequenceNumber;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\TrafficViewRecord
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get trafficElement value
     * @return \StructType\TrafficElement|null
     */
    public function getTrafficElement()
    {
        return $this->trafficElement;
    }
    /**
     * Set trafficElement value
     * @param \StructType\TrafficElement $trafficElement
     * @return \StructType\TrafficViewRecord
     */
    public function setTrafficElement(\StructType\TrafficElement $trafficElement = null)
    {
        $this->trafficElement = $trafficElement;
        return $this;
    }
    /**
     * Get operatorAction value
     * @return \StructType\OperatorAction|null
     */
    public function getOperatorAction()
    {
        return $this->operatorAction;
    }
    /**
     * Set operatorAction value
     * @param \StructType\OperatorAction $operatorAction
     * @return \StructType\TrafficViewRecord
     */
    public function setOperatorAction(\StructType\OperatorAction $operatorAction = null)
    {
        $this->operatorAction = $operatorAction;
        return $this;
    }
    /**
     * Get elaboratedData value
     * @return \StructType\ElaboratedData|null
     */
    public function getElaboratedData()
    {
        return $this->elaboratedData;
    }
    /**
     * Set elaboratedData value
     * @param \StructType\ElaboratedData $elaboratedData
     * @return \StructType\TrafficViewRecord
     */
    public function setElaboratedData(\StructType\ElaboratedData $elaboratedData = null)
    {
        $this->elaboratedData = $elaboratedData;
        return $this;
    }
    /**
     * Get urlLink value
     * @return \StructType\UrlLink[]|null
     */
    public function getUrlLink()
    {
        return $this->urlLink;
    }
    /**
     * Set urlLink value
     * @throws \InvalidArgumentException
     * @param \StructType\UrlLink[] $urlLink
     * @return \StructType\TrafficViewRecord
     */
    public function setUrlLink(array $urlLink = array())
    {
        foreach ($urlLink as $trafficViewRecordUrlLinkItem) {
            // validation for constraint: itemType
            if (!$trafficViewRecordUrlLinkItem instanceof \StructType\UrlLink) {
                throw new \InvalidArgumentException(sprintf('The urlLink property can only contain items of \StructType\UrlLink, "%s" given', is_object($trafficViewRecordUrlLinkItem) ? get_class($trafficViewRecordUrlLinkItem) : gettype($trafficViewRecordUrlLinkItem)), __LINE__);
            }
        }
        $this->urlLink = $urlLink;
        return $this;
    }
    /**
     * Add item to urlLink value
     * @throws \InvalidArgumentException
     * @param \StructType\UrlLink $item
     * @return \StructType\TrafficViewRecord
     */
    public function addToUrlLink(\StructType\UrlLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UrlLink) {
            throw new \InvalidArgumentException(sprintf('The urlLink property can only contain items of \StructType\UrlLink, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->urlLink[] = $item;
        return $this;
    }
    /**
     * Get trafficViewRecordExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficViewRecordExtension()
    {
        return $this->trafficViewRecordExtension;
    }
    /**
     * Set trafficViewRecordExtension value
     * @param \StructType\ExtensionType $trafficViewRecordExtension
     * @return \StructType\TrafficViewRecord
     */
    public function setTrafficViewRecordExtension(\StructType\ExtensionType $trafficViewRecordExtension = null)
    {
        $this->trafficViewRecordExtension = $trafficViewRecordExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficViewRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
