<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficViewPublication StructType
 * @subpackage Structs
 */
class TrafficViewPublication extends PayloadPublication
{
    /**
     * The headerInformation
     * @var \StructType\HeaderInformation
     */
    public $headerInformation;
    /**
     * The trafficView
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TrafficView[]
     */
    public $trafficView;
    /**
     * The trafficViewPublicationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficViewPublicationExtension;
    /**
     * Constructor method for TrafficViewPublication
     * @uses TrafficViewPublication::setHeaderInformation()
     * @uses TrafficViewPublication::setTrafficView()
     * @uses TrafficViewPublication::setTrafficViewPublicationExtension()
     * @param \StructType\HeaderInformation $headerInformation
     * @param \StructType\TrafficView[] $trafficView
     * @param \StructType\ExtensionType $trafficViewPublicationExtension
     */
    public function __construct(\StructType\HeaderInformation $headerInformation = null, array $trafficView = array(), \StructType\ExtensionType $trafficViewPublicationExtension = null)
    {
        $this
            ->setHeaderInformation($headerInformation)
            ->setTrafficView($trafficView)
            ->setTrafficViewPublicationExtension($trafficViewPublicationExtension);
    }
    /**
     * Get headerInformation value
     * @return \StructType\HeaderInformation|null
     */
    public function getHeaderInformation()
    {
        return $this->headerInformation;
    }
    /**
     * Set headerInformation value
     * @param \StructType\HeaderInformation $headerInformation
     * @return \StructType\TrafficViewPublication
     */
    public function setHeaderInformation(\StructType\HeaderInformation $headerInformation = null)
    {
        $this->headerInformation = $headerInformation;
        return $this;
    }
    /**
     * Get trafficView value
     * @return \StructType\TrafficView[]|null
     */
    public function getTrafficView()
    {
        return $this->trafficView;
    }
    /**
     * Set trafficView value
     * @throws \InvalidArgumentException
     * @param \StructType\TrafficView[] $trafficView
     * @return \StructType\TrafficViewPublication
     */
    public function setTrafficView(array $trafficView = array())
    {
        foreach ($trafficView as $trafficViewPublicationTrafficViewItem) {
            // validation for constraint: itemType
            if (!$trafficViewPublicationTrafficViewItem instanceof \StructType\TrafficView) {
                throw new \InvalidArgumentException(sprintf('The trafficView property can only contain items of \StructType\TrafficView, "%s" given', is_object($trafficViewPublicationTrafficViewItem) ? get_class($trafficViewPublicationTrafficViewItem) : gettype($trafficViewPublicationTrafficViewItem)), __LINE__);
            }
        }
        $this->trafficView = $trafficView;
        return $this;
    }
    /**
     * Add item to trafficView value
     * @throws \InvalidArgumentException
     * @param \StructType\TrafficView $item
     * @return \StructType\TrafficViewPublication
     */
    public function addToTrafficView(\StructType\TrafficView $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrafficView) {
            throw new \InvalidArgumentException(sprintf('The trafficView property can only contain items of \StructType\TrafficView, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->trafficView[] = $item;
        return $this;
    }
    /**
     * Get trafficViewPublicationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficViewPublicationExtension()
    {
        return $this->trafficViewPublicationExtension;
    }
    /**
     * Set trafficViewPublicationExtension value
     * @param \StructType\ExtensionType $trafficViewPublicationExtension
     * @return \StructType\TrafficViewPublication
     */
    public function setTrafficViewPublicationExtension(\StructType\ExtensionType $trafficViewPublicationExtension = null)
    {
        $this->trafficViewPublicationExtension = $trafficViewPublicationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficViewPublication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
