<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficView StructType
 * @subpackage Structs
 */
class TrafficView extends AbstractStructBase
{
    /**
     * The trafficViewTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $trafficViewTime;
    /**
     * The predefinedLocationSetReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $predefinedLocationSetReference;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The linearTrafficView
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\LinearTrafficView[]
     */
    public $linearTrafficView;
    /**
     * The trafficViewExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficViewExtension;
    /**
     * Constructor method for TrafficView
     * @uses TrafficView::setTrafficViewTime()
     * @uses TrafficView::setPredefinedLocationSetReference()
     * @uses TrafficView::setId()
     * @uses TrafficView::setLinearTrafficView()
     * @uses TrafficView::setTrafficViewExtension()
     * @param string $trafficViewTime
     * @param string $predefinedLocationSetReference
     * @param string $id
     * @param \StructType\LinearTrafficView[] $linearTrafficView
     * @param \StructType\ExtensionType $trafficViewExtension
     */
    public function __construct($trafficViewTime = null, $predefinedLocationSetReference = null, $id = null, array $linearTrafficView = array(), \StructType\ExtensionType $trafficViewExtension = null)
    {
        $this
            ->setTrafficViewTime($trafficViewTime)
            ->setPredefinedLocationSetReference($predefinedLocationSetReference)
            ->setId($id)
            ->setLinearTrafficView($linearTrafficView)
            ->setTrafficViewExtension($trafficViewExtension);
    }
    /**
     * Get trafficViewTime value
     * @return string
     */
    public function getTrafficViewTime()
    {
        return $this->trafficViewTime;
    }
    /**
     * Set trafficViewTime value
     * @param string $trafficViewTime
     * @return \StructType\TrafficView
     */
    public function setTrafficViewTime($trafficViewTime = null)
    {
        // validation for constraint: string
        if (!is_null($trafficViewTime) && !is_string($trafficViewTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trafficViewTime)), __LINE__);
        }
        $this->trafficViewTime = $trafficViewTime;
        return $this;
    }
    /**
     * Get predefinedLocationSetReference value
     * @return string
     */
    public function getPredefinedLocationSetReference()
    {
        return $this->predefinedLocationSetReference;
    }
    /**
     * Set predefinedLocationSetReference value
     * @param string $predefinedLocationSetReference
     * @return \StructType\TrafficView
     */
    public function setPredefinedLocationSetReference($predefinedLocationSetReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($predefinedLocationSetReference) && strlen($predefinedLocationSetReference) > 1024) || (is_array($predefinedLocationSetReference) && count($predefinedLocationSetReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($predefinedLocationSetReference) ? strlen($predefinedLocationSetReference) : count($predefinedLocationSetReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($predefinedLocationSetReference) && !is_string($predefinedLocationSetReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($predefinedLocationSetReference)), __LINE__);
        }
        $this->predefinedLocationSetReference = $predefinedLocationSetReference;
        return $this;
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\TrafficView
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get linearTrafficView value
     * @return \StructType\LinearTrafficView[]|null
     */
    public function getLinearTrafficView()
    {
        return $this->linearTrafficView;
    }
    /**
     * Set linearTrafficView value
     * @throws \InvalidArgumentException
     * @param \StructType\LinearTrafficView[] $linearTrafficView
     * @return \StructType\TrafficView
     */
    public function setLinearTrafficView(array $linearTrafficView = array())
    {
        foreach ($linearTrafficView as $trafficViewLinearTrafficViewItem) {
            // validation for constraint: itemType
            if (!$trafficViewLinearTrafficViewItem instanceof \StructType\LinearTrafficView) {
                throw new \InvalidArgumentException(sprintf('The linearTrafficView property can only contain items of \StructType\LinearTrafficView, "%s" given', is_object($trafficViewLinearTrafficViewItem) ? get_class($trafficViewLinearTrafficViewItem) : gettype($trafficViewLinearTrafficViewItem)), __LINE__);
            }
        }
        $this->linearTrafficView = $linearTrafficView;
        return $this;
    }
    /**
     * Add item to linearTrafficView value
     * @throws \InvalidArgumentException
     * @param \StructType\LinearTrafficView $item
     * @return \StructType\TrafficView
     */
    public function addToLinearTrafficView(\StructType\LinearTrafficView $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinearTrafficView) {
            throw new \InvalidArgumentException(sprintf('The linearTrafficView property can only contain items of \StructType\LinearTrafficView, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->linearTrafficView[] = $item;
        return $this;
    }
    /**
     * Get trafficViewExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficViewExtension()
    {
        return $this->trafficViewExtension;
    }
    /**
     * Set trafficViewExtension value
     * @param \StructType\ExtensionType $trafficViewExtension
     * @return \StructType\TrafficView
     */
    public function setTrafficViewExtension(\StructType\ExtensionType $trafficViewExtension = null)
    {
        $this->trafficViewExtension = $trafficViewExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
