<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficStatusValue StructType
 * @subpackage Structs
 */
class TrafficStatusValue extends BasicDataValue
{
    /**
     * The trafficStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficStatus;
    /**
     * The trafficTrendType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trafficTrendType;
    /**
     * The trafficStatusValueExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficStatusValueExtension;
    /**
     * Constructor method for TrafficStatusValue
     * @uses TrafficStatusValue::setTrafficStatus()
     * @uses TrafficStatusValue::setTrafficTrendType()
     * @uses TrafficStatusValue::setTrafficStatusValueExtension()
     * @param string $trafficStatus
     * @param string $trafficTrendType
     * @param \StructType\ExtensionType $trafficStatusValueExtension
     */
    public function __construct($trafficStatus = null, $trafficTrendType = null, \StructType\ExtensionType $trafficStatusValueExtension = null)
    {
        $this
            ->setTrafficStatus($trafficStatus)
            ->setTrafficTrendType($trafficTrendType)
            ->setTrafficStatusValueExtension($trafficStatusValueExtension);
    }
    /**
     * Get trafficStatus value
     * @return string|null
     */
    public function getTrafficStatus()
    {
        return $this->trafficStatus;
    }
    /**
     * Set trafficStatus value
     * @uses \EnumType\TrafficStatusEnum::valueIsValid()
     * @uses \EnumType\TrafficStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficStatus
     * @return \StructType\TrafficStatusValue
     */
    public function setTrafficStatus($trafficStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficStatusEnum::valueIsValid($trafficStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficStatus, implode(', ', \EnumType\TrafficStatusEnum::getValidValues())), __LINE__);
        }
        $this->trafficStatus = $trafficStatus;
        return $this;
    }
    /**
     * Get trafficTrendType value
     * @return string|null
     */
    public function getTrafficTrendType()
    {
        return $this->trafficTrendType;
    }
    /**
     * Set trafficTrendType value
     * @uses \EnumType\TrafficTrendTypeEnum::valueIsValid()
     * @uses \EnumType\TrafficTrendTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trafficTrendType
     * @return \StructType\TrafficStatusValue
     */
    public function setTrafficTrendType($trafficTrendType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrafficTrendTypeEnum::valueIsValid($trafficTrendType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trafficTrendType, implode(', ', \EnumType\TrafficTrendTypeEnum::getValidValues())), __LINE__);
        }
        $this->trafficTrendType = $trafficTrendType;
        return $this;
    }
    /**
     * Get trafficStatusValueExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficStatusValueExtension()
    {
        return $this->trafficStatusValueExtension;
    }
    /**
     * Set trafficStatusValueExtension value
     * @param \StructType\ExtensionType $trafficStatusValueExtension
     * @return \StructType\TrafficStatusValue
     */
    public function setTrafficStatusValueExtension(\StructType\ExtensionType $trafficStatusValueExtension = null)
    {
        $this->trafficStatusValueExtension = $trafficStatusValueExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficStatusValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
