<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegSimplePoint StructType
 * @subpackage Structs
 */
class TpegSimplePoint extends TpegPointLocation
{
    /**
     * The tpegSimplePointLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tpegSimplePointLocationType;
    /**
     * The point
     * @var \StructType\TpegPoint
     */
    public $point;
    /**
     * The tpegSimplePointExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegSimplePointExtension;
    /**
     * Constructor method for TpegSimplePoint
     * @uses TpegSimplePoint::setTpegSimplePointLocationType()
     * @uses TpegSimplePoint::setPoint()
     * @uses TpegSimplePoint::setTpegSimplePointExtension()
     * @param string $tpegSimplePointLocationType
     * @param \StructType\TpegPoint $point
     * @param \StructType\ExtensionType $tpegSimplePointExtension
     */
    public function __construct($tpegSimplePointLocationType = null, \StructType\TpegPoint $point = null, \StructType\ExtensionType $tpegSimplePointExtension = null)
    {
        $this
            ->setTpegSimplePointLocationType($tpegSimplePointLocationType)
            ->setPoint($point)
            ->setTpegSimplePointExtension($tpegSimplePointExtension);
    }
    /**
     * Get tpegSimplePointLocationType value
     * @return string
     */
    public function getTpegSimplePointLocationType()
    {
        return $this->tpegSimplePointLocationType;
    }
    /**
     * Set tpegSimplePointLocationType value
     * @uses \EnumType\TpegLoc01SimplePointLocationSubtypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc01SimplePointLocationSubtypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tpegSimplePointLocationType
     * @return \StructType\TpegSimplePoint
     */
    public function setTpegSimplePointLocationType($tpegSimplePointLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc01SimplePointLocationSubtypeEnum::valueIsValid($tpegSimplePointLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tpegSimplePointLocationType, implode(', ', \EnumType\TpegLoc01SimplePointLocationSubtypeEnum::getValidValues())), __LINE__);
        }
        $this->tpegSimplePointLocationType = $tpegSimplePointLocationType;
        return $this;
    }
    /**
     * Get point value
     * @return \StructType\TpegPoint|null
     */
    public function getPoint()
    {
        return $this->point;
    }
    /**
     * Set point value
     * @param \StructType\TpegPoint $point
     * @return \StructType\TpegSimplePoint
     */
    public function setPoint(\StructType\TpegPoint $point = null)
    {
        $this->point = $point;
        return $this;
    }
    /**
     * Get tpegSimplePointExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegSimplePointExtension()
    {
        return $this->tpegSimplePointExtension;
    }
    /**
     * Set tpegSimplePointExtension value
     * @param \StructType\ExtensionType $tpegSimplePointExtension
     * @return \StructType\TpegSimplePoint
     */
    public function setTpegSimplePointExtension(\StructType\ExtensionType $tpegSimplePointExtension = null)
    {
        $this->tpegSimplePointExtension = $tpegSimplePointExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegSimplePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
