<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegPointLocation StructType
 * @subpackage Structs
 */
abstract class TpegPointLocation extends AbstractStructBase
{
    /**
     * The tpegDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tpegDirection;
    /**
     * The tpegPointLocationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegPointLocationExtension;
    /**
     * Constructor method for TpegPointLocation
     * @uses TpegPointLocation::setTpegDirection()
     * @uses TpegPointLocation::setTpegPointLocationExtension()
     * @param string $tpegDirection
     * @param \StructType\ExtensionType $tpegPointLocationExtension
     */
    public function __construct($tpegDirection = null, \StructType\ExtensionType $tpegPointLocationExtension = null)
    {
        $this
            ->setTpegDirection($tpegDirection)
            ->setTpegPointLocationExtension($tpegPointLocationExtension);
    }
    /**
     * Get tpegDirection value
     * @return string
     */
    public function getTpegDirection()
    {
        return $this->tpegDirection;
    }
    /**
     * Set tpegDirection value
     * @uses \EnumType\TpegLoc02DirectionTypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc02DirectionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tpegDirection
     * @return \StructType\TpegPointLocation
     */
    public function setTpegDirection($tpegDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc02DirectionTypeEnum::valueIsValid($tpegDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tpegDirection, implode(', ', \EnumType\TpegLoc02DirectionTypeEnum::getValidValues())), __LINE__);
        }
        $this->tpegDirection = $tpegDirection;
        return $this;
    }
    /**
     * Get tpegPointLocationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegPointLocationExtension()
    {
        return $this->tpegPointLocationExtension;
    }
    /**
     * Set tpegPointLocationExtension value
     * @param \StructType\ExtensionType $tpegPointLocationExtension
     * @return \StructType\TpegPointLocation
     */
    public function setTpegPointLocationExtension(\StructType\ExtensionType $tpegPointLocationExtension = null)
    {
        $this->tpegPointLocationExtension = $tpegPointLocationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegPointLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
