<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegNonJunctionPoint StructType
 * @subpackage Structs
 */
class TpegNonJunctionPoint extends TpegPoint
{
    /**
     * The pointCoordinates
     * @var \StructType\PointCoordinates
     */
    public $pointCoordinates;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TpegOtherPointDescriptor[]
     */
    public $name;
    /**
     * The tpegNonJunctionPointExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegNonJunctionPointExtension;
    /**
     * Constructor method for TpegNonJunctionPoint
     * @uses TpegNonJunctionPoint::setPointCoordinates()
     * @uses TpegNonJunctionPoint::setName()
     * @uses TpegNonJunctionPoint::setTpegNonJunctionPointExtension()
     * @param \StructType\PointCoordinates $pointCoordinates
     * @param \StructType\TpegOtherPointDescriptor[] $name
     * @param \StructType\ExtensionType $tpegNonJunctionPointExtension
     */
    public function __construct(\StructType\PointCoordinates $pointCoordinates = null, array $name = array(), \StructType\ExtensionType $tpegNonJunctionPointExtension = null)
    {
        $this
            ->setPointCoordinates($pointCoordinates)
            ->setName($name)
            ->setTpegNonJunctionPointExtension($tpegNonJunctionPointExtension);
    }
    /**
     * Get pointCoordinates value
     * @return \StructType\PointCoordinates|null
     */
    public function getPointCoordinates()
    {
        return $this->pointCoordinates;
    }
    /**
     * Set pointCoordinates value
     * @param \StructType\PointCoordinates $pointCoordinates
     * @return \StructType\TpegNonJunctionPoint
     */
    public function setPointCoordinates(\StructType\PointCoordinates $pointCoordinates = null)
    {
        $this->pointCoordinates = $pointCoordinates;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\TpegOtherPointDescriptor[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\TpegOtherPointDescriptor[] $name
     * @return \StructType\TpegNonJunctionPoint
     */
    public function setName(array $name = array())
    {
        foreach ($name as $tpegNonJunctionPointNameItem) {
            // validation for constraint: itemType
            if (!$tpegNonJunctionPointNameItem instanceof \StructType\TpegOtherPointDescriptor) {
                throw new \InvalidArgumentException(sprintf('The name property can only contain items of \StructType\TpegOtherPointDescriptor, "%s" given', is_object($tpegNonJunctionPointNameItem) ? get_class($tpegNonJunctionPointNameItem) : gettype($tpegNonJunctionPointNameItem)), __LINE__);
            }
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\TpegOtherPointDescriptor $item
     * @return \StructType\TpegNonJunctionPoint
     */
    public function addToName(\StructType\TpegOtherPointDescriptor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TpegOtherPointDescriptor) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of \StructType\TpegOtherPointDescriptor, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get tpegNonJunctionPointExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegNonJunctionPointExtension()
    {
        return $this->tpegNonJunctionPointExtension;
    }
    /**
     * Set tpegNonJunctionPointExtension value
     * @param \StructType\ExtensionType $tpegNonJunctionPointExtension
     * @return \StructType\TpegNonJunctionPoint
     */
    public function setTpegNonJunctionPointExtension(\StructType\ExtensionType $tpegNonJunctionPointExtension = null)
    {
        $this->tpegNonJunctionPointExtension = $tpegNonJunctionPointExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegNonJunctionPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
