<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegJunction StructType
 * @subpackage Structs
 */
class TpegJunction extends TpegPoint
{
    /**
     * The pointCoordinates
     * @var \StructType\PointCoordinates
     */
    public $pointCoordinates;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TpegJunctionPointDescriptor
     */
    public $name;
    /**
     * The ilc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * @var \StructType\TpegIlcPointDescriptor[]
     */
    public $ilc;
    /**
     * The otherName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TpegOtherPointDescriptor[]
     */
    public $otherName;
    /**
     * The tpegJunctionExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegJunctionExtension;
    /**
     * Constructor method for TpegJunction
     * @uses TpegJunction::setPointCoordinates()
     * @uses TpegJunction::setName()
     * @uses TpegJunction::setIlc()
     * @uses TpegJunction::setOtherName()
     * @uses TpegJunction::setTpegJunctionExtension()
     * @param \StructType\PointCoordinates $pointCoordinates
     * @param \StructType\TpegJunctionPointDescriptor $name
     * @param \StructType\TpegIlcPointDescriptor[] $ilc
     * @param \StructType\TpegOtherPointDescriptor[] $otherName
     * @param \StructType\ExtensionType $tpegJunctionExtension
     */
    public function __construct(\StructType\PointCoordinates $pointCoordinates = null, \StructType\TpegJunctionPointDescriptor $name = null, array $ilc = array(), array $otherName = array(), \StructType\ExtensionType $tpegJunctionExtension = null)
    {
        $this
            ->setPointCoordinates($pointCoordinates)
            ->setName($name)
            ->setIlc($ilc)
            ->setOtherName($otherName)
            ->setTpegJunctionExtension($tpegJunctionExtension);
    }
    /**
     * Get pointCoordinates value
     * @return \StructType\PointCoordinates|null
     */
    public function getPointCoordinates()
    {
        return $this->pointCoordinates;
    }
    /**
     * Set pointCoordinates value
     * @param \StructType\PointCoordinates $pointCoordinates
     * @return \StructType\TpegJunction
     */
    public function setPointCoordinates(\StructType\PointCoordinates $pointCoordinates = null)
    {
        $this->pointCoordinates = $pointCoordinates;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\TpegJunctionPointDescriptor|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\TpegJunctionPointDescriptor $name
     * @return \StructType\TpegJunction
     */
    public function setName(\StructType\TpegJunctionPointDescriptor $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ilc value
     * @return \StructType\TpegIlcPointDescriptor[]|null
     */
    public function getIlc()
    {
        return $this->ilc;
    }
    /**
     * Set ilc value
     * @throws \InvalidArgumentException
     * @param \StructType\TpegIlcPointDescriptor[] $ilc
     * @return \StructType\TpegJunction
     */
    public function setIlc(array $ilc = array())
    {
        foreach ($ilc as $tpegJunctionIlcItem) {
            // validation for constraint: itemType
            if (!$tpegJunctionIlcItem instanceof \StructType\TpegIlcPointDescriptor) {
                throw new \InvalidArgumentException(sprintf('The ilc property can only contain items of \StructType\TpegIlcPointDescriptor, "%s" given', is_object($tpegJunctionIlcItem) ? get_class($tpegJunctionIlcItem) : gettype($tpegJunctionIlcItem)), __LINE__);
            }
        }
        $this->ilc = $ilc;
        return $this;
    }
    /**
     * Add item to ilc value
     * @throws \InvalidArgumentException
     * @param \StructType\TpegIlcPointDescriptor $item
     * @return \StructType\TpegJunction
     */
    public function addToIlc(\StructType\TpegIlcPointDescriptor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TpegIlcPointDescriptor) {
            throw new \InvalidArgumentException(sprintf('The ilc property can only contain items of \StructType\TpegIlcPointDescriptor, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ilc[] = $item;
        return $this;
    }
    /**
     * Get otherName value
     * @return \StructType\TpegOtherPointDescriptor[]|null
     */
    public function getOtherName()
    {
        return $this->otherName;
    }
    /**
     * Set otherName value
     * @throws \InvalidArgumentException
     * @param \StructType\TpegOtherPointDescriptor[] $otherName
     * @return \StructType\TpegJunction
     */
    public function setOtherName(array $otherName = array())
    {
        foreach ($otherName as $tpegJunctionOtherNameItem) {
            // validation for constraint: itemType
            if (!$tpegJunctionOtherNameItem instanceof \StructType\TpegOtherPointDescriptor) {
                throw new \InvalidArgumentException(sprintf('The otherName property can only contain items of \StructType\TpegOtherPointDescriptor, "%s" given', is_object($tpegJunctionOtherNameItem) ? get_class($tpegJunctionOtherNameItem) : gettype($tpegJunctionOtherNameItem)), __LINE__);
            }
        }
        $this->otherName = $otherName;
        return $this;
    }
    /**
     * Add item to otherName value
     * @throws \InvalidArgumentException
     * @param \StructType\TpegOtherPointDescriptor $item
     * @return \StructType\TpegJunction
     */
    public function addToOtherName(\StructType\TpegOtherPointDescriptor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TpegOtherPointDescriptor) {
            throw new \InvalidArgumentException(sprintf('The otherName property can only contain items of \StructType\TpegOtherPointDescriptor, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->otherName[] = $item;
        return $this;
    }
    /**
     * Get tpegJunctionExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegJunctionExtension()
    {
        return $this->tpegJunctionExtension;
    }
    /**
     * Set tpegJunctionExtension value
     * @param \StructType\ExtensionType $tpegJunctionExtension
     * @return \StructType\TpegJunction
     */
    public function setTpegJunctionExtension(\StructType\ExtensionType $tpegJunctionExtension = null)
    {
        $this->tpegJunctionExtension = $tpegJunctionExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegJunction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
