<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegHeight StructType
 * @subpackage Structs
 */
class TpegHeight extends AbstractStructBase
{
    /**
     * The heightType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $heightType;
    /**
     * The height
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $height;
    /**
     * The tpegHeightExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegHeightExtension;
    /**
     * Constructor method for TpegHeight
     * @uses TpegHeight::setHeightType()
     * @uses TpegHeight::setHeight()
     * @uses TpegHeight::setTpegHeightExtension()
     * @param string $heightType
     * @param float $height
     * @param \StructType\ExtensionType $tpegHeightExtension
     */
    public function __construct($heightType = null, $height = null, \StructType\ExtensionType $tpegHeightExtension = null)
    {
        $this
            ->setHeightType($heightType)
            ->setHeight($height)
            ->setTpegHeightExtension($tpegHeightExtension);
    }
    /**
     * Get heightType value
     * @return string
     */
    public function getHeightType()
    {
        return $this->heightType;
    }
    /**
     * Set heightType value
     * @uses \EnumType\TpegLoc04HeightTypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc04HeightTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $heightType
     * @return \StructType\TpegHeight
     */
    public function setHeightType($heightType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc04HeightTypeEnum::valueIsValid($heightType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $heightType, implode(', ', \EnumType\TpegLoc04HeightTypeEnum::getValidValues())), __LINE__);
        }
        $this->heightType = $heightType;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \StructType\TpegHeight
     */
    public function setHeight($height = null)
    {
        $this->height = $height;
        return $this;
    }
    /**
     * Get tpegHeightExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegHeightExtension()
    {
        return $this->tpegHeightExtension;
    }
    /**
     * Set tpegHeightExtension value
     * @param \StructType\ExtensionType $tpegHeightExtension
     * @return \StructType\TpegHeight
     */
    public function setTpegHeightExtension(\StructType\ExtensionType $tpegHeightExtension = null)
    {
        $this->tpegHeightExtension = $tpegHeightExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegHeight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
