<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegGeometricArea StructType
 * @subpackage Structs
 */
class TpegGeometricArea extends TpegAreaLocation
{
    /**
     * The radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $radius;
    /**
     * The centrePoint
     * @var \StructType\PointCoordinates
     */
    public $centrePoint;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TpegAreaDescriptor
     */
    public $name;
    /**
     * The tpegGeometricAreaExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegGeometricAreaExtension;
    /**
     * Constructor method for TpegGeometricArea
     * @uses TpegGeometricArea::setRadius()
     * @uses TpegGeometricArea::setCentrePoint()
     * @uses TpegGeometricArea::setName()
     * @uses TpegGeometricArea::setTpegGeometricAreaExtension()
     * @param int $radius
     * @param \StructType\PointCoordinates $centrePoint
     * @param \StructType\TpegAreaDescriptor $name
     * @param \StructType\ExtensionType $tpegGeometricAreaExtension
     */
    public function __construct($radius = null, \StructType\PointCoordinates $centrePoint = null, \StructType\TpegAreaDescriptor $name = null, \StructType\ExtensionType $tpegGeometricAreaExtension = null)
    {
        $this
            ->setRadius($radius)
            ->setCentrePoint($centrePoint)
            ->setName($name)
            ->setTpegGeometricAreaExtension($tpegGeometricAreaExtension);
    }
    /**
     * Get radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->radius;
    }
    /**
     * Set radius value
     * @param int $radius
     * @return \StructType\TpegGeometricArea
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->radius = $radius;
        return $this;
    }
    /**
     * Get centrePoint value
     * @return \StructType\PointCoordinates|null
     */
    public function getCentrePoint()
    {
        return $this->centrePoint;
    }
    /**
     * Set centrePoint value
     * @param \StructType\PointCoordinates $centrePoint
     * @return \StructType\TpegGeometricArea
     */
    public function setCentrePoint(\StructType\PointCoordinates $centrePoint = null)
    {
        $this->centrePoint = $centrePoint;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\TpegAreaDescriptor|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\TpegAreaDescriptor $name
     * @return \StructType\TpegGeometricArea
     */
    public function setName(\StructType\TpegAreaDescriptor $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get tpegGeometricAreaExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegGeometricAreaExtension()
    {
        return $this->tpegGeometricAreaExtension;
    }
    /**
     * Set tpegGeometricAreaExtension value
     * @param \StructType\ExtensionType $tpegGeometricAreaExtension
     * @return \StructType\TpegGeometricArea
     */
    public function setTpegGeometricAreaExtension(\StructType\ExtensionType $tpegGeometricAreaExtension = null)
    {
        $this->tpegGeometricAreaExtension = $tpegGeometricAreaExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegGeometricArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
