<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Temperature StructType
 * @subpackage Structs
 */
class Temperature extends AbstractStructBase
{
    /**
     * The airTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $airTemperature;
    /**
     * The dewPointTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $dewPointTemperature;
    /**
     * The maximumTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $maximumTemperature;
    /**
     * The minimumTemperature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $minimumTemperature;
    /**
     * The temperatureExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $temperatureExtension;
    /**
     * Constructor method for Temperature
     * @uses Temperature::setAirTemperature()
     * @uses Temperature::setDewPointTemperature()
     * @uses Temperature::setMaximumTemperature()
     * @uses Temperature::setMinimumTemperature()
     * @uses Temperature::setTemperatureExtension()
     * @param float $airTemperature
     * @param float $dewPointTemperature
     * @param float $maximumTemperature
     * @param float $minimumTemperature
     * @param \StructType\ExtensionType $temperatureExtension
     */
    public function __construct($airTemperature = null, $dewPointTemperature = null, $maximumTemperature = null, $minimumTemperature = null, \StructType\ExtensionType $temperatureExtension = null)
    {
        $this
            ->setAirTemperature($airTemperature)
            ->setDewPointTemperature($dewPointTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature)
            ->setTemperatureExtension($temperatureExtension);
    }
    /**
     * Get airTemperature value
     * @return float|null
     */
    public function getAirTemperature()
    {
        return $this->airTemperature;
    }
    /**
     * Set airTemperature value
     * @param float $airTemperature
     * @return \StructType\Temperature
     */
    public function setAirTemperature($airTemperature = null)
    {
        $this->airTemperature = $airTemperature;
        return $this;
    }
    /**
     * Get dewPointTemperature value
     * @return float|null
     */
    public function getDewPointTemperature()
    {
        return $this->dewPointTemperature;
    }
    /**
     * Set dewPointTemperature value
     * @param float $dewPointTemperature
     * @return \StructType\Temperature
     */
    public function setDewPointTemperature($dewPointTemperature = null)
    {
        $this->dewPointTemperature = $dewPointTemperature;
        return $this;
    }
    /**
     * Get maximumTemperature value
     * @return float|null
     */
    public function getMaximumTemperature()
    {
        return $this->maximumTemperature;
    }
    /**
     * Set maximumTemperature value
     * @param float $maximumTemperature
     * @return \StructType\Temperature
     */
    public function setMaximumTemperature($maximumTemperature = null)
    {
        $this->maximumTemperature = $maximumTemperature;
        return $this;
    }
    /**
     * Get minimumTemperature value
     * @return float|null
     */
    public function getMinimumTemperature()
    {
        return $this->minimumTemperature;
    }
    /**
     * Set minimumTemperature value
     * @param float $minimumTemperature
     * @return \StructType\Temperature
     */
    public function setMinimumTemperature($minimumTemperature = null)
    {
        $this->minimumTemperature = $minimumTemperature;
        return $this;
    }
    /**
     * Get temperatureExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTemperatureExtension()
    {
        return $this->temperatureExtension;
    }
    /**
     * Set temperatureExtension value
     * @param \StructType\ExtensionType $temperatureExtension
     * @return \StructType\Temperature
     */
    public function setTemperatureExtension(\StructType\ExtensionType $temperatureExtension = null)
    {
        $this->temperatureExtension = $temperatureExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Temperature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
