<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetedVehicleJourneyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a targeted VEHICLE JOURNEY.
 * @subpackage Structs
 */
class TargetedVehicleJourneyStructure extends AbstractStructBase
{
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The DirectionRef
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The FramedVehicleJourneyRef
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The JourneyPatternRef
     * @var \StructType\JourneyPatternRefStructure
     */
    public $JourneyPatternRef;
    /**
     * The JourneyPatternName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyPatternName;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The RouteRef
     * @var \StructType\RouteRefStructure
     */
    public $RouteRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The GroupOfLinesRef
     * @var \StructType\GroupOfLinesRefStructure
     */
    public $GroupOfLinesRef;
    /**
     * The DirectionName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DirectionName;
    /**
     * The ExternalLineRef
     * @var \StructType\LineRefStructure
     */
    public $ExternalLineRef;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * The OriginRef
     * @var \StructType\JourneyPlaceRefStructure
     */
    public $OriginRef;
    /**
     * The OriginName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $OriginName;
    /**
     * The OriginShortName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $OriginShortName;
    /**
     * The DestinationDisplayAtOrigin
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $DestinationDisplayAtOrigin;
    /**
     * The Via
     * @var \StructType\ViaNameStructure
     */
    public $Via;
    /**
     * The DestinationRef
     * @var \StructType\DestinationRefStructure
     */
    public $DestinationRef;
    /**
     * The DestinationName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationName;
    /**
     * The DestinationShortName
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $DestinationShortName;
    /**
     * The OriginDisplayAtDestination
     * @var \StructType\NaturalLanguagePlaceNameStructure
     */
    public $OriginDisplayAtDestination;
    /**
     * The VehicleJourneyName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $VehicleJourneyName;
    /**
     * The JourneyNote
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $JourneyNote;
    /**
     * The PublicContact
     * @var \StructType\SimpleContactStructure
     */
    public $PublicContact;
    /**
     * The OperationsContact
     * @var \StructType\SimpleContactStructure
     */
    public $OperationsContact;
    /**
     * The HeadwayService
     * @var bool
     */
    public $HeadwayService;
    /**
     * The OriginAimedDepartureTime
     * @var string
     */
    public $OriginAimedDepartureTime;
    /**
     * The DestinationAimedArrivalTime
     * @var string
     */
    public $DestinationAimedArrivalTime;
    /**
     * The FirstOrLastJourney
     * @var string
     */
    public $FirstOrLastJourney;
    /**
     * The TargetedCall
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TargetedCall
     * @var \StructType\TargetedCallStructure
     */
    public $TargetedCall;
    /**
     * Constructor method for TargetedVehicleJourneyStructure
     * @uses TargetedVehicleJourneyStructure::setLineRef()
     * @uses TargetedVehicleJourneyStructure::setDirectionRef()
     * @uses TargetedVehicleJourneyStructure::setFramedVehicleJourneyRef()
     * @uses TargetedVehicleJourneyStructure::setJourneyPatternRef()
     * @uses TargetedVehicleJourneyStructure::setJourneyPatternName()
     * @uses TargetedVehicleJourneyStructure::setVehicleMode()
     * @uses TargetedVehicleJourneyStructure::setRouteRef()
     * @uses TargetedVehicleJourneyStructure::setPublishedLineName()
     * @uses TargetedVehicleJourneyStructure::setGroupOfLinesRef()
     * @uses TargetedVehicleJourneyStructure::setDirectionName()
     * @uses TargetedVehicleJourneyStructure::setExternalLineRef()
     * @uses TargetedVehicleJourneyStructure::setOperatorRef()
     * @uses TargetedVehicleJourneyStructure::setProductCategoryRef()
     * @uses TargetedVehicleJourneyStructure::setServiceFeatureRef()
     * @uses TargetedVehicleJourneyStructure::setVehicleFeatureRef()
     * @uses TargetedVehicleJourneyStructure::setOriginRef()
     * @uses TargetedVehicleJourneyStructure::setOriginName()
     * @uses TargetedVehicleJourneyStructure::setOriginShortName()
     * @uses TargetedVehicleJourneyStructure::setDestinationDisplayAtOrigin()
     * @uses TargetedVehicleJourneyStructure::setVia()
     * @uses TargetedVehicleJourneyStructure::setDestinationRef()
     * @uses TargetedVehicleJourneyStructure::setDestinationName()
     * @uses TargetedVehicleJourneyStructure::setDestinationShortName()
     * @uses TargetedVehicleJourneyStructure::setOriginDisplayAtDestination()
     * @uses TargetedVehicleJourneyStructure::setVehicleJourneyName()
     * @uses TargetedVehicleJourneyStructure::setJourneyNote()
     * @uses TargetedVehicleJourneyStructure::setPublicContact()
     * @uses TargetedVehicleJourneyStructure::setOperationsContact()
     * @uses TargetedVehicleJourneyStructure::setHeadwayService()
     * @uses TargetedVehicleJourneyStructure::setOriginAimedDepartureTime()
     * @uses TargetedVehicleJourneyStructure::setDestinationAimedArrivalTime()
     * @uses TargetedVehicleJourneyStructure::setFirstOrLastJourney()
     * @uses TargetedVehicleJourneyStructure::setTargetedCall()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @param string $vehicleMode
     * @param \StructType\RouteRefStructure $routeRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @param \StructType\LineRefStructure $externalLineRef
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @param \StructType\JourneyPlaceRefStructure $originRef
     * @param \StructType\NaturalLanguagePlaceNameStructure $originName
     * @param \StructType\NaturalLanguagePlaceNameStructure $originShortName
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin
     * @param \StructType\ViaNameStructure $via
     * @param \StructType\DestinationRefStructure $destinationRef
     * @param \StructType\NaturalLanguageStringStructure $destinationName
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationShortName
     * @param \StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination
     * @param \StructType\NaturalLanguageStringStructure $vehicleJourneyName
     * @param \StructType\NaturalLanguageStringStructure $journeyNote
     * @param \StructType\SimpleContactStructure $publicContact
     * @param \StructType\SimpleContactStructure $operationsContact
     * @param bool $headwayService
     * @param string $originAimedDepartureTime
     * @param string $destinationAimedArrivalTime
     * @param string $firstOrLastJourney
     * @param \StructType\TargetedCallStructure $targetedCall
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, \StructType\DirectionRefStructure $directionRef = null, \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\JourneyPatternRefStructure $journeyPatternRef = null, \StructType\NaturalLanguageStringStructure $journeyPatternName = null, $vehicleMode = null, \StructType\RouteRefStructure $routeRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\GroupOfLinesRefStructure $groupOfLinesRef = null, \StructType\NaturalLanguageStringStructure $directionName = null, \StructType\LineRefStructure $externalLineRef = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null, \StructType\JourneyPlaceRefStructure $originRef = null, \StructType\NaturalLanguagePlaceNameStructure $originName = null, \StructType\NaturalLanguagePlaceNameStructure $originShortName = null, \StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin = null, \StructType\ViaNameStructure $via = null, \StructType\DestinationRefStructure $destinationRef = null, \StructType\NaturalLanguageStringStructure $destinationName = null, \StructType\NaturalLanguagePlaceNameStructure $destinationShortName = null, \StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination = null, \StructType\NaturalLanguageStringStructure $vehicleJourneyName = null, \StructType\NaturalLanguageStringStructure $journeyNote = null, \StructType\SimpleContactStructure $publicContact = null, \StructType\SimpleContactStructure $operationsContact = null, $headwayService = null, $originAimedDepartureTime = null, $destinationAimedArrivalTime = null, $firstOrLastJourney = null, \StructType\TargetedCallStructure $targetedCall = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setDirectionRef($directionRef)
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setJourneyPatternRef($journeyPatternRef)
            ->setJourneyPatternName($journeyPatternName)
            ->setVehicleMode($vehicleMode)
            ->setRouteRef($routeRef)
            ->setPublishedLineName($publishedLineName)
            ->setGroupOfLinesRef($groupOfLinesRef)
            ->setDirectionName($directionName)
            ->setExternalLineRef($externalLineRef)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef)
            ->setOriginRef($originRef)
            ->setOriginName($originName)
            ->setOriginShortName($originShortName)
            ->setDestinationDisplayAtOrigin($destinationDisplayAtOrigin)
            ->setVia($via)
            ->setDestinationRef($destinationRef)
            ->setDestinationName($destinationName)
            ->setDestinationShortName($destinationShortName)
            ->setOriginDisplayAtDestination($originDisplayAtDestination)
            ->setVehicleJourneyName($vehicleJourneyName)
            ->setJourneyNote($journeyNote)
            ->setPublicContact($publicContact)
            ->setOperationsContact($operationsContact)
            ->setHeadwayService($headwayService)
            ->setOriginAimedDepartureTime($originAimedDepartureTime)
            ->setDestinationAimedArrivalTime($destinationAimedArrivalTime)
            ->setFirstOrLastJourney($firstOrLastJourney)
            ->setTargetedCall($targetedCall);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get JourneyPatternRef value
     * @return \StructType\JourneyPatternRefStructure|null
     */
    public function getJourneyPatternRef()
    {
        return $this->JourneyPatternRef;
    }
    /**
     * Set JourneyPatternRef value
     * @param \StructType\JourneyPatternRefStructure $journeyPatternRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setJourneyPatternRef(\StructType\JourneyPatternRefStructure $journeyPatternRef = null)
    {
        $this->JourneyPatternRef = $journeyPatternRef;
        return $this;
    }
    /**
     * Get JourneyPatternName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyPatternName()
    {
        return $this->JourneyPatternName;
    }
    /**
     * Set JourneyPatternName value
     * @param \StructType\NaturalLanguageStringStructure $journeyPatternName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setJourneyPatternName(\StructType\NaturalLanguageStringStructure $journeyPatternName = null)
    {
        $this->JourneyPatternName = $journeyPatternName;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get RouteRef value
     * @return \StructType\RouteRefStructure|null
     */
    public function getRouteRef()
    {
        return $this->RouteRef;
    }
    /**
     * Set RouteRef value
     * @param \StructType\RouteRefStructure $routeRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setRouteRef(\StructType\RouteRefStructure $routeRef = null)
    {
        $this->RouteRef = $routeRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get GroupOfLinesRef value
     * @return \StructType\GroupOfLinesRefStructure|null
     */
    public function getGroupOfLinesRef()
    {
        return $this->GroupOfLinesRef;
    }
    /**
     * Set GroupOfLinesRef value
     * @param \StructType\GroupOfLinesRefStructure $groupOfLinesRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setGroupOfLinesRef(\StructType\GroupOfLinesRefStructure $groupOfLinesRef = null)
    {
        $this->GroupOfLinesRef = $groupOfLinesRef;
        return $this;
    }
    /**
     * Get DirectionName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDirectionName()
    {
        return $this->DirectionName;
    }
    /**
     * Set DirectionName value
     * @param \StructType\NaturalLanguageStringStructure $directionName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDirectionName(\StructType\NaturalLanguageStringStructure $directionName = null)
    {
        $this->DirectionName = $directionName;
        return $this;
    }
    /**
     * Get ExternalLineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getExternalLineRef()
    {
        return $this->ExternalLineRef;
    }
    /**
     * Set ExternalLineRef value
     * @param \StructType\LineRefStructure $externalLineRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setExternalLineRef(\StructType\LineRefStructure $externalLineRef = null)
    {
        $this->ExternalLineRef = $externalLineRef;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Get OriginRef value
     * @return \StructType\JourneyPlaceRefStructure|null
     */
    public function getOriginRef()
    {
        return $this->OriginRef;
    }
    /**
     * Set OriginRef value
     * @param \StructType\JourneyPlaceRefStructure $originRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOriginRef(\StructType\JourneyPlaceRefStructure $originRef = null)
    {
        $this->OriginRef = $originRef;
        return $this;
    }
    /**
     * Get OriginName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getOriginName()
    {
        return $this->OriginName;
    }
    /**
     * Set OriginName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $originName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOriginName(\StructType\NaturalLanguagePlaceNameStructure $originName = null)
    {
        $this->OriginName = $originName;
        return $this;
    }
    /**
     * Get OriginShortName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getOriginShortName()
    {
        return $this->OriginShortName;
    }
    /**
     * Set OriginShortName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $originShortName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOriginShortName(\StructType\NaturalLanguagePlaceNameStructure $originShortName = null)
    {
        $this->OriginShortName = $originShortName;
        return $this;
    }
    /**
     * Get DestinationDisplayAtOrigin value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getDestinationDisplayAtOrigin()
    {
        return $this->DestinationDisplayAtOrigin;
    }
    /**
     * Set DestinationDisplayAtOrigin value
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDestinationDisplayAtOrigin(\StructType\NaturalLanguagePlaceNameStructure $destinationDisplayAtOrigin = null)
    {
        $this->DestinationDisplayAtOrigin = $destinationDisplayAtOrigin;
        return $this;
    }
    /**
     * Get Via value
     * @return \StructType\ViaNameStructure|null
     */
    public function getVia()
    {
        return $this->Via;
    }
    /**
     * Set Via value
     * @param \StructType\ViaNameStructure $via
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setVia(\StructType\ViaNameStructure $via = null)
    {
        $this->Via = $via;
        return $this;
    }
    /**
     * Get DestinationRef value
     * @return \StructType\DestinationRefStructure|null
     */
    public function getDestinationRef()
    {
        return $this->DestinationRef;
    }
    /**
     * Set DestinationRef value
     * @param \StructType\DestinationRefStructure $destinationRef
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDestinationRef(\StructType\DestinationRefStructure $destinationRef = null)
    {
        $this->DestinationRef = $destinationRef;
        return $this;
    }
    /**
     * Get DestinationName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationName()
    {
        return $this->DestinationName;
    }
    /**
     * Set DestinationName value
     * @param \StructType\NaturalLanguageStringStructure $destinationName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDestinationName(\StructType\NaturalLanguageStringStructure $destinationName = null)
    {
        $this->DestinationName = $destinationName;
        return $this;
    }
    /**
     * Get DestinationShortName value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getDestinationShortName()
    {
        return $this->DestinationShortName;
    }
    /**
     * Set DestinationShortName value
     * @param \StructType\NaturalLanguagePlaceNameStructure $destinationShortName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDestinationShortName(\StructType\NaturalLanguagePlaceNameStructure $destinationShortName = null)
    {
        $this->DestinationShortName = $destinationShortName;
        return $this;
    }
    /**
     * Get OriginDisplayAtDestination value
     * @return \StructType\NaturalLanguagePlaceNameStructure|null
     */
    public function getOriginDisplayAtDestination()
    {
        return $this->OriginDisplayAtDestination;
    }
    /**
     * Set OriginDisplayAtDestination value
     * @param \StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOriginDisplayAtDestination(\StructType\NaturalLanguagePlaceNameStructure $originDisplayAtDestination = null)
    {
        $this->OriginDisplayAtDestination = $originDisplayAtDestination;
        return $this;
    }
    /**
     * Get VehicleJourneyName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getVehicleJourneyName()
    {
        return $this->VehicleJourneyName;
    }
    /**
     * Set VehicleJourneyName value
     * @param \StructType\NaturalLanguageStringStructure $vehicleJourneyName
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setVehicleJourneyName(\StructType\NaturalLanguageStringStructure $vehicleJourneyName = null)
    {
        $this->VehicleJourneyName = $vehicleJourneyName;
        return $this;
    }
    /**
     * Get JourneyNote value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getJourneyNote()
    {
        return $this->JourneyNote;
    }
    /**
     * Set JourneyNote value
     * @param \StructType\NaturalLanguageStringStructure $journeyNote
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setJourneyNote(\StructType\NaturalLanguageStringStructure $journeyNote = null)
    {
        $this->JourneyNote = $journeyNote;
        return $this;
    }
    /**
     * Get PublicContact value
     * @return \StructType\SimpleContactStructure|null
     */
    public function getPublicContact()
    {
        return $this->PublicContact;
    }
    /**
     * Set PublicContact value
     * @param \StructType\SimpleContactStructure $publicContact
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setPublicContact(\StructType\SimpleContactStructure $publicContact = null)
    {
        $this->PublicContact = $publicContact;
        return $this;
    }
    /**
     * Get OperationsContact value
     * @return \StructType\SimpleContactStructure|null
     */
    public function getOperationsContact()
    {
        return $this->OperationsContact;
    }
    /**
     * Set OperationsContact value
     * @param \StructType\SimpleContactStructure $operationsContact
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOperationsContact(\StructType\SimpleContactStructure $operationsContact = null)
    {
        $this->OperationsContact = $operationsContact;
        return $this;
    }
    /**
     * Get HeadwayService value
     * @return bool|null
     */
    public function getHeadwayService()
    {
        return $this->HeadwayService;
    }
    /**
     * Set HeadwayService value
     * @param bool $headwayService
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setHeadwayService($headwayService = null)
    {
        // validation for constraint: boolean
        if (!is_null($headwayService) && !is_bool($headwayService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($headwayService)), __LINE__);
        }
        $this->HeadwayService = $headwayService;
        return $this;
    }
    /**
     * Get OriginAimedDepartureTime value
     * @return string|null
     */
    public function getOriginAimedDepartureTime()
    {
        return $this->OriginAimedDepartureTime;
    }
    /**
     * Set OriginAimedDepartureTime value
     * @param string $originAimedDepartureTime
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setOriginAimedDepartureTime($originAimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($originAimedDepartureTime) && !is_string($originAimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originAimedDepartureTime)), __LINE__);
        }
        $this->OriginAimedDepartureTime = $originAimedDepartureTime;
        return $this;
    }
    /**
     * Get DestinationAimedArrivalTime value
     * @return string|null
     */
    public function getDestinationAimedArrivalTime()
    {
        return $this->DestinationAimedArrivalTime;
    }
    /**
     * Set DestinationAimedArrivalTime value
     * @param string $destinationAimedArrivalTime
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setDestinationAimedArrivalTime($destinationAimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAimedArrivalTime) && !is_string($destinationAimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAimedArrivalTime)), __LINE__);
        }
        $this->DestinationAimedArrivalTime = $destinationAimedArrivalTime;
        return $this;
    }
    /**
     * Get FirstOrLastJourney value
     * @return string|null
     */
    public function getFirstOrLastJourney()
    {
        return $this->FirstOrLastJourney;
    }
    /**
     * Set FirstOrLastJourney value
     * @uses \EnumType\FirstOrLastJourneyEnumeration::valueIsValid()
     * @uses \EnumType\FirstOrLastJourneyEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstOrLastJourney
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setFirstOrLastJourney($firstOrLastJourney = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FirstOrLastJourneyEnumeration::valueIsValid($firstOrLastJourney)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firstOrLastJourney, implode(', ', \EnumType\FirstOrLastJourneyEnumeration::getValidValues())), __LINE__);
        }
        $this->FirstOrLastJourney = $firstOrLastJourney;
        return $this;
    }
    /**
     * Get TargetedCall value
     * @return \StructType\TargetedCallStructure|null
     */
    public function getTargetedCall()
    {
        return $this->TargetedCall;
    }
    /**
     * Set TargetedCall value
     * @param \StructType\TargetedCallStructure $targetedCall
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public function setTargetedCall(\StructType\TargetedCallStructure $targetedCall = null)
    {
        $this->TargetedCall = $targetedCall;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TargetedVehicleJourneyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
