<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TargetedCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a targeted call.
 * @subpackage Structs
 */
class TargetedCallStructure extends AbstractStructBase
{
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The TimingPoint
     * @var bool
     */
    public $TimingPoint;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The ProductCategoryRef
     * @var \StructType\ProductCategoryRefStructure
     */
    public $ProductCategoryRef;
    /**
     * The ServiceFeatureRef
     * @var \StructType\ServiceFeatureRefStructure
     */
    public $ServiceFeatureRef;
    /**
     * The VehicleFeatureRef
     * @var \StructType\VehicleFeatureRefStructure
     */
    public $VehicleFeatureRef;
    /**
     * The AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ArrivalPlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalPlatformName;
    /**
     * The ArrivalBoardingActivity
     * @var string
     */
    public $ArrivalBoardingActivity;
    /**
     * The ArrivalStopAssignment
     * @var \StructType\PlannedStopAssignmentStructure
     */
    public $ArrivalStopAssignment;
    /**
     * The ArrivalOperatorRefs
     * @var \StructType\OperatorRefStructure
     */
    public $ArrivalOperatorRefs;
    /**
     * The AimedDepartureTime
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The DeparturePlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DeparturePlatformName;
    /**
     * The DepartureBoardingActivity
     * @var string
     */
    public $DepartureBoardingActivity;
    /**
     * The DepartureStopAssignment
     * @var \StructType\PlannedStopAssignmentStructure
     */
    public $DepartureStopAssignment;
    /**
     * The DepartureOperatorRefs
     * @var \StructType\OperatorRefStructure
     */
    public $DepartureOperatorRefs;
    /**
     * The AimedLatestPassengerAccessTime
     * @var string
     */
    public $AimedLatestPassengerAccessTime;
    /**
     * The AimedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $AimedHeadwayInterval;
    /**
     * Constructor method for TargetedCallStructure
     * @uses TargetedCallStructure::setStopPointRef()
     * @uses TargetedCallStructure::setVisitNumber()
     * @uses TargetedCallStructure::setOrder()
     * @uses TargetedCallStructure::setTimingPoint()
     * @uses TargetedCallStructure::setOperatorRef()
     * @uses TargetedCallStructure::setProductCategoryRef()
     * @uses TargetedCallStructure::setServiceFeatureRef()
     * @uses TargetedCallStructure::setVehicleFeatureRef()
     * @uses TargetedCallStructure::setAimedArrivalTime()
     * @uses TargetedCallStructure::setArrivalPlatformName()
     * @uses TargetedCallStructure::setArrivalBoardingActivity()
     * @uses TargetedCallStructure::setArrivalStopAssignment()
     * @uses TargetedCallStructure::setArrivalOperatorRefs()
     * @uses TargetedCallStructure::setAimedDepartureTime()
     * @uses TargetedCallStructure::setDeparturePlatformName()
     * @uses TargetedCallStructure::setDepartureBoardingActivity()
     * @uses TargetedCallStructure::setDepartureStopAssignment()
     * @uses TargetedCallStructure::setDepartureOperatorRefs()
     * @uses TargetedCallStructure::setAimedLatestPassengerAccessTime()
     * @uses TargetedCallStructure::setAimedHeadwayInterval()
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $visitNumber
     * @param int $order
     * @param bool $timingPoint
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @param string $aimedArrivalTime
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @param string $arrivalBoardingActivity
     * @param \StructType\PlannedStopAssignmentStructure $arrivalStopAssignment
     * @param \StructType\OperatorRefStructure $arrivalOperatorRefs
     * @param string $aimedDepartureTime
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @param string $departureBoardingActivity
     * @param \StructType\PlannedStopAssignmentStructure $departureStopAssignment
     * @param \StructType\OperatorRefStructure $departureOperatorRefs
     * @param string $aimedLatestPassengerAccessTime
     * @param string $aimedHeadwayInterval
     */
    public function __construct(\StructType\StopPointRefStructure $stopPointRef = null, $visitNumber = null, $order = null, $timingPoint = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\ProductCategoryRefStructure $productCategoryRef = null, \StructType\ServiceFeatureRefStructure $serviceFeatureRef = null, \StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null, $aimedArrivalTime = null, \StructType\NaturalLanguageStringStructure $arrivalPlatformName = null, $arrivalBoardingActivity = null, \StructType\PlannedStopAssignmentStructure $arrivalStopAssignment = null, \StructType\OperatorRefStructure $arrivalOperatorRefs = null, $aimedDepartureTime = null, \StructType\NaturalLanguageStringStructure $departurePlatformName = null, $departureBoardingActivity = null, \StructType\PlannedStopAssignmentStructure $departureStopAssignment = null, \StructType\OperatorRefStructure $departureOperatorRefs = null, $aimedLatestPassengerAccessTime = null, $aimedHeadwayInterval = null)
    {
        $this
            ->setStopPointRef($stopPointRef)
            ->setVisitNumber($visitNumber)
            ->setOrder($order)
            ->setTimingPoint($timingPoint)
            ->setOperatorRef($operatorRef)
            ->setProductCategoryRef($productCategoryRef)
            ->setServiceFeatureRef($serviceFeatureRef)
            ->setVehicleFeatureRef($vehicleFeatureRef)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setArrivalPlatformName($arrivalPlatformName)
            ->setArrivalBoardingActivity($arrivalBoardingActivity)
            ->setArrivalStopAssignment($arrivalStopAssignment)
            ->setArrivalOperatorRefs($arrivalOperatorRefs)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setDeparturePlatformName($departurePlatformName)
            ->setDepartureBoardingActivity($departureBoardingActivity)
            ->setDepartureStopAssignment($departureStopAssignment)
            ->setDepartureOperatorRefs($departureOperatorRefs)
            ->setAimedLatestPassengerAccessTime($aimedLatestPassengerAccessTime)
            ->setAimedHeadwayInterval($aimedHeadwayInterval);
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\TargetedCallStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\TargetedCallStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\TargetedCallStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get TimingPoint value
     * @return bool|null
     */
    public function getTimingPoint()
    {
        return $this->TimingPoint;
    }
    /**
     * Set TimingPoint value
     * @param bool $timingPoint
     * @return \StructType\TargetedCallStructure
     */
    public function setTimingPoint($timingPoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($timingPoint) && !is_bool($timingPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($timingPoint)), __LINE__);
        }
        $this->TimingPoint = $timingPoint;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\TargetedCallStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get ProductCategoryRef value
     * @return \StructType\ProductCategoryRefStructure|null
     */
    public function getProductCategoryRef()
    {
        return $this->ProductCategoryRef;
    }
    /**
     * Set ProductCategoryRef value
     * @param \StructType\ProductCategoryRefStructure $productCategoryRef
     * @return \StructType\TargetedCallStructure
     */
    public function setProductCategoryRef(\StructType\ProductCategoryRefStructure $productCategoryRef = null)
    {
        $this->ProductCategoryRef = $productCategoryRef;
        return $this;
    }
    /**
     * Get ServiceFeatureRef value
     * @return \StructType\ServiceFeatureRefStructure|null
     */
    public function getServiceFeatureRef()
    {
        return $this->ServiceFeatureRef;
    }
    /**
     * Set ServiceFeatureRef value
     * @param \StructType\ServiceFeatureRefStructure $serviceFeatureRef
     * @return \StructType\TargetedCallStructure
     */
    public function setServiceFeatureRef(\StructType\ServiceFeatureRefStructure $serviceFeatureRef = null)
    {
        $this->ServiceFeatureRef = $serviceFeatureRef;
        return $this;
    }
    /**
     * Get VehicleFeatureRef value
     * @return \StructType\VehicleFeatureRefStructure|null
     */
    public function getVehicleFeatureRef()
    {
        return $this->VehicleFeatureRef;
    }
    /**
     * Set VehicleFeatureRef value
     * @param \StructType\VehicleFeatureRefStructure $vehicleFeatureRef
     * @return \StructType\TargetedCallStructure
     */
    public function setVehicleFeatureRef(\StructType\VehicleFeatureRefStructure $vehicleFeatureRef = null)
    {
        $this->VehicleFeatureRef = $vehicleFeatureRef;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\TargetedCallStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ArrivalPlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalPlatformName()
    {
        return $this->ArrivalPlatformName;
    }
    /**
     * Set ArrivalPlatformName value
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @return \StructType\TargetedCallStructure
     */
    public function setArrivalPlatformName(\StructType\NaturalLanguageStringStructure $arrivalPlatformName = null)
    {
        $this->ArrivalPlatformName = $arrivalPlatformName;
        return $this;
    }
    /**
     * Get ArrivalBoardingActivity value
     * @return string|null
     */
    public function getArrivalBoardingActivity()
    {
        return $this->ArrivalBoardingActivity;
    }
    /**
     * Set ArrivalBoardingActivity value
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalBoardingActivity
     * @return \StructType\TargetedCallStructure
     */
    public function setArrivalBoardingActivity($arrivalBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArrivalBoardingActivityEnumeration::valueIsValid($arrivalBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalBoardingActivity, implode(', ', \EnumType\ArrivalBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalBoardingActivity = $arrivalBoardingActivity;
        return $this;
    }
    /**
     * Get ArrivalStopAssignment value
     * @return \StructType\PlannedStopAssignmentStructure|null
     */
    public function getArrivalStopAssignment()
    {
        return $this->ArrivalStopAssignment;
    }
    /**
     * Set ArrivalStopAssignment value
     * @param \StructType\PlannedStopAssignmentStructure $arrivalStopAssignment
     * @return \StructType\TargetedCallStructure
     */
    public function setArrivalStopAssignment(\StructType\PlannedStopAssignmentStructure $arrivalStopAssignment = null)
    {
        $this->ArrivalStopAssignment = $arrivalStopAssignment;
        return $this;
    }
    /**
     * Get ArrivalOperatorRefs value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getArrivalOperatorRefs()
    {
        return $this->ArrivalOperatorRefs;
    }
    /**
     * Set ArrivalOperatorRefs value
     * @param \StructType\OperatorRefStructure $arrivalOperatorRefs
     * @return \StructType\TargetedCallStructure
     */
    public function setArrivalOperatorRefs(\StructType\OperatorRefStructure $arrivalOperatorRefs = null)
    {
        $this->ArrivalOperatorRefs = $arrivalOperatorRefs;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\TargetedCallStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get DeparturePlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDeparturePlatformName()
    {
        return $this->DeparturePlatformName;
    }
    /**
     * Set DeparturePlatformName value
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @return \StructType\TargetedCallStructure
     */
    public function setDeparturePlatformName(\StructType\NaturalLanguageStringStructure $departurePlatformName = null)
    {
        $this->DeparturePlatformName = $departurePlatformName;
        return $this;
    }
    /**
     * Get DepartureBoardingActivity value
     * @return string|null
     */
    public function getDepartureBoardingActivity()
    {
        return $this->DepartureBoardingActivity;
    }
    /**
     * Set DepartureBoardingActivity value
     * @uses \EnumType\DepartureBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\DepartureBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureBoardingActivity
     * @return \StructType\TargetedCallStructure
     */
    public function setDepartureBoardingActivity($departureBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepartureBoardingActivityEnumeration::valueIsValid($departureBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureBoardingActivity, implode(', ', \EnumType\DepartureBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureBoardingActivity = $departureBoardingActivity;
        return $this;
    }
    /**
     * Get DepartureStopAssignment value
     * @return \StructType\PlannedStopAssignmentStructure|null
     */
    public function getDepartureStopAssignment()
    {
        return $this->DepartureStopAssignment;
    }
    /**
     * Set DepartureStopAssignment value
     * @param \StructType\PlannedStopAssignmentStructure $departureStopAssignment
     * @return \StructType\TargetedCallStructure
     */
    public function setDepartureStopAssignment(\StructType\PlannedStopAssignmentStructure $departureStopAssignment = null)
    {
        $this->DepartureStopAssignment = $departureStopAssignment;
        return $this;
    }
    /**
     * Get DepartureOperatorRefs value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getDepartureOperatorRefs()
    {
        return $this->DepartureOperatorRefs;
    }
    /**
     * Set DepartureOperatorRefs value
     * @param \StructType\OperatorRefStructure $departureOperatorRefs
     * @return \StructType\TargetedCallStructure
     */
    public function setDepartureOperatorRefs(\StructType\OperatorRefStructure $departureOperatorRefs = null)
    {
        $this->DepartureOperatorRefs = $departureOperatorRefs;
        return $this;
    }
    /**
     * Get AimedLatestPassengerAccessTime value
     * @return string|null
     */
    public function getAimedLatestPassengerAccessTime()
    {
        return $this->AimedLatestPassengerAccessTime;
    }
    /**
     * Set AimedLatestPassengerAccessTime value
     * @param string $aimedLatestPassengerAccessTime
     * @return \StructType\TargetedCallStructure
     */
    public function setAimedLatestPassengerAccessTime($aimedLatestPassengerAccessTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedLatestPassengerAccessTime) && !is_string($aimedLatestPassengerAccessTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedLatestPassengerAccessTime)), __LINE__);
        }
        $this->AimedLatestPassengerAccessTime = $aimedLatestPassengerAccessTime;
        return $this;
    }
    /**
     * Get AimedHeadwayInterval value
     * @return string|null
     */
    public function getAimedHeadwayInterval()
    {
        return $this->AimedHeadwayInterval;
    }
    /**
     * Set AimedHeadwayInterval value
     * @param string $aimedHeadwayInterval
     * @return \StructType\TargetedCallStructure
     */
    public function setAimedHeadwayInterval($aimedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($aimedHeadwayInterval) && !is_string($aimedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedHeadwayInterval)), __LINE__);
        }
        $this->AimedHeadwayInterval = $aimedHeadwayInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TargetedCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
