<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionResponseBodyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Body of Subscription Response. Used in WSDL.
 * @subpackage Structs
 */
class SubscriptionResponseBodyStructure extends AbstractStructBase
{
    /**
     * The ResponseStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ResponseStatus
     * @var \StructType\StatusResponseStructure[]
     */
    public $ResponseStatus;
    /**
     * The SubscriptionManagerAddress
     * Meta informations extracted from the WSDL
     * - documentation: Endpoint address of subscription manager if different from that of the Producer or known default. | Type for a endpoint.
     * - minOccurs: 0
     * @var string
     */
    public $SubscriptionManagerAddress;
    /**
     * The ServiceStartedTime
     * Meta informations extracted from the WSDL
     * - documentation: Time at which service providing the subscription was last started. Can be used to detect restarts. If absent, unknown.
     * - minOccurs: 0
     * @var string
     */
    public $ServiceStartedTime;
    /**
     * Constructor method for SubscriptionResponseBodyStructure
     * @uses SubscriptionResponseBodyStructure::setResponseStatus()
     * @uses SubscriptionResponseBodyStructure::setSubscriptionManagerAddress()
     * @uses SubscriptionResponseBodyStructure::setServiceStartedTime()
     * @param \StructType\StatusResponseStructure[] $responseStatus
     * @param string $subscriptionManagerAddress
     * @param string $serviceStartedTime
     */
    public function __construct(array $responseStatus = array(), $subscriptionManagerAddress = null, $serviceStartedTime = null)
    {
        $this
            ->setResponseStatus($responseStatus)
            ->setSubscriptionManagerAddress($subscriptionManagerAddress)
            ->setServiceStartedTime($serviceStartedTime);
    }
    /**
     * Get ResponseStatus value
     * @return \StructType\StatusResponseStructure[]|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusResponseStructure[] $responseStatus
     * @return \StructType\SubscriptionResponseBodyStructure
     */
    public function setResponseStatus(array $responseStatus = array())
    {
        foreach ($responseStatus as $subscriptionResponseBodyStructureResponseStatusItem) {
            // validation for constraint: itemType
            if (!$subscriptionResponseBodyStructureResponseStatusItem instanceof \StructType\StatusResponseStructure) {
                throw new \InvalidArgumentException(sprintf('The ResponseStatus property can only contain items of \StructType\StatusResponseStructure, "%s" given', is_object($subscriptionResponseBodyStructureResponseStatusItem) ? get_class($subscriptionResponseBodyStructureResponseStatusItem) : gettype($subscriptionResponseBodyStructureResponseStatusItem)), __LINE__);
            }
        }
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Add item to ResponseStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusResponseStructure $item
     * @return \StructType\SubscriptionResponseBodyStructure
     */
    public function addToResponseStatus(\StructType\StatusResponseStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusResponseStructure) {
            throw new \InvalidArgumentException(sprintf('The ResponseStatus property can only contain items of \StructType\StatusResponseStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ResponseStatus[] = $item;
        return $this;
    }
    /**
     * Get SubscriptionManagerAddress value
     * @return string|null
     */
    public function getSubscriptionManagerAddress()
    {
        return $this->SubscriptionManagerAddress;
    }
    /**
     * Set SubscriptionManagerAddress value
     * @param string $subscriptionManagerAddress
     * @return \StructType\SubscriptionResponseBodyStructure
     */
    public function setSubscriptionManagerAddress($subscriptionManagerAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionManagerAddress) && !is_string($subscriptionManagerAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriptionManagerAddress)), __LINE__);
        }
        $this->SubscriptionManagerAddress = $subscriptionManagerAddress;
        return $this;
    }
    /**
     * Get ServiceStartedTime value
     * @return string|null
     */
    public function getServiceStartedTime()
    {
        return $this->ServiceStartedTime;
    }
    /**
     * Set ServiceStartedTime value
     * @param string $serviceStartedTime
     * @return \StructType\SubscriptionResponseBodyStructure
     */
    public function setServiceStartedTime($serviceStartedTime = null)
    {
        // validation for constraint: string
        if (!is_null($serviceStartedTime) && !is_string($serviceStartedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceStartedTime)), __LINE__);
        }
        $this->ServiceStartedTime = $serviceStartedTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionResponseBodyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
