<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subjects StructType
 * @subpackage Structs
 */
class Subjects extends AbstractStructBase
{
    /**
     * The subjectTypeOfWorks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subjectTypeOfWorks;
    /**
     * The numberOfSubjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfSubjects;
    /**
     * The subjectsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $subjectsExtension;
    /**
     * Constructor method for Subjects
     * @uses Subjects::setSubjectTypeOfWorks()
     * @uses Subjects::setNumberOfSubjects()
     * @uses Subjects::setSubjectsExtension()
     * @param string $subjectTypeOfWorks
     * @param int $numberOfSubjects
     * @param \StructType\ExtensionType $subjectsExtension
     */
    public function __construct($subjectTypeOfWorks = null, $numberOfSubjects = null, \StructType\ExtensionType $subjectsExtension = null)
    {
        $this
            ->setSubjectTypeOfWorks($subjectTypeOfWorks)
            ->setNumberOfSubjects($numberOfSubjects)
            ->setSubjectsExtension($subjectsExtension);
    }
    /**
     * Get subjectTypeOfWorks value
     * @return string
     */
    public function getSubjectTypeOfWorks()
    {
        return $this->subjectTypeOfWorks;
    }
    /**
     * Set subjectTypeOfWorks value
     * @uses \EnumType\SubjectTypeOfWorksEnum::valueIsValid()
     * @uses \EnumType\SubjectTypeOfWorksEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subjectTypeOfWorks
     * @return \StructType\Subjects
     */
    public function setSubjectTypeOfWorks($subjectTypeOfWorks = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubjectTypeOfWorksEnum::valueIsValid($subjectTypeOfWorks)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subjectTypeOfWorks, implode(', ', \EnumType\SubjectTypeOfWorksEnum::getValidValues())), __LINE__);
        }
        $this->subjectTypeOfWorks = $subjectTypeOfWorks;
        return $this;
    }
    /**
     * Get numberOfSubjects value
     * @return int|null
     */
    public function getNumberOfSubjects()
    {
        return $this->numberOfSubjects;
    }
    /**
     * Set numberOfSubjects value
     * @param int $numberOfSubjects
     * @return \StructType\Subjects
     */
    public function setNumberOfSubjects($numberOfSubjects = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSubjects) && !is_numeric($numberOfSubjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfSubjects)), __LINE__);
        }
        $this->numberOfSubjects = $numberOfSubjects;
        return $this;
    }
    /**
     * Get subjectsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSubjectsExtension()
    {
        return $this->subjectsExtension;
    }
    /**
     * Set subjectsExtension value
     * @param \StructType\ExtensionType $subjectsExtension
     * @return \StructType\Subjects
     */
    public function setSubjectsExtension(\StructType\ExtensionType $subjectsExtension = null)
    {
        $this->subjectsExtension = $subjectsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subjects
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
