<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopsInPattern StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ordered collection of STOP POINTs the LINE and direction . Detail level is 'stops'. +SIRI v2.0
 * @subpackage Structs
 */
class StopsInPattern extends AbstractStructBase
{
    /**
     * The StopPointInPattern
     * Meta informations extracted from the WSDL
     * - documentation: Stop within Route of LINE. Detail level is 'stop' +SIRI v2.0
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \StructType\StopPointInPatternStructure[]
     */
    public $StopPointInPattern;
    /**
     * Constructor method for StopsInPattern
     * @uses StopsInPattern::setStopPointInPattern()
     * @param \StructType\StopPointInPatternStructure[] $stopPointInPattern
     */
    public function __construct(array $stopPointInPattern = array())
    {
        $this
            ->setStopPointInPattern($stopPointInPattern);
    }
    /**
     * Get StopPointInPattern value
     * @return \StructType\StopPointInPatternStructure[]
     */
    public function getStopPointInPattern()
    {
        return $this->StopPointInPattern;
    }
    /**
     * Set StopPointInPattern value
     * @throws \InvalidArgumentException
     * @param \StructType\StopPointInPatternStructure[] $stopPointInPattern
     * @return \StructType\StopsInPattern
     */
    public function setStopPointInPattern(array $stopPointInPattern = array())
    {
        foreach ($stopPointInPattern as $stopsInPatternStopPointInPatternItem) {
            // validation for constraint: itemType
            if (!$stopsInPatternStopPointInPatternItem instanceof \StructType\StopPointInPatternStructure) {
                throw new \InvalidArgumentException(sprintf('The StopPointInPattern property can only contain items of \StructType\StopPointInPatternStructure, "%s" given', is_object($stopsInPatternStopPointInPatternItem) ? get_class($stopsInPatternStopPointInPatternItem) : gettype($stopsInPatternStopPointInPatternItem)), __LINE__);
            }
        }
        $this->StopPointInPattern = $stopPointInPattern;
        return $this;
    }
    /**
     * Add item to StopPointInPattern value
     * @throws \InvalidArgumentException
     * @param \StructType\StopPointInPatternStructure $item
     * @return \StructType\StopsInPattern
     */
    public function addToStopPointInPattern(\StructType\StopPointInPatternStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StopPointInPatternStructure) {
            throw new \InvalidArgumentException(sprintf('The StopPointInPattern property can only contain items of \StructType\StopPointInPatternStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopPointInPattern[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopsInPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
