<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoppingPositionChangedDepartureStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Change to a Distributor stop position.
 * @subpackage Structs
 */
class StoppingPositionChangedDepartureStructure extends AbstractDistributorItemStructure
{
    /**
     * The ChangeNote
     * Meta informations extracted from the WSDL
     * - documentation: Description of the revised stopping position of the Distributor (fetcher) in the connection zone. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguagePlaceNameStructure[]
     */
    public $ChangeNote;
    /**
     * The NewLocation
     * Meta informations extracted from the WSDL
     * - documentation: New location from which Distributor will leave.
     * - minOccurs: 0
     * @var \StructType\LocationStructure
     */
    public $NewLocation;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for StoppingPositionChangedDepartureStructure
     * @uses StoppingPositionChangedDepartureStructure::setChangeNote()
     * @uses StoppingPositionChangedDepartureStructure::setNewLocation()
     * @uses StoppingPositionChangedDepartureStructure::setExtensions()
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $changeNote
     * @param \StructType\LocationStructure $newLocation
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(array $changeNote = array(), \StructType\LocationStructure $newLocation = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setChangeNote($changeNote)
            ->setNewLocation($newLocation)
            ->setExtensions($extensions);
    }
    /**
     * Get ChangeNote value
     * @return \StructType\NaturalLanguagePlaceNameStructure[]|null
     */
    public function getChangeNote()
    {
        return $this->ChangeNote;
    }
    /**
     * Set ChangeNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure[] $changeNote
     * @return \StructType\StoppingPositionChangedDepartureStructure
     */
    public function setChangeNote(array $changeNote = array())
    {
        foreach ($changeNote as $stoppingPositionChangedDepartureStructureChangeNoteItem) {
            // validation for constraint: itemType
            if (!$stoppingPositionChangedDepartureStructureChangeNoteItem instanceof \StructType\NaturalLanguagePlaceNameStructure) {
                throw new \InvalidArgumentException(sprintf('The ChangeNote property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($stoppingPositionChangedDepartureStructureChangeNoteItem) ? get_class($stoppingPositionChangedDepartureStructureChangeNoteItem) : gettype($stoppingPositionChangedDepartureStructureChangeNoteItem)), __LINE__);
            }
        }
        $this->ChangeNote = $changeNote;
        return $this;
    }
    /**
     * Add item to ChangeNote value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguagePlaceNameStructure $item
     * @return \StructType\StoppingPositionChangedDepartureStructure
     */
    public function addToChangeNote(\StructType\NaturalLanguagePlaceNameStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguagePlaceNameStructure) {
            throw new \InvalidArgumentException(sprintf('The ChangeNote property can only contain items of \StructType\NaturalLanguagePlaceNameStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChangeNote[] = $item;
        return $this;
    }
    /**
     * Get NewLocation value
     * @return \StructType\LocationStructure|null
     */
    public function getNewLocation()
    {
        return $this->NewLocation;
    }
    /**
     * Set NewLocation value
     * @param \StructType\LocationStructure $newLocation
     * @return \StructType\StoppingPositionChangedDepartureStructure
     */
    public function setNewLocation(\StructType\LocationStructure $newLocation = null)
    {
        $this->NewLocation = $newLocation;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StoppingPositionChangedDepartureStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StoppingPositionChangedDepartureStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
