<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopNoticeCancellationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Cancellation of an earlier Stop Notice.
 * @subpackage Structs
 */
class StopNoticeCancellationStructure extends AbstractRequiredReferencingItemStructure
{
    /**
     * The MonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a stop monitoring point to which Notice applies.
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The StopPointRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The AppliesFromTime
     * Meta informations extracted from the WSDL
     * - documentation: In case of a delayed cancellation this time tells from when the cancellation applies.
     * - minOccurs: 0
     * @var string
     */
    public $AppliesFromTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for StopNoticeCancellationStructure
     * @uses StopNoticeCancellationStructure::setMonitoringRef()
     * @uses StopNoticeCancellationStructure::setStopPointRef()
     * @uses StopNoticeCancellationStructure::setAppliesFromTime()
     * @uses StopNoticeCancellationStructure::setExtensions()
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param string $appliesFromTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\MonitoringRefStructure $monitoringRef = null, \StructType\StopPointRefStructure $stopPointRef = null, $appliesFromTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setMonitoringRef($monitoringRef)
            ->setStopPointRef($stopPointRef)
            ->setAppliesFromTime($appliesFromTime)
            ->setExtensions($extensions);
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\StopNoticeCancellationStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\StopNoticeCancellationStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get AppliesFromTime value
     * @return string|null
     */
    public function getAppliesFromTime()
    {
        return $this->AppliesFromTime;
    }
    /**
     * Set AppliesFromTime value
     * @param string $appliesFromTime
     * @return \StructType\StopNoticeCancellationStructure
     */
    public function setAppliesFromTime($appliesFromTime = null)
    {
        // validation for constraint: string
        if (!is_null($appliesFromTime) && !is_string($appliesFromTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appliesFromTime)), __LINE__);
        }
        $this->AppliesFromTime = $appliesFromTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\StopNoticeCancellationStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopNoticeCancellationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
