<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StopMonitorPermissions StructType
 * Meta informations extracted from the WSDL
 * - documentation: The monitoring points that the participant may access. | The monitoring points that the participant may access.
 * @subpackage Structs
 */
class StopMonitorPermissions extends AbstractStructBase
{
    /**
     * The AllowAll
     * Meta informations extracted from the WSDL
     * - ref: AllowAll
     * @var bool
     */
    public $AllowAll;
    /**
     * The StopMonitorPermission
     * Meta informations extracted from the WSDL
     * - documentation: Participant's permission for this Monitoring Point (LOGICAL DISPLAY) | Participant's permission for this Monitoring Point (LOGICAL DISPLAY)
     * - maxOccurs: unbounded
     * @var \StructType\StopMonitorPermissionStructure[]
     */
    public $StopMonitorPermission;
    /**
     * Constructor method for StopMonitorPermissions
     * @uses StopMonitorPermissions::setAllowAll()
     * @uses StopMonitorPermissions::setStopMonitorPermission()
     * @param bool $allowAll
     * @param \StructType\StopMonitorPermissionStructure[] $stopMonitorPermission
     */
    public function __construct($allowAll = null, array $stopMonitorPermission = array())
    {
        $this
            ->setAllowAll($allowAll)
            ->setStopMonitorPermission($stopMonitorPermission);
    }
    /**
     * Get AllowAll value
     * @return bool|null
     */
    public function getAllowAll()
    {
        return $this->AllowAll;
    }
    /**
     * Set AllowAll value
     * @param bool $allowAll
     * @return \StructType\StopMonitorPermissions
     */
    public function setAllowAll($allowAll = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAll) && !is_bool($allowAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowAll)), __LINE__);
        }
        $this->AllowAll = $allowAll;
        return $this;
    }
    /**
     * Get StopMonitorPermission value
     * @return \StructType\StopMonitorPermissionStructure[]|null
     */
    public function getStopMonitorPermission()
    {
        return $this->StopMonitorPermission;
    }
    /**
     * Set StopMonitorPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\StopMonitorPermissionStructure[] $stopMonitorPermission
     * @return \StructType\StopMonitorPermissions
     */
    public function setStopMonitorPermission(array $stopMonitorPermission = array())
    {
        foreach ($stopMonitorPermission as $stopMonitorPermissionsStopMonitorPermissionItem) {
            // validation for constraint: itemType
            if (!$stopMonitorPermissionsStopMonitorPermissionItem instanceof \StructType\StopMonitorPermissionStructure) {
                throw new \InvalidArgumentException(sprintf('The StopMonitorPermission property can only contain items of \StructType\StopMonitorPermissionStructure, "%s" given', is_object($stopMonitorPermissionsStopMonitorPermissionItem) ? get_class($stopMonitorPermissionsStopMonitorPermissionItem) : gettype($stopMonitorPermissionsStopMonitorPermissionItem)), __LINE__);
            }
        }
        $this->StopMonitorPermission = $stopMonitorPermission;
        return $this;
    }
    /**
     * Add item to StopMonitorPermission value
     * @throws \InvalidArgumentException
     * @param \StructType\StopMonitorPermissionStructure $item
     * @return \StructType\StopMonitorPermissions
     */
    public function addToStopMonitorPermission(\StructType\StopMonitorPermissionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StopMonitorPermissionStructure) {
            throw new \InvalidArgumentException(sprintf('The StopMonitorPermission property can only contain items of \StructType\StopMonitorPermissionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StopMonitorPermission[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StopMonitorPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
