<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Response Status.
 * @subpackage Structs
 */
class StatusResponseStructure extends ResponseStructure
{
    /**
     * The RequestMessageRef
     * @var \StructType\MessageQualifierStructure
     */
    public $RequestMessageRef;
    /**
     * The SubscriberRef
     * @var \StructType\ParticipantRefStructure
     */
    public $SubscriberRef;
    /**
     * The SubscriptionFilterRef
     * @var \StructType\SubscriptionFilterRefStructure
     */
    public $SubscriptionFilterRef;
    /**
     * The SubscriptionRef
     * @var \StructType\SubscriptionQualifierStructure
     */
    public $SubscriptionRef;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Status
     * @var bool
     */
    public $Status;
    /**
     * The ErrorCondition
     * Meta informations extracted from the WSDL
     * - documentation: Description of any error or warning condition.
     * - minOccurs: 0
     * @var \StructType\ServiceDeliveryErrorConditionStructure
     */
    public $ErrorCondition;
    /**
     * The ValidUntil
     * @var string
     */
    public $ValidUntil;
    /**
     * The ShortestPossibleCycle
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ShortestPossibleCycle;
    /**
     * Constructor method for StatusResponseStructure
     * @uses StatusResponseStructure::setRequestMessageRef()
     * @uses StatusResponseStructure::setSubscriberRef()
     * @uses StatusResponseStructure::setSubscriptionFilterRef()
     * @uses StatusResponseStructure::setSubscriptionRef()
     * @uses StatusResponseStructure::setStatus()
     * @uses StatusResponseStructure::setErrorCondition()
     * @uses StatusResponseStructure::setValidUntil()
     * @uses StatusResponseStructure::setShortestPossibleCycle()
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @param \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @param bool $status
     * @param \StructType\ServiceDeliveryErrorConditionStructure $errorCondition
     * @param string $validUntil
     * @param string $shortestPossibleCycle
     */
    public function __construct(\StructType\MessageQualifierStructure $requestMessageRef = null, \StructType\ParticipantRefStructure $subscriberRef = null, \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef = null, \StructType\SubscriptionQualifierStructure $subscriptionRef = null, $status = null, \StructType\ServiceDeliveryErrorConditionStructure $errorCondition = null, $validUntil = null, $shortestPossibleCycle = null)
    {
        $this
            ->setRequestMessageRef($requestMessageRef)
            ->setSubscriberRef($subscriberRef)
            ->setSubscriptionFilterRef($subscriptionFilterRef)
            ->setSubscriptionRef($subscriptionRef)
            ->setStatus($status)
            ->setErrorCondition($errorCondition)
            ->setValidUntil($validUntil)
            ->setShortestPossibleCycle($shortestPossibleCycle);
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @return \StructType\StatusResponseStructure
     */
    public function setRequestMessageRef(\StructType\MessageQualifierStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Get SubscriberRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getSubscriberRef()
    {
        return $this->SubscriberRef;
    }
    /**
     * Set SubscriberRef value
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @return \StructType\StatusResponseStructure
     */
    public function setSubscriberRef(\StructType\ParticipantRefStructure $subscriberRef = null)
    {
        $this->SubscriberRef = $subscriberRef;
        return $this;
    }
    /**
     * Get SubscriptionFilterRef value
     * @return \StructType\SubscriptionFilterRefStructure|null
     */
    public function getSubscriptionFilterRef()
    {
        return $this->SubscriptionFilterRef;
    }
    /**
     * Set SubscriptionFilterRef value
     * @param \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef
     * @return \StructType\StatusResponseStructure
     */
    public function setSubscriptionFilterRef(\StructType\SubscriptionFilterRefStructure $subscriptionFilterRef = null)
    {
        $this->SubscriptionFilterRef = $subscriptionFilterRef;
        return $this;
    }
    /**
     * Get SubscriptionRef value
     * @return \StructType\SubscriptionQualifierStructure|null
     */
    public function getSubscriptionRef()
    {
        return $this->SubscriptionRef;
    }
    /**
     * Set SubscriptionRef value
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @return \StructType\StatusResponseStructure
     */
    public function setSubscriptionRef(\StructType\SubscriptionQualifierStructure $subscriptionRef = null)
    {
        $this->SubscriptionRef = $subscriptionRef;
        return $this;
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\StatusResponseStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ServiceDeliveryErrorConditionStructure|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ServiceDeliveryErrorConditionStructure $errorCondition
     * @return \StructType\StatusResponseStructure
     */
    public function setErrorCondition(\StructType\ServiceDeliveryErrorConditionStructure $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Get ValidUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->ValidUntil;
    }
    /**
     * Set ValidUntil value
     * @param string $validUntil
     * @return \StructType\StatusResponseStructure
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntil)), __LINE__);
        }
        $this->ValidUntil = $validUntil;
        return $this;
    }
    /**
     * Get ShortestPossibleCycle value
     * @return string|null
     */
    public function getShortestPossibleCycle()
    {
        return $this->ShortestPossibleCycle;
    }
    /**
     * Set ShortestPossibleCycle value
     * @param string $shortestPossibleCycle
     * @return \StructType\StatusResponseStructure
     */
    public function setShortestPossibleCycle($shortestPossibleCycle = null)
    {
        // validation for constraint: string
        if (!is_null($shortestPossibleCycle) && !is_string($shortestPossibleCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortestPossibleCycle)), __LINE__);
        }
        $this->ShortestPossibleCycle = $shortestPossibleCycle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
