<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpeedManagement StructType
 * @subpackage Structs
 */
class SpeedManagement extends NetworkManagement
{
    /**
     * The speedManagementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedManagementType;
    /**
     * The temporarySpeedLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $temporarySpeedLimit;
    /**
     * The speedManagementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $speedManagementExtension;
    /**
     * Constructor method for SpeedManagement
     * @uses SpeedManagement::setSpeedManagementType()
     * @uses SpeedManagement::setTemporarySpeedLimit()
     * @uses SpeedManagement::setSpeedManagementExtension()
     * @param string $speedManagementType
     * @param float $temporarySpeedLimit
     * @param \StructType\ExtensionType $speedManagementExtension
     */
    public function __construct($speedManagementType = null, $temporarySpeedLimit = null, \StructType\ExtensionType $speedManagementExtension = null)
    {
        $this
            ->setSpeedManagementType($speedManagementType)
            ->setTemporarySpeedLimit($temporarySpeedLimit)
            ->setSpeedManagementExtension($speedManagementExtension);
    }
    /**
     * Get speedManagementType value
     * @return string|null
     */
    public function getSpeedManagementType()
    {
        return $this->speedManagementType;
    }
    /**
     * Set speedManagementType value
     * @uses \EnumType\SpeedManagementTypeEnum::valueIsValid()
     * @uses \EnumType\SpeedManagementTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $speedManagementType
     * @return \StructType\SpeedManagement
     */
    public function setSpeedManagementType($speedManagementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SpeedManagementTypeEnum::valueIsValid($speedManagementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $speedManagementType, implode(', ', \EnumType\SpeedManagementTypeEnum::getValidValues())), __LINE__);
        }
        $this->speedManagementType = $speedManagementType;
        return $this;
    }
    /**
     * Get temporarySpeedLimit value
     * @return float|null
     */
    public function getTemporarySpeedLimit()
    {
        return $this->temporarySpeedLimit;
    }
    /**
     * Set temporarySpeedLimit value
     * @param float $temporarySpeedLimit
     * @return \StructType\SpeedManagement
     */
    public function setTemporarySpeedLimit($temporarySpeedLimit = null)
    {
        $this->temporarySpeedLimit = $temporarySpeedLimit;
        return $this;
    }
    /**
     * Get speedManagementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSpeedManagementExtension()
    {
        return $this->speedManagementExtension;
    }
    /**
     * Set speedManagementExtension value
     * @param \StructType\ExtensionType $speedManagementExtension
     * @return \StructType\SpeedManagement
     */
    public function setSpeedManagementExtension(\StructType\ExtensionType $speedManagementExtension = null)
    {
        $this->speedManagementExtension = $speedManagementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpeedManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
