<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationSourceStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a source, i.e. provider of information. | Further contact details about source. May be used for udpoates or verifcation.
 * @subpackage Structs
 */
class SituationSourceStructure extends AbstractStructBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - documentation: Country of origin of source element.
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The SourceType
     * Meta informations extracted from the WSDL
     * - documentation: Nature of Source.
     * @var string
     */
    public $SourceType;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Email address type.
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: International phonenumber +41675601 etc.
     * @var string
     */
    public $Phone;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - documentation: International phonenumber +41675601 etc.
     * @var string
     */
    public $Fax;
    /**
     * The Web
     * @var string
     */
    public $Web;
    /**
     * The Other
     * @var string
     */
    public $Other;
    /**
     * The SourceMethod
     * Meta informations extracted from the WSDL
     * - documentation: Nature of method used to get Source.
     * - minOccurs: 0
     * @var string
     */
    public $SourceMethod;
    /**
     * The AgentReference
     * Meta informations extracted from the WSDL
     * - documentation: Reference to an Agent, i.e. Capture client user who input a SITUATION. Available for use in intranet exchange of SITUATIONs.
     * - minOccurs: 0
     * @var string
     */
    public $AgentReference;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name of for source.
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $Name;
    /**
     * The SourceRole
     * Meta informations extracted from the WSDL
     * - documentation: Job title of Source.
     * - minOccurs: 0
     * @var string
     */
    public $SourceRole;
    /**
     * The TimeOfCommunication
     * Meta informations extracted from the WSDL
     * - documentation: Time of communication of message, if different from creation time.
     * - minOccurs: 0
     * @var string
     */
    public $TimeOfCommunication;
    /**
     * The ExternalCode
     * Meta informations extracted from the WSDL
     * - documentation: External system reference to SITUATION.
     * - minOccurs: 0
     * @var string
     */
    public $ExternalCode;
    /**
     * The SourceFile
     * Meta informations extracted from the WSDL
     * - documentation: Electronic file / attachment containing information about SITUATION.
     * - minOccurs: 0
     * @var string
     */
    public $SourceFile;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for SituationSourceStructure
     * @uses SituationSourceStructure::setCountry()
     * @uses SituationSourceStructure::setSourceType()
     * @uses SituationSourceStructure::setEmail()
     * @uses SituationSourceStructure::setPhone()
     * @uses SituationSourceStructure::setFax()
     * @uses SituationSourceStructure::setWeb()
     * @uses SituationSourceStructure::setOther()
     * @uses SituationSourceStructure::setSourceMethod()
     * @uses SituationSourceStructure::setAgentReference()
     * @uses SituationSourceStructure::setName()
     * @uses SituationSourceStructure::setSourceRole()
     * @uses SituationSourceStructure::setTimeOfCommunication()
     * @uses SituationSourceStructure::setExternalCode()
     * @uses SituationSourceStructure::setSourceFile()
     * @uses SituationSourceStructure::setExtensions()
     * @param string $country
     * @param string $sourceType
     * @param string $email
     * @param string $phone
     * @param string $fax
     * @param string $web
     * @param string $other
     * @param string $sourceMethod
     * @param string $agentReference
     * @param \StructType\NaturalLanguageStringStructure $name
     * @param string $sourceRole
     * @param string $timeOfCommunication
     * @param string $externalCode
     * @param string $sourceFile
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($country = null, $sourceType = null, $email = null, $phone = null, $fax = null, $web = null, $other = null, $sourceMethod = null, $agentReference = null, \StructType\NaturalLanguageStringStructure $name = null, $sourceRole = null, $timeOfCommunication = null, $externalCode = null, $sourceFile = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setCountry($country)
            ->setSourceType($sourceType)
            ->setEmail($email)
            ->setPhone($phone)
            ->setFax($fax)
            ->setWeb($web)
            ->setOther($other)
            ->setSourceMethod($sourceMethod)
            ->setAgentReference($agentReference)
            ->setName($name)
            ->setSourceRole($sourceRole)
            ->setTimeOfCommunication($timeOfCommunication)
            ->setExternalCode($externalCode)
            ->setSourceFile($sourceFile)
            ->setExtensions($extensions);
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\SituationSourceStructure
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get SourceType value
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->SourceType;
    }
    /**
     * Set SourceType value
     * @uses \EnumType\SituationSourceTypeEnumeration::valueIsValid()
     * @uses \EnumType\SituationSourceTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceType
     * @return \StructType\SituationSourceStructure
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SituationSourceTypeEnumeration::valueIsValid($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceType, implode(', ', \EnumType\SituationSourceTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->SourceType = $sourceType;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\SituationSourceStructure
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\SituationSourceStructure
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \StructType\SituationSourceStructure
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Web value
     * @return string|null
     */
    public function getWeb()
    {
        return $this->Web;
    }
    /**
     * Set Web value
     * @param string $web
     * @return \StructType\SituationSourceStructure
     */
    public function setWeb($web = null)
    {
        // validation for constraint: string
        if (!is_null($web) && !is_string($web)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($web)), __LINE__);
        }
        $this->Web = $web;
        return $this;
    }
    /**
     * Get Other value
     * @return string|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param string $other
     * @return \StructType\SituationSourceStructure
     */
    public function setOther($other = null)
    {
        // validation for constraint: string
        if (!is_null($other) && !is_string($other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other)), __LINE__);
        }
        $this->Other = $other;
        return $this;
    }
    /**
     * Get SourceMethod value
     * @return string|null
     */
    public function getSourceMethod()
    {
        return $this->SourceMethod;
    }
    /**
     * Set SourceMethod value
     * @uses \EnumType\SourceTypeEnum::valueIsValid()
     * @uses \EnumType\SourceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceMethod
     * @return \StructType\SituationSourceStructure
     */
    public function setSourceMethod($sourceMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SourceTypeEnum::valueIsValid($sourceMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceMethod, implode(', ', \EnumType\SourceTypeEnum::getValidValues())), __LINE__);
        }
        $this->SourceMethod = $sourceMethod;
        return $this;
    }
    /**
     * Get AgentReference value
     * @return string|null
     */
    public function getAgentReference()
    {
        return $this->AgentReference;
    }
    /**
     * Set AgentReference value
     * @param string $agentReference
     * @return \StructType\SituationSourceStructure
     */
    public function setAgentReference($agentReference = null)
    {
        // validation for constraint: string
        if (!is_null($agentReference) && !is_string($agentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentReference)), __LINE__);
        }
        $this->AgentReference = $agentReference;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\NaturalLanguageStringStructure $name
     * @return \StructType\SituationSourceStructure
     */
    public function setName(\StructType\NaturalLanguageStringStructure $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SourceRole value
     * @return string|null
     */
    public function getSourceRole()
    {
        return $this->SourceRole;
    }
    /**
     * Set SourceRole value
     * @param string $sourceRole
     * @return \StructType\SituationSourceStructure
     */
    public function setSourceRole($sourceRole = null)
    {
        // validation for constraint: string
        if (!is_null($sourceRole) && !is_string($sourceRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceRole)), __LINE__);
        }
        $this->SourceRole = $sourceRole;
        return $this;
    }
    /**
     * Get TimeOfCommunication value
     * @return string|null
     */
    public function getTimeOfCommunication()
    {
        return $this->TimeOfCommunication;
    }
    /**
     * Set TimeOfCommunication value
     * @param string $timeOfCommunication
     * @return \StructType\SituationSourceStructure
     */
    public function setTimeOfCommunication($timeOfCommunication = null)
    {
        // validation for constraint: string
        if (!is_null($timeOfCommunication) && !is_string($timeOfCommunication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeOfCommunication)), __LINE__);
        }
        $this->TimeOfCommunication = $timeOfCommunication;
        return $this;
    }
    /**
     * Get ExternalCode value
     * @return string|null
     */
    public function getExternalCode()
    {
        return $this->ExternalCode;
    }
    /**
     * Set ExternalCode value
     * @param string $externalCode
     * @return \StructType\SituationSourceStructure
     */
    public function setExternalCode($externalCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalCode) && !is_string($externalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalCode)), __LINE__);
        }
        $this->ExternalCode = $externalCode;
        return $this;
    }
    /**
     * Get SourceFile value
     * @return string|null
     */
    public function getSourceFile()
    {
        return $this->SourceFile;
    }
    /**
     * Set SourceFile value
     * @param string $sourceFile
     * @return \StructType\SituationSourceStructure
     */
    public function setSourceFile($sourceFile = null)
    {
        // validation for constraint: string
        if (!is_null($sourceFile) && !is_string($sourceFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceFile)), __LINE__);
        }
        $this->SourceFile = $sourceFile;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SituationSourceStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationSourceStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
