<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationExchangeSubscriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Subscription Request for Situation Exchange Service.
 * @subpackage Structs
 */
class SituationExchangeSubscriptionStructure extends AbstractSubscriptionStructure
{
    /**
     * The SituationExchangeRequest
     * Meta informations extracted from the WSDL
     * - ref: SituationExchangeRequest
     * @var \StructType\SituationExchangeRequestStructure
     */
    public $SituationExchangeRequest;
    /**
     * The IncrementalUpdates
     * @var bool
     */
    public $IncrementalUpdates;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for SituationExchangeSubscriptionStructure
     * @uses SituationExchangeSubscriptionStructure::setSituationExchangeRequest()
     * @uses SituationExchangeSubscriptionStructure::setIncrementalUpdates()
     * @uses SituationExchangeSubscriptionStructure::setExtensions()
     * @param \StructType\SituationExchangeRequestStructure $situationExchangeRequest
     * @param bool $incrementalUpdates
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\SituationExchangeRequestStructure $situationExchangeRequest = null, $incrementalUpdates = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setSituationExchangeRequest($situationExchangeRequest)
            ->setIncrementalUpdates($incrementalUpdates)
            ->setExtensions($extensions);
    }
    /**
     * Get SituationExchangeRequest value
     * @return \StructType\SituationExchangeRequestStructure|null
     */
    public function getSituationExchangeRequest()
    {
        return $this->SituationExchangeRequest;
    }
    /**
     * Set SituationExchangeRequest value
     * @param \StructType\SituationExchangeRequestStructure $situationExchangeRequest
     * @return \StructType\SituationExchangeSubscriptionStructure
     */
    public function setSituationExchangeRequest(\StructType\SituationExchangeRequestStructure $situationExchangeRequest = null)
    {
        $this->SituationExchangeRequest = $situationExchangeRequest;
        return $this;
    }
    /**
     * Get IncrementalUpdates value
     * @return bool|null
     */
    public function getIncrementalUpdates()
    {
        return $this->IncrementalUpdates;
    }
    /**
     * Set IncrementalUpdates value
     * @param bool $incrementalUpdates
     * @return \StructType\SituationExchangeSubscriptionStructure
     */
    public function setIncrementalUpdates($incrementalUpdates = null)
    {
        // validation for constraint: boolean
        if (!is_null($incrementalUpdates) && !is_bool($incrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($incrementalUpdates)), __LINE__);
        }
        $this->IncrementalUpdates = $incrementalUpdates;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SituationExchangeSubscriptionStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationExchangeSubscriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
