<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationExchangeRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Functional Service Request for Situation Exchange Service.
 * @subpackage Structs
 */
class SituationExchangeRequestStructure extends AbstractFunctionalServiceRequestStructure
{
    /**
     * The PreviewInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $PreviewInterval;
    /**
     * The StartTime
     * @var string
     */
    public $StartTime;
    /**
     * The ValidityPeriod
     * @var \StructType\HalfOpenTimestampInputRangeStructure
     */
    public $ValidityPeriod;
    /**
     * The IncludeOnlyIfInPublicationWindow
     * @var bool
     */
    public $IncludeOnlyIfInPublicationWindow;
    /**
     * The VehicleMode
     * @var string
     */
    public $VehicleMode;
    /**
     * The AirSubmode
     * @var string
     */
    public $AirSubmode;
    /**
     * The BusSubmode
     * @var string
     */
    public $BusSubmode;
    /**
     * The CoachSubmode
     * @var string
     */
    public $CoachSubmode;
    /**
     * The MetroSubmode
     * @var string
     */
    public $MetroSubmode;
    /**
     * The RailSubmode
     * @var string
     */
    public $RailSubmode;
    /**
     * The TramSubmode
     * @var string
     */
    public $TramSubmode;
    /**
     * The WaterSubmode
     * @var string
     */
    public $WaterSubmode;
    /**
     * The AccessMode
     * @var string
     */
    public $AccessMode;
    /**
     * The Severity
     * @var string
     */
    public $Severity;
    /**
     * The Scope
     * @var string
     */
    public $Scope;
    /**
     * The Predictability
     * @var string
     */
    public $Predictability;
    /**
     * The Keywords
     * @var string
     */
    public $Keywords;
    /**
     * The Verification
     * @var string
     */
    public $Verification;
    /**
     * The Progress
     * @var string
     */
    public $Progress;
    /**
     * The Reality
     * @var string
     */
    public $Reality;
    /**
     * The OperatorRef
     * @var \StructType\OperatorRefStructure
     */
    public $OperatorRef;
    /**
     * The OperationalUnitRef
     * @var \StructType\OperationalUnitRefStructure
     */
    public $OperationalUnitRef;
    /**
     * The NetworkRef
     * @var \StructType\OperatorRefStructure
     */
    public $NetworkRef;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The Lines
     * @var \StructType\Lines
     */
    public $Lines;
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The ConnectionLinkRef
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The FacilityRef
     * @var \StructType\FacilityRefStructure
     */
    public $FacilityRef;
    /**
     * The StopPlaceRef
     * @var \StructType\StopPlaceRefStructure
     */
    public $StopPlaceRef;
    /**
     * The StopPlaceComponentRef
     * @var \StructType\StopPlaceSpaceRefStructure
     */
    public $StopPlaceComponentRef;
    /**
     * The FramedVehicleJourneyRef
     * @var \StructType\FramedVehicleJourneyRefStructure
     */
    public $FramedVehicleJourneyRef;
    /**
     * The VehicleJourneyRef
     * @var \StructType\VehicleJourneyRefStructure
     */
    public $VehicleJourneyRef;
    /**
     * The InterchangeRef
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The VehicleRef
     * @var \StructType\VehicleRefStructure
     */
    public $VehicleRef;
    /**
     * The CountryRef
     * @var \StructType\CountryRefStructure
     */
    public $CountryRef;
    /**
     * The PlaceRef
     * @var string
     */
    public $PlaceRef;
    /**
     * The Location
     * @var \StructType\LocationStructure
     */
    public $Location;
    /**
     * The SituationRoadFilter
     * @var \StructType\SituationRoadFilter
     */
    public $SituationRoadFilter;
    /**
     * The AccessibilityNeedFilter
     * @var \StructType\PassengerAccessibilityNeedsStructure
     */
    public $AccessibilityNeedFilter;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The IncludeTranslations
     * @var bool
     */
    public $IncludeTranslations;
    /**
     * The MaximumNumberOfSituationElements
     * @var int
     */
    public $MaximumNumberOfSituationElements;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for SituationExchangeRequestStructure
     * @uses SituationExchangeRequestStructure::setPreviewInterval()
     * @uses SituationExchangeRequestStructure::setStartTime()
     * @uses SituationExchangeRequestStructure::setValidityPeriod()
     * @uses SituationExchangeRequestStructure::setIncludeOnlyIfInPublicationWindow()
     * @uses SituationExchangeRequestStructure::setVehicleMode()
     * @uses SituationExchangeRequestStructure::setAirSubmode()
     * @uses SituationExchangeRequestStructure::setBusSubmode()
     * @uses SituationExchangeRequestStructure::setCoachSubmode()
     * @uses SituationExchangeRequestStructure::setMetroSubmode()
     * @uses SituationExchangeRequestStructure::setRailSubmode()
     * @uses SituationExchangeRequestStructure::setTramSubmode()
     * @uses SituationExchangeRequestStructure::setWaterSubmode()
     * @uses SituationExchangeRequestStructure::setAccessMode()
     * @uses SituationExchangeRequestStructure::setSeverity()
     * @uses SituationExchangeRequestStructure::setScope()
     * @uses SituationExchangeRequestStructure::setPredictability()
     * @uses SituationExchangeRequestStructure::setKeywords()
     * @uses SituationExchangeRequestStructure::setVerification()
     * @uses SituationExchangeRequestStructure::setProgress()
     * @uses SituationExchangeRequestStructure::setReality()
     * @uses SituationExchangeRequestStructure::setOperatorRef()
     * @uses SituationExchangeRequestStructure::setOperationalUnitRef()
     * @uses SituationExchangeRequestStructure::setNetworkRef()
     * @uses SituationExchangeRequestStructure::setLineRef()
     * @uses SituationExchangeRequestStructure::setLines()
     * @uses SituationExchangeRequestStructure::setStopPointRef()
     * @uses SituationExchangeRequestStructure::setConnectionLinkRef()
     * @uses SituationExchangeRequestStructure::setFacilityRef()
     * @uses SituationExchangeRequestStructure::setStopPlaceRef()
     * @uses SituationExchangeRequestStructure::setStopPlaceComponentRef()
     * @uses SituationExchangeRequestStructure::setFramedVehicleJourneyRef()
     * @uses SituationExchangeRequestStructure::setVehicleJourneyRef()
     * @uses SituationExchangeRequestStructure::setInterchangeRef()
     * @uses SituationExchangeRequestStructure::setVehicleRef()
     * @uses SituationExchangeRequestStructure::setCountryRef()
     * @uses SituationExchangeRequestStructure::setPlaceRef()
     * @uses SituationExchangeRequestStructure::setLocation()
     * @uses SituationExchangeRequestStructure::setSituationRoadFilter()
     * @uses SituationExchangeRequestStructure::setAccessibilityNeedFilter()
     * @uses SituationExchangeRequestStructure::setLanguage()
     * @uses SituationExchangeRequestStructure::setIncludeTranslations()
     * @uses SituationExchangeRequestStructure::setMaximumNumberOfSituationElements()
     * @uses SituationExchangeRequestStructure::setExtensions()
     * @uses SituationExchangeRequestStructure::setVersion()
     * @param string $previewInterval
     * @param string $startTime
     * @param \StructType\HalfOpenTimestampInputRangeStructure $validityPeriod
     * @param bool $includeOnlyIfInPublicationWindow
     * @param string $vehicleMode
     * @param string $airSubmode
     * @param string $busSubmode
     * @param string $coachSubmode
     * @param string $metroSubmode
     * @param string $railSubmode
     * @param string $tramSubmode
     * @param string $waterSubmode
     * @param string $accessMode
     * @param string $severity
     * @param string $scope
     * @param string $predictability
     * @param string $keywords
     * @param string $verification
     * @param string $progress
     * @param string $reality
     * @param \StructType\OperatorRefStructure $operatorRef
     * @param \StructType\OperationalUnitRefStructure $operationalUnitRef
     * @param \StructType\OperatorRefStructure $networkRef
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\Lines $lines
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\FacilityRefStructure $facilityRef
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @param \StructType\StopPlaceSpaceRefStructure $stopPlaceComponentRef
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @param \StructType\CountryRefStructure $countryRef
     * @param string $placeRef
     * @param \StructType\LocationStructure $location
     * @param \StructType\SituationRoadFilter $situationRoadFilter
     * @param \StructType\PassengerAccessibilityNeedsStructure $accessibilityNeedFilter
     * @param string $language
     * @param bool $includeTranslations
     * @param int $maximumNumberOfSituationElements
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct($previewInterval = null, $startTime = null, \StructType\HalfOpenTimestampInputRangeStructure $validityPeriod = null, $includeOnlyIfInPublicationWindow = null, $vehicleMode = null, $airSubmode = null, $busSubmode = null, $coachSubmode = null, $metroSubmode = null, $railSubmode = null, $tramSubmode = null, $waterSubmode = null, $accessMode = null, $severity = null, $scope = null, $predictability = null, $keywords = null, $verification = null, $progress = null, $reality = null, \StructType\OperatorRefStructure $operatorRef = null, \StructType\OperationalUnitRefStructure $operationalUnitRef = null, \StructType\OperatorRefStructure $networkRef = null, \StructType\LineRefStructure $lineRef = null, \StructType\Lines $lines = null, \StructType\StopPointRefStructure $stopPointRef = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\FacilityRefStructure $facilityRef = null, \StructType\StopPlaceRefStructure $stopPlaceRef = null, \StructType\StopPlaceSpaceRefStructure $stopPlaceComponentRef = null, \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null, \StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null, \StructType\InterchangeRefStructure $interchangeRef = null, \StructType\VehicleRefStructure $vehicleRef = null, \StructType\CountryRefStructure $countryRef = null, $placeRef = null, \StructType\LocationStructure $location = null, \StructType\SituationRoadFilter $situationRoadFilter = null, \StructType\PassengerAccessibilityNeedsStructure $accessibilityNeedFilter = null, $language = null, $includeTranslations = null, $maximumNumberOfSituationElements = null, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setPreviewInterval($previewInterval)
            ->setStartTime($startTime)
            ->setValidityPeriod($validityPeriod)
            ->setIncludeOnlyIfInPublicationWindow($includeOnlyIfInPublicationWindow)
            ->setVehicleMode($vehicleMode)
            ->setAirSubmode($airSubmode)
            ->setBusSubmode($busSubmode)
            ->setCoachSubmode($coachSubmode)
            ->setMetroSubmode($metroSubmode)
            ->setRailSubmode($railSubmode)
            ->setTramSubmode($tramSubmode)
            ->setWaterSubmode($waterSubmode)
            ->setAccessMode($accessMode)
            ->setSeverity($severity)
            ->setScope($scope)
            ->setPredictability($predictability)
            ->setKeywords($keywords)
            ->setVerification($verification)
            ->setProgress($progress)
            ->setReality($reality)
            ->setOperatorRef($operatorRef)
            ->setOperationalUnitRef($operationalUnitRef)
            ->setNetworkRef($networkRef)
            ->setLineRef($lineRef)
            ->setLines($lines)
            ->setStopPointRef($stopPointRef)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setFacilityRef($facilityRef)
            ->setStopPlaceRef($stopPlaceRef)
            ->setStopPlaceComponentRef($stopPlaceComponentRef)
            ->setFramedVehicleJourneyRef($framedVehicleJourneyRef)
            ->setVehicleJourneyRef($vehicleJourneyRef)
            ->setInterchangeRef($interchangeRef)
            ->setVehicleRef($vehicleRef)
            ->setCountryRef($countryRef)
            ->setPlaceRef($placeRef)
            ->setLocation($location)
            ->setSituationRoadFilter($situationRoadFilter)
            ->setAccessibilityNeedFilter($accessibilityNeedFilter)
            ->setLanguage($language)
            ->setIncludeTranslations($includeTranslations)
            ->setMaximumNumberOfSituationElements($maximumNumberOfSituationElements)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get PreviewInterval value
     * @return string|null
     */
    public function getPreviewInterval()
    {
        return $this->PreviewInterval;
    }
    /**
     * Set PreviewInterval value
     * @param string $previewInterval
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setPreviewInterval($previewInterval = null)
    {
        // validation for constraint: string
        if (!is_null($previewInterval) && !is_string($previewInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previewInterval)), __LINE__);
        }
        $this->PreviewInterval = $previewInterval;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\HalfOpenTimestampInputRangeStructure|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\HalfOpenTimestampInputRangeStructure $validityPeriod
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setValidityPeriod(\StructType\HalfOpenTimestampInputRangeStructure $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get IncludeOnlyIfInPublicationWindow value
     * @return bool|null
     */
    public function getIncludeOnlyIfInPublicationWindow()
    {
        return $this->IncludeOnlyIfInPublicationWindow;
    }
    /**
     * Set IncludeOnlyIfInPublicationWindow value
     * @param bool $includeOnlyIfInPublicationWindow
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setIncludeOnlyIfInPublicationWindow($includeOnlyIfInPublicationWindow = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeOnlyIfInPublicationWindow) && !is_bool($includeOnlyIfInPublicationWindow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeOnlyIfInPublicationWindow)), __LINE__);
        }
        $this->IncludeOnlyIfInPublicationWindow = $includeOnlyIfInPublicationWindow;
        return $this;
    }
    /**
     * Get VehicleMode value
     * @return string|null
     */
    public function getVehicleMode()
    {
        return $this->VehicleMode;
    }
    /**
     * Set VehicleMode value
     * @uses \EnumType\VehicleModesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\VehicleModesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleMode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setVehicleMode($vehicleMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleModesOfTransportEnumeration::valueIsValid($vehicleMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleMode, implode(', ', \EnumType\VehicleModesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->VehicleMode = $vehicleMode;
        return $this;
    }
    /**
     * Get AirSubmode value
     * @return string|null
     */
    public function getAirSubmode()
    {
        return $this->AirSubmode;
    }
    /**
     * Set AirSubmode value
     * @uses \EnumType\AirSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\AirSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setAirSubmode($airSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirSubmodesOfTransportEnumeration::valueIsValid($airSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $airSubmode, implode(', ', \EnumType\AirSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->AirSubmode = $airSubmode;
        return $this;
    }
    /**
     * Get BusSubmode value
     * @return string|null
     */
    public function getBusSubmode()
    {
        return $this->BusSubmode;
    }
    /**
     * Set BusSubmode value
     * @uses \EnumType\BusSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\BusSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setBusSubmode($busSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusSubmodesOfTransportEnumeration::valueIsValid($busSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busSubmode, implode(', ', \EnumType\BusSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->BusSubmode = $busSubmode;
        return $this;
    }
    /**
     * Get CoachSubmode value
     * @return string|null
     */
    public function getCoachSubmode()
    {
        return $this->CoachSubmode;
    }
    /**
     * Set CoachSubmode value
     * @uses \EnumType\CoachSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\CoachSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $coachSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setCoachSubmode($coachSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CoachSubmodesOfTransportEnumeration::valueIsValid($coachSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $coachSubmode, implode(', ', \EnumType\CoachSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->CoachSubmode = $coachSubmode;
        return $this;
    }
    /**
     * Get MetroSubmode value
     * @return string|null
     */
    public function getMetroSubmode()
    {
        return $this->MetroSubmode;
    }
    /**
     * Set MetroSubmode value
     * @uses \EnumType\MetroSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\MetroSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $metroSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setMetroSubmode($metroSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MetroSubmodesOfTransportEnumeration::valueIsValid($metroSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $metroSubmode, implode(', ', \EnumType\MetroSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->MetroSubmode = $metroSubmode;
        return $this;
    }
    /**
     * Get RailSubmode value
     * @return string|null
     */
    public function getRailSubmode()
    {
        return $this->RailSubmode;
    }
    /**
     * Set RailSubmode value
     * @uses \EnumType\RailSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\RailSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $railSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setRailSubmode($railSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RailSubmodesOfTransportEnumeration::valueIsValid($railSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $railSubmode, implode(', ', \EnumType\RailSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->RailSubmode = $railSubmode;
        return $this;
    }
    /**
     * Get TramSubmode value
     * @return string|null
     */
    public function getTramSubmode()
    {
        return $this->TramSubmode;
    }
    /**
     * Set TramSubmode value
     * @uses \EnumType\TramSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\TramSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tramSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setTramSubmode($tramSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TramSubmodesOfTransportEnumeration::valueIsValid($tramSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tramSubmode, implode(', ', \EnumType\TramSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->TramSubmode = $tramSubmode;
        return $this;
    }
    /**
     * Get WaterSubmode value
     * @return string|null
     */
    public function getWaterSubmode()
    {
        return $this->WaterSubmode;
    }
    /**
     * Set WaterSubmode value
     * @uses \EnumType\WaterSubmodesOfTransportEnumeration::valueIsValid()
     * @uses \EnumType\WaterSubmodesOfTransportEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waterSubmode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setWaterSubmode($waterSubmode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WaterSubmodesOfTransportEnumeration::valueIsValid($waterSubmode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $waterSubmode, implode(', ', \EnumType\WaterSubmodesOfTransportEnumeration::getValidValues())), __LINE__);
        }
        $this->WaterSubmode = $waterSubmode;
        return $this;
    }
    /**
     * Get AccessMode value
     * @return string|null
     */
    public function getAccessMode()
    {
        return $this->AccessMode;
    }
    /**
     * Set AccessMode value
     * @uses \EnumType\AccessModesEnumeration::valueIsValid()
     * @uses \EnumType\AccessModesEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessMode
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setAccessMode($accessMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessModesEnumeration::valueIsValid($accessMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessMode, implode(', ', \EnumType\AccessModesEnumeration::getValidValues())), __LINE__);
        }
        $this->AccessMode = $accessMode;
        return $this;
    }
    /**
     * Get Severity value
     * @return string|null
     */
    public function getSeverity()
    {
        return $this->Severity;
    }
    /**
     * Set Severity value
     * @uses \EnumType\SeverityEnumeration::valueIsValid()
     * @uses \EnumType\SeverityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeverityEnumeration::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $severity, implode(', ', \EnumType\SeverityEnumeration::getValidValues())), __LINE__);
        }
        $this->Severity = $severity;
        return $this;
    }
    /**
     * Get Scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->Scope;
    }
    /**
     * Set Scope value
     * @uses \EnumType\ScopeTypeEnumeration::valueIsValid()
     * @uses \EnumType\ScopeTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scope
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setScope($scope = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ScopeTypeEnumeration::valueIsValid($scope)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scope, implode(', ', \EnumType\ScopeTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->Scope = $scope;
        return $this;
    }
    /**
     * Get Predictability value
     * @return string|null
     */
    public function getPredictability()
    {
        return $this->Predictability;
    }
    /**
     * Set Predictability value
     * @uses \EnumType\PredictabilityEnumeration::valueIsValid()
     * @uses \EnumType\PredictabilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $predictability
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setPredictability($predictability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PredictabilityEnumeration::valueIsValid($predictability)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $predictability, implode(', ', \EnumType\PredictabilityEnumeration::getValidValues())), __LINE__);
        }
        $this->Predictability = $predictability;
        return $this;
    }
    /**
     * Get Keywords value
     * @return string|null
     */
    public function getKeywords()
    {
        return $this->Keywords;
    }
    /**
     * Set Keywords value
     * @param string $keywords
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setKeywords($keywords = null)
    {
        // validation for constraint: string
        if (!is_null($keywords) && !is_string($keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keywords)), __LINE__);
        }
        $this->Keywords = $keywords;
        return $this;
    }
    /**
     * Get Verification value
     * @return string|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @uses \EnumType\VerificationStatusEnumeration::valueIsValid()
     * @uses \EnumType\VerificationStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $verification
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setVerification($verification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VerificationStatusEnumeration::valueIsValid($verification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $verification, implode(', ', \EnumType\VerificationStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Get Progress value
     * @return string|null
     */
    public function getProgress()
    {
        return $this->Progress;
    }
    /**
     * Set Progress value
     * @uses \EnumType\WorkflowStatusEnumeration::valueIsValid()
     * @uses \EnumType\WorkflowStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $progress
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setProgress($progress = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WorkflowStatusEnumeration::valueIsValid($progress)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $progress, implode(', ', \EnumType\WorkflowStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->Progress = $progress;
        return $this;
    }
    /**
     * Get Reality value
     * @return string|null
     */
    public function getReality()
    {
        return $this->Reality;
    }
    /**
     * Set Reality value
     * @uses \EnumType\InformationStatusEnum::valueIsValid()
     * @uses \EnumType\InformationStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reality
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setReality($reality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InformationStatusEnum::valueIsValid($reality)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reality, implode(', ', \EnumType\InformationStatusEnum::getValidValues())), __LINE__);
        }
        $this->Reality = $reality;
        return $this;
    }
    /**
     * Get OperatorRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getOperatorRef()
    {
        return $this->OperatorRef;
    }
    /**
     * Set OperatorRef value
     * @param \StructType\OperatorRefStructure $operatorRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setOperatorRef(\StructType\OperatorRefStructure $operatorRef = null)
    {
        $this->OperatorRef = $operatorRef;
        return $this;
    }
    /**
     * Get OperationalUnitRef value
     * @return \StructType\OperationalUnitRefStructure|null
     */
    public function getOperationalUnitRef()
    {
        return $this->OperationalUnitRef;
    }
    /**
     * Set OperationalUnitRef value
     * @param \StructType\OperationalUnitRefStructure $operationalUnitRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setOperationalUnitRef(\StructType\OperationalUnitRefStructure $operationalUnitRef = null)
    {
        $this->OperationalUnitRef = $operationalUnitRef;
        return $this;
    }
    /**
     * Get NetworkRef value
     * @return \StructType\OperatorRefStructure|null
     */
    public function getNetworkRef()
    {
        return $this->NetworkRef;
    }
    /**
     * Set NetworkRef value
     * @param \StructType\OperatorRefStructure $networkRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setNetworkRef(\StructType\OperatorRefStructure $networkRef = null)
    {
        $this->NetworkRef = $networkRef;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get Lines value
     * @return \StructType\Lines|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \StructType\Lines $lines
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setLines(\StructType\Lines $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get FacilityRef value
     * @return \StructType\FacilityRefStructure|null
     */
    public function getFacilityRef()
    {
        return $this->FacilityRef;
    }
    /**
     * Set FacilityRef value
     * @param \StructType\FacilityRefStructure $facilityRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setFacilityRef(\StructType\FacilityRefStructure $facilityRef = null)
    {
        $this->FacilityRef = $facilityRef;
        return $this;
    }
    /**
     * Get StopPlaceRef value
     * @return \StructType\StopPlaceRefStructure|null
     */
    public function getStopPlaceRef()
    {
        return $this->StopPlaceRef;
    }
    /**
     * Set StopPlaceRef value
     * @param \StructType\StopPlaceRefStructure $stopPlaceRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setStopPlaceRef(\StructType\StopPlaceRefStructure $stopPlaceRef = null)
    {
        $this->StopPlaceRef = $stopPlaceRef;
        return $this;
    }
    /**
     * Get StopPlaceComponentRef value
     * @return \StructType\StopPlaceSpaceRefStructure|null
     */
    public function getStopPlaceComponentRef()
    {
        return $this->StopPlaceComponentRef;
    }
    /**
     * Set StopPlaceComponentRef value
     * @param \StructType\StopPlaceSpaceRefStructure $stopPlaceComponentRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setStopPlaceComponentRef(\StructType\StopPlaceSpaceRefStructure $stopPlaceComponentRef = null)
    {
        $this->StopPlaceComponentRef = $stopPlaceComponentRef;
        return $this;
    }
    /**
     * Get FramedVehicleJourneyRef value
     * @return \StructType\FramedVehicleJourneyRefStructure|null
     */
    public function getFramedVehicleJourneyRef()
    {
        return $this->FramedVehicleJourneyRef;
    }
    /**
     * Set FramedVehicleJourneyRef value
     * @param \StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setFramedVehicleJourneyRef(\StructType\FramedVehicleJourneyRefStructure $framedVehicleJourneyRef = null)
    {
        $this->FramedVehicleJourneyRef = $framedVehicleJourneyRef;
        return $this;
    }
    /**
     * Get VehicleJourneyRef value
     * @return \StructType\VehicleJourneyRefStructure|null
     */
    public function getVehicleJourneyRef()
    {
        return $this->VehicleJourneyRef;
    }
    /**
     * Set VehicleJourneyRef value
     * @param \StructType\VehicleJourneyRefStructure $vehicleJourneyRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setVehicleJourneyRef(\StructType\VehicleJourneyRefStructure $vehicleJourneyRef = null)
    {
        $this->VehicleJourneyRef = $vehicleJourneyRef;
        return $this;
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get VehicleRef value
     * @return \StructType\VehicleRefStructure|null
     */
    public function getVehicleRef()
    {
        return $this->VehicleRef;
    }
    /**
     * Set VehicleRef value
     * @param \StructType\VehicleRefStructure $vehicleRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setVehicleRef(\StructType\VehicleRefStructure $vehicleRef = null)
    {
        $this->VehicleRef = $vehicleRef;
        return $this;
    }
    /**
     * Get CountryRef value
     * @return \StructType\CountryRefStructure|null
     */
    public function getCountryRef()
    {
        return $this->CountryRef;
    }
    /**
     * Set CountryRef value
     * @param \StructType\CountryRefStructure $countryRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setCountryRef(\StructType\CountryRefStructure $countryRef = null)
    {
        $this->CountryRef = $countryRef;
        return $this;
    }
    /**
     * Get PlaceRef value
     * @return string|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param string $placeRef
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setPlaceRef($placeRef = null)
    {
        // validation for constraint: string
        if (!is_null($placeRef) && !is_string($placeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeRef)), __LINE__);
        }
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\LocationStructure|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\LocationStructure $location
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setLocation(\StructType\LocationStructure $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get SituationRoadFilter value
     * @return \StructType\SituationRoadFilter|null
     */
    public function getSituationRoadFilter()
    {
        return $this->SituationRoadFilter;
    }
    /**
     * Set SituationRoadFilter value
     * @param \StructType\SituationRoadFilter $situationRoadFilter
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setSituationRoadFilter(\StructType\SituationRoadFilter $situationRoadFilter = null)
    {
        $this->SituationRoadFilter = $situationRoadFilter;
        return $this;
    }
    /**
     * Get AccessibilityNeedFilter value
     * @return \StructType\PassengerAccessibilityNeedsStructure|null
     */
    public function getAccessibilityNeedFilter()
    {
        return $this->AccessibilityNeedFilter;
    }
    /**
     * Set AccessibilityNeedFilter value
     * @param \StructType\PassengerAccessibilityNeedsStructure $accessibilityNeedFilter
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setAccessibilityNeedFilter(\StructType\PassengerAccessibilityNeedsStructure $accessibilityNeedFilter = null)
    {
        $this->AccessibilityNeedFilter = $accessibilityNeedFilter;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get IncludeTranslations value
     * @return bool|null
     */
    public function getIncludeTranslations()
    {
        return $this->IncludeTranslations;
    }
    /**
     * Set IncludeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeTranslations)), __LINE__);
        }
        $this->IncludeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get MaximumNumberOfSituationElements value
     * @return int|null
     */
    public function getMaximumNumberOfSituationElements()
    {
        return $this->MaximumNumberOfSituationElements;
    }
    /**
     * Set MaximumNumberOfSituationElements value
     * @param int $maximumNumberOfSituationElements
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setMaximumNumberOfSituationElements($maximumNumberOfSituationElements = null)
    {
        // validation for constraint: int
        if (!is_null($maximumNumberOfSituationElements) && !is_numeric($maximumNumberOfSituationElements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumNumberOfSituationElements)), __LINE__);
        }
        $this->MaximumNumberOfSituationElements = $maximumNumberOfSituationElements;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\SituationExchangeRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationExchangeRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
