<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SituationElementStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for loggable Entry.
 * @subpackage Structs
 */
class SituationElementStructure extends AbstractSituationElementStructure
{
    /**
     * The References
     * @var \StructType\ReferencesStructure
     */
    public $References;
    /**
     * The Source
     * @var \StructType\SituationSourceStructure
     */
    public $Source;
    /**
     * The VersionedAtTime
     * Meta informations extracted from the WSDL
     * - documentation: Time at which SITUATION element was versioned. Once versioned, no furtr changes can be made.
     * - minOccurs: 0
     * @var string
     */
    public $VersionedAtTime;
    /**
     * Constructor method for SituationElementStructure
     * @uses SituationElementStructure::setReferences()
     * @uses SituationElementStructure::setSource()
     * @uses SituationElementStructure::setVersionedAtTime()
     * @param \StructType\ReferencesStructure $references
     * @param \StructType\SituationSourceStructure $source
     * @param string $versionedAtTime
     */
    public function __construct(\StructType\ReferencesStructure $references = null, \StructType\SituationSourceStructure $source = null, $versionedAtTime = null)
    {
        $this
            ->setReferences($references)
            ->setSource($source)
            ->setVersionedAtTime($versionedAtTime);
    }
    /**
     * Get References value
     * @return \StructType\ReferencesStructure|null
     */
    public function getReferences()
    {
        return $this->References;
    }
    /**
     * Set References value
     * @param \StructType\ReferencesStructure $references
     * @return \StructType\SituationElementStructure
     */
    public function setReferences(\StructType\ReferencesStructure $references = null)
    {
        $this->References = $references;
        return $this;
    }
    /**
     * Get Source value
     * @return \StructType\SituationSourceStructure|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param \StructType\SituationSourceStructure $source
     * @return \StructType\SituationElementStructure
     */
    public function setSource(\StructType\SituationSourceStructure $source = null)
    {
        $this->Source = $source;
        return $this;
    }
    /**
     * Get VersionedAtTime value
     * @return string|null
     */
    public function getVersionedAtTime()
    {
        return $this->VersionedAtTime;
    }
    /**
     * Set VersionedAtTime value
     * @param string $versionedAtTime
     * @return \StructType\SituationElementStructure
     */
    public function setVersionedAtTime($versionedAtTime = null)
    {
        // validation for constraint: string
        if (!is_null($versionedAtTime) && !is_string($versionedAtTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionedAtTime)), __LINE__);
        }
        $this->VersionedAtTime = $versionedAtTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SituationElementStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
