<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Situation StructType
 * @subpackage Structs
 */
class Situation extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The overallSeverity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $overallSeverity;
    /**
     * The relatedSituation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string[]
     */
    public $relatedSituation;
    /**
     * The situationVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $situationVersion;
    /**
     * The situationVersionTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $situationVersionTime;
    /**
     * The headerInformation
     * @var \StructType\HeaderInformation
     */
    public $headerInformation;
    /**
     * The situationRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\SituationRecord[]
     */
    public $situationRecord;
    /**
     * The situationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $situationExtension;
    /**
     * Constructor method for Situation
     * @uses Situation::setId()
     * @uses Situation::setOverallSeverity()
     * @uses Situation::setRelatedSituation()
     * @uses Situation::setSituationVersion()
     * @uses Situation::setSituationVersionTime()
     * @uses Situation::setHeaderInformation()
     * @uses Situation::setSituationRecord()
     * @uses Situation::setSituationExtension()
     * @param string $id
     * @param string $overallSeverity
     * @param string[] $relatedSituation
     * @param int $situationVersion
     * @param string $situationVersionTime
     * @param \StructType\HeaderInformation $headerInformation
     * @param \StructType\SituationRecord[] $situationRecord
     * @param \StructType\ExtensionType $situationExtension
     */
    public function __construct($id = null, $overallSeverity = null, array $relatedSituation = array(), $situationVersion = null, $situationVersionTime = null, \StructType\HeaderInformation $headerInformation = null, array $situationRecord = array(), \StructType\ExtensionType $situationExtension = null)
    {
        $this
            ->setId($id)
            ->setOverallSeverity($overallSeverity)
            ->setRelatedSituation($relatedSituation)
            ->setSituationVersion($situationVersion)
            ->setSituationVersionTime($situationVersionTime)
            ->setHeaderInformation($headerInformation)
            ->setSituationRecord($situationRecord)
            ->setSituationExtension($situationExtension);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Situation
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get overallSeverity value
     * @return string|null
     */
    public function getOverallSeverity()
    {
        return $this->overallSeverity;
    }
    /**
     * Set overallSeverity value
     * @uses \EnumType\OverallSeverityEnum::valueIsValid()
     * @uses \EnumType\OverallSeverityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallSeverity
     * @return \StructType\Situation
     */
    public function setOverallSeverity($overallSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OverallSeverityEnum::valueIsValid($overallSeverity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $overallSeverity, implode(', ', \EnumType\OverallSeverityEnum::getValidValues())), __LINE__);
        }
        $this->overallSeverity = $overallSeverity;
        return $this;
    }
    /**
     * Get relatedSituation value
     * @return string[]|null
     */
    public function getRelatedSituation()
    {
        return $this->relatedSituation;
    }
    /**
     * Set relatedSituation value
     * @throws \InvalidArgumentException
     * @param string[] $relatedSituation
     * @return \StructType\Situation
     */
    public function setRelatedSituation(array $relatedSituation = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($relatedSituation) && strlen($relatedSituation) > 1024) || (is_array($relatedSituation) && count($relatedSituation) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($relatedSituation) ? strlen($relatedSituation) : count($relatedSituation)), __LINE__);
        }
        foreach ($relatedSituation as $situationRelatedSituationItem) {
            // validation for constraint: itemType
            if (!is_string($situationRelatedSituationItem)) {
                throw new \InvalidArgumentException(sprintf('The relatedSituation property can only contain items of string, "%s" given', is_object($situationRelatedSituationItem) ? get_class($situationRelatedSituationItem) : gettype($situationRelatedSituationItem)), __LINE__);
            }
        }
        $this->relatedSituation = $relatedSituation;
        return $this;
    }
    /**
     * Add item to relatedSituation value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Situation
     */
    public function addToRelatedSituation($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 1024) || (is_array($item) && count($item) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The relatedSituation property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedSituation[] = $item;
        return $this;
    }
    /**
     * Get situationVersion value
     * @return int|null
     */
    public function getSituationVersion()
    {
        return $this->situationVersion;
    }
    /**
     * Set situationVersion value
     * @param int $situationVersion
     * @return \StructType\Situation
     */
    public function setSituationVersion($situationVersion = null)
    {
        // validation for constraint: int
        if (!is_null($situationVersion) && !is_numeric($situationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($situationVersion)), __LINE__);
        }
        $this->situationVersion = $situationVersion;
        return $this;
    }
    /**
     * Get situationVersionTime value
     * @return string|null
     */
    public function getSituationVersionTime()
    {
        return $this->situationVersionTime;
    }
    /**
     * Set situationVersionTime value
     * @param string $situationVersionTime
     * @return \StructType\Situation
     */
    public function setSituationVersionTime($situationVersionTime = null)
    {
        // validation for constraint: string
        if (!is_null($situationVersionTime) && !is_string($situationVersionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($situationVersionTime)), __LINE__);
        }
        $this->situationVersionTime = $situationVersionTime;
        return $this;
    }
    /**
     * Get headerInformation value
     * @return \StructType\HeaderInformation|null
     */
    public function getHeaderInformation()
    {
        return $this->headerInformation;
    }
    /**
     * Set headerInformation value
     * @param \StructType\HeaderInformation $headerInformation
     * @return \StructType\Situation
     */
    public function setHeaderInformation(\StructType\HeaderInformation $headerInformation = null)
    {
        $this->headerInformation = $headerInformation;
        return $this;
    }
    /**
     * Get situationRecord value
     * @return \StructType\SituationRecord[]|null
     */
    public function getSituationRecord()
    {
        return $this->situationRecord;
    }
    /**
     * Set situationRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\SituationRecord[] $situationRecord
     * @return \StructType\Situation
     */
    public function setSituationRecord(array $situationRecord = array())
    {
        foreach ($situationRecord as $situationSituationRecordItem) {
            // validation for constraint: itemType
            if (!$situationSituationRecordItem instanceof \StructType\SituationRecord) {
                throw new \InvalidArgumentException(sprintf('The situationRecord property can only contain items of \StructType\SituationRecord, "%s" given', is_object($situationSituationRecordItem) ? get_class($situationSituationRecordItem) : gettype($situationSituationRecordItem)), __LINE__);
            }
        }
        $this->situationRecord = $situationRecord;
        return $this;
    }
    /**
     * Add item to situationRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\SituationRecord $item
     * @return \StructType\Situation
     */
    public function addToSituationRecord(\StructType\SituationRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SituationRecord) {
            throw new \InvalidArgumentException(sprintf('The situationRecord property can only contain items of \StructType\SituationRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->situationRecord[] = $item;
        return $this;
    }
    /**
     * Get situationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getSituationExtension()
    {
        return $this->situationExtension;
    }
    /**
     * Set situationExtension value
     * @param \StructType\ExtensionType $situationExtension
     * @return \StructType\Situation
     */
    public function setSituationExtension(\StructType\ExtensionType $situationExtension = null)
    {
        $this->situationExtension = $situationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Situation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
