<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleActionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for list of SITUATIONs.
 * @subpackage Structs
 */
class SimpleActionStructure extends AbstractStructBase
{
    /**
     * The ActionStatus
     * Meta informations extracted from the WSDL
     * - default: open
     * - documentation: Processing Status of action at time of SITUATION publication.
     * - minOccurs: 0
     * @var string
     */
    public $ActionStatus;
    /**
     * Constructor method for SimpleActionStructure
     * @uses SimpleActionStructure::setActionStatus()
     * @param string $actionStatus
     */
    public function __construct($actionStatus = 'open')
    {
        $this
            ->setActionStatus($actionStatus);
    }
    /**
     * Get ActionStatus value
     * @return string|null
     */
    public function getActionStatus()
    {
        return $this->ActionStatus;
    }
    /**
     * Set ActionStatus value
     * @uses \EnumType\ActionStatusEnumeration::valueIsValid()
     * @uses \EnumType\ActionStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionStatus
     * @return \StructType\SimpleActionStructure
     */
    public function setActionStatus($actionStatus = 'open')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionStatusEnumeration::valueIsValid($actionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $actionStatus, implode(', ', \EnumType\ActionStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->ActionStatus = $actionStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimpleActionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
