<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: SIRI Service Request.
 * @subpackage Structs
 */
class ServiceRequestStructure extends ContextualisedRequestStructure
{
    /**
     * The ProductionTimetableRequest
     * @var \StructType\ProductionTimetableRequestStructure
     */
    public $ProductionTimetableRequest;
    /**
     * The EstimatedTimetableRequest
     * @var \StructType\EstimatedTimetableRequestStructure
     */
    public $EstimatedTimetableRequest;
    /**
     * The StopTimetableRequest
     * @var \StructType\StopTimetableRequestStructure
     */
    public $StopTimetableRequest;
    /**
     * The StopMonitoringMultipleRequest
     * @var \StructType\StopMonitoringMultipleRequestStructure
     */
    public $StopMonitoringMultipleRequest;
    /**
     * The StopMonitoringRequest
     * @var \StructType\StopMonitoringRequestStructure
     */
    public $StopMonitoringRequest;
    /**
     * The VehicleMonitoringRequest
     * @var \StructType\VehicleMonitoringRequestStructure
     */
    public $VehicleMonitoringRequest;
    /**
     * The ConnectionTimetableRequest
     * @var \StructType\ConnectionTimetableRequestStructure
     */
    public $ConnectionTimetableRequest;
    /**
     * The ConnectionMonitoringRequest
     * @var \StructType\ConnectionMonitoringRequestStructure
     */
    public $ConnectionMonitoringRequest;
    /**
     * The GeneralMessageRequest
     * @var \StructType\GeneralMessageRequestStructure
     */
    public $GeneralMessageRequest;
    /**
     * The FacilityMonitoringRequest
     * @var \StructType\FacilityMonitoringRequestStructure
     */
    public $FacilityMonitoringRequest;
    /**
     * The SituationExchangeRequest
     * @var \StructType\SituationExchangeRequestStructure
     */
    public $SituationExchangeRequest;
    /**
     * Constructor method for ServiceRequestStructure
     * @uses ServiceRequestStructure::setProductionTimetableRequest()
     * @uses ServiceRequestStructure::setEstimatedTimetableRequest()
     * @uses ServiceRequestStructure::setStopTimetableRequest()
     * @uses ServiceRequestStructure::setStopMonitoringMultipleRequest()
     * @uses ServiceRequestStructure::setStopMonitoringRequest()
     * @uses ServiceRequestStructure::setVehicleMonitoringRequest()
     * @uses ServiceRequestStructure::setConnectionTimetableRequest()
     * @uses ServiceRequestStructure::setConnectionMonitoringRequest()
     * @uses ServiceRequestStructure::setGeneralMessageRequest()
     * @uses ServiceRequestStructure::setFacilityMonitoringRequest()
     * @uses ServiceRequestStructure::setSituationExchangeRequest()
     * @param \StructType\ProductionTimetableRequestStructure $productionTimetableRequest
     * @param \StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest
     * @param \StructType\StopTimetableRequestStructure $stopTimetableRequest
     * @param \StructType\StopMonitoringMultipleRequestStructure $stopMonitoringMultipleRequest
     * @param \StructType\StopMonitoringRequestStructure $stopMonitoringRequest
     * @param \StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest
     * @param \StructType\ConnectionTimetableRequestStructure $connectionTimetableRequest
     * @param \StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest
     * @param \StructType\GeneralMessageRequestStructure $generalMessageRequest
     * @param \StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest
     * @param \StructType\SituationExchangeRequestStructure $situationExchangeRequest
     */
    public function __construct(\StructType\ProductionTimetableRequestStructure $productionTimetableRequest = null, \StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest = null, \StructType\StopTimetableRequestStructure $stopTimetableRequest = null, \StructType\StopMonitoringMultipleRequestStructure $stopMonitoringMultipleRequest = null, \StructType\StopMonitoringRequestStructure $stopMonitoringRequest = null, \StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest = null, \StructType\ConnectionTimetableRequestStructure $connectionTimetableRequest = null, \StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest = null, \StructType\GeneralMessageRequestStructure $generalMessageRequest = null, \StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest = null, \StructType\SituationExchangeRequestStructure $situationExchangeRequest = null)
    {
        $this
            ->setProductionTimetableRequest($productionTimetableRequest)
            ->setEstimatedTimetableRequest($estimatedTimetableRequest)
            ->setStopTimetableRequest($stopTimetableRequest)
            ->setStopMonitoringMultipleRequest($stopMonitoringMultipleRequest)
            ->setStopMonitoringRequest($stopMonitoringRequest)
            ->setVehicleMonitoringRequest($vehicleMonitoringRequest)
            ->setConnectionTimetableRequest($connectionTimetableRequest)
            ->setConnectionMonitoringRequest($connectionMonitoringRequest)
            ->setGeneralMessageRequest($generalMessageRequest)
            ->setFacilityMonitoringRequest($facilityMonitoringRequest)
            ->setSituationExchangeRequest($situationExchangeRequest);
    }
    /**
     * Get ProductionTimetableRequest value
     * @return \StructType\ProductionTimetableRequestStructure|null
     */
    public function getProductionTimetableRequest()
    {
        return $this->ProductionTimetableRequest;
    }
    /**
     * Set ProductionTimetableRequest value
     * @param \StructType\ProductionTimetableRequestStructure $productionTimetableRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setProductionTimetableRequest(\StructType\ProductionTimetableRequestStructure $productionTimetableRequest = null)
    {
        $this->ProductionTimetableRequest = $productionTimetableRequest;
        return $this;
    }
    /**
     * Get EstimatedTimetableRequest value
     * @return \StructType\EstimatedTimetableRequestStructure|null
     */
    public function getEstimatedTimetableRequest()
    {
        return $this->EstimatedTimetableRequest;
    }
    /**
     * Set EstimatedTimetableRequest value
     * @param \StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setEstimatedTimetableRequest(\StructType\EstimatedTimetableRequestStructure $estimatedTimetableRequest = null)
    {
        $this->EstimatedTimetableRequest = $estimatedTimetableRequest;
        return $this;
    }
    /**
     * Get StopTimetableRequest value
     * @return \StructType\StopTimetableRequestStructure|null
     */
    public function getStopTimetableRequest()
    {
        return $this->StopTimetableRequest;
    }
    /**
     * Set StopTimetableRequest value
     * @param \StructType\StopTimetableRequestStructure $stopTimetableRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setStopTimetableRequest(\StructType\StopTimetableRequestStructure $stopTimetableRequest = null)
    {
        $this->StopTimetableRequest = $stopTimetableRequest;
        return $this;
    }
    /**
     * Get StopMonitoringMultipleRequest value
     * @return \StructType\StopMonitoringMultipleRequestStructure|null
     */
    public function getStopMonitoringMultipleRequest()
    {
        return $this->StopMonitoringMultipleRequest;
    }
    /**
     * Set StopMonitoringMultipleRequest value
     * @param \StructType\StopMonitoringMultipleRequestStructure $stopMonitoringMultipleRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setStopMonitoringMultipleRequest(\StructType\StopMonitoringMultipleRequestStructure $stopMonitoringMultipleRequest = null)
    {
        $this->StopMonitoringMultipleRequest = $stopMonitoringMultipleRequest;
        return $this;
    }
    /**
     * Get StopMonitoringRequest value
     * @return \StructType\StopMonitoringRequestStructure|null
     */
    public function getStopMonitoringRequest()
    {
        return $this->StopMonitoringRequest;
    }
    /**
     * Set StopMonitoringRequest value
     * @param \StructType\StopMonitoringRequestStructure $stopMonitoringRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setStopMonitoringRequest(\StructType\StopMonitoringRequestStructure $stopMonitoringRequest = null)
    {
        $this->StopMonitoringRequest = $stopMonitoringRequest;
        return $this;
    }
    /**
     * Get VehicleMonitoringRequest value
     * @return \StructType\VehicleMonitoringRequestStructure|null
     */
    public function getVehicleMonitoringRequest()
    {
        return $this->VehicleMonitoringRequest;
    }
    /**
     * Set VehicleMonitoringRequest value
     * @param \StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setVehicleMonitoringRequest(\StructType\VehicleMonitoringRequestStructure $vehicleMonitoringRequest = null)
    {
        $this->VehicleMonitoringRequest = $vehicleMonitoringRequest;
        return $this;
    }
    /**
     * Get ConnectionTimetableRequest value
     * @return \StructType\ConnectionTimetableRequestStructure|null
     */
    public function getConnectionTimetableRequest()
    {
        return $this->ConnectionTimetableRequest;
    }
    /**
     * Set ConnectionTimetableRequest value
     * @param \StructType\ConnectionTimetableRequestStructure $connectionTimetableRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setConnectionTimetableRequest(\StructType\ConnectionTimetableRequestStructure $connectionTimetableRequest = null)
    {
        $this->ConnectionTimetableRequest = $connectionTimetableRequest;
        return $this;
    }
    /**
     * Get ConnectionMonitoringRequest value
     * @return \StructType\ConnectionMonitoringRequestStructure|null
     */
    public function getConnectionMonitoringRequest()
    {
        return $this->ConnectionMonitoringRequest;
    }
    /**
     * Set ConnectionMonitoringRequest value
     * @param \StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setConnectionMonitoringRequest(\StructType\ConnectionMonitoringRequestStructure $connectionMonitoringRequest = null)
    {
        $this->ConnectionMonitoringRequest = $connectionMonitoringRequest;
        return $this;
    }
    /**
     * Get GeneralMessageRequest value
     * @return \StructType\GeneralMessageRequestStructure|null
     */
    public function getGeneralMessageRequest()
    {
        return $this->GeneralMessageRequest;
    }
    /**
     * Set GeneralMessageRequest value
     * @param \StructType\GeneralMessageRequestStructure $generalMessageRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setGeneralMessageRequest(\StructType\GeneralMessageRequestStructure $generalMessageRequest = null)
    {
        $this->GeneralMessageRequest = $generalMessageRequest;
        return $this;
    }
    /**
     * Get FacilityMonitoringRequest value
     * @return \StructType\FacilityMonitoringRequestStructure|null
     */
    public function getFacilityMonitoringRequest()
    {
        return $this->FacilityMonitoringRequest;
    }
    /**
     * Set FacilityMonitoringRequest value
     * @param \StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setFacilityMonitoringRequest(\StructType\FacilityMonitoringRequestStructure $facilityMonitoringRequest = null)
    {
        $this->FacilityMonitoringRequest = $facilityMonitoringRequest;
        return $this;
    }
    /**
     * Get SituationExchangeRequest value
     * @return \StructType\SituationExchangeRequestStructure|null
     */
    public function getSituationExchangeRequest()
    {
        return $this->SituationExchangeRequest;
    }
    /**
     * Set SituationExchangeRequest value
     * @param \StructType\SituationExchangeRequestStructure $situationExchangeRequest
     * @return \StructType\ServiceRequestStructure
     */
    public function setSituationExchangeRequest(\StructType\SituationExchangeRequestStructure $situationExchangeRequest = null)
    {
        $this->SituationExchangeRequest = $situationExchangeRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
