<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeaturesDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Response with SERVICE FEATUREs available to make requests.
 * @subpackage Structs
 */
class ServiceFeaturesDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The ServiceFeature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ServiceFeature
     * @var \StructType\ServiceFeatureStructure[]
     */
    public $ServiceFeature;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ServiceFeaturesDeliveryStructure
     * @uses ServiceFeaturesDeliveryStructure::setServiceFeature()
     * @uses ServiceFeaturesDeliveryStructure::setVersion()
     * @param \StructType\ServiceFeatureStructure[] $serviceFeature
     * @param string $version
     */
    public function __construct(array $serviceFeature = array(), $version = '2.0')
    {
        $this
            ->setServiceFeature($serviceFeature)
            ->setVersion($version);
    }
    /**
     * Get ServiceFeature value
     * @return \StructType\ServiceFeatureStructure[]|null
     */
    public function getServiceFeature()
    {
        return $this->ServiceFeature;
    }
    /**
     * Set ServiceFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureStructure[] $serviceFeature
     * @return \StructType\ServiceFeaturesDeliveryStructure
     */
    public function setServiceFeature(array $serviceFeature = array())
    {
        foreach ($serviceFeature as $serviceFeaturesDeliveryStructureServiceFeatureItem) {
            // validation for constraint: itemType
            if (!$serviceFeaturesDeliveryStructureServiceFeatureItem instanceof \StructType\ServiceFeatureStructure) {
                throw new \InvalidArgumentException(sprintf('The ServiceFeature property can only contain items of \StructType\ServiceFeatureStructure, "%s" given', is_object($serviceFeaturesDeliveryStructureServiceFeatureItem) ? get_class($serviceFeaturesDeliveryStructureServiceFeatureItem) : gettype($serviceFeaturesDeliveryStructureServiceFeatureItem)), __LINE__);
            }
        }
        $this->ServiceFeature = $serviceFeature;
        return $this;
    }
    /**
     * Add item to ServiceFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureStructure $item
     * @return \StructType\ServiceFeaturesDeliveryStructure
     */
    public function addToServiceFeature(\StructType\ServiceFeatureStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureStructure) {
            throw new \InvalidArgumentException(sprintf('The ServiceFeature property can only contain items of \StructType\ServiceFeatureStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceFeature[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ServiceFeaturesDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceFeaturesDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
