<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCapabilitiesRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for ServcieCapabilities request.
 * @subpackage Structs
 */
class ServiceCapabilitiesRequestStructure extends AbstractServiceRequestStructure
{
    /**
     * The ParticipantPermissions
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether to include the requestors permissions in the response. Only applies if Access control capability supported. Default is 'false'.
     * - minOccurs: 0
     * @var bool
     */
    public $ParticipantPermissions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of request. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for ServiceCapabilitiesRequestStructure
     * @uses ServiceCapabilitiesRequestStructure::setParticipantPermissions()
     * @uses ServiceCapabilitiesRequestStructure::setExtensions()
     * @uses ServiceCapabilitiesRequestStructure::setVersion()
     * @param bool $participantPermissions
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct($participantPermissions = false, \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setParticipantPermissions($participantPermissions)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get ParticipantPermissions value
     * @return bool|null
     */
    public function getParticipantPermissions()
    {
        return $this->ParticipantPermissions;
    }
    /**
     * Set ParticipantPermissions value
     * @param bool $participantPermissions
     * @return \StructType\ServiceCapabilitiesRequestStructure
     */
    public function setParticipantPermissions($participantPermissions = false)
    {
        // validation for constraint: boolean
        if (!is_null($participantPermissions) && !is_bool($participantPermissions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($participantPermissions)), __LINE__);
        }
        $this->ParticipantPermissions = $participantPermissions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\ServiceCapabilitiesRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\ServiceCapabilitiesRequestStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceCapabilitiesRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
