<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sections StructType
 * Meta informations extracted from the WSDL
 * - documentation: Sections of LINE affected. | Sections of ROUTE affected by SITUATION.
 * @subpackage Structs
 */
class Sections extends AbstractStructBase
{
    /**
     * The AffectedSection
     * Meta informations extracted from the WSDL
     * - documentation: Sections of ROUTE that is affected by SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedSectionStructure[]
     */
    public $AffectedSection;
    /**
     * Constructor method for Sections
     * @uses Sections::setAffectedSection()
     * @param \StructType\AffectedSectionStructure[] $affectedSection
     */
    public function __construct(array $affectedSection = array())
    {
        $this
            ->setAffectedSection($affectedSection);
    }
    /**
     * Get AffectedSection value
     * @return \StructType\AffectedSectionStructure[]|null
     */
    public function getAffectedSection()
    {
        return $this->AffectedSection;
    }
    /**
     * Set AffectedSection value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedSectionStructure[] $affectedSection
     * @return \StructType\Sections
     */
    public function setAffectedSection(array $affectedSection = array())
    {
        foreach ($affectedSection as $sectionsAffectedSectionItem) {
            // validation for constraint: itemType
            if (!$sectionsAffectedSectionItem instanceof \StructType\AffectedSectionStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedSection property can only contain items of \StructType\AffectedSectionStructure, "%s" given', is_object($sectionsAffectedSectionItem) ? get_class($sectionsAffectedSectionItem) : gettype($sectionsAffectedSectionItem)), __LINE__);
            }
        }
        $this->AffectedSection = $affectedSection;
        return $this;
    }
    /**
     * Add item to AffectedSection value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedSectionStructure $item
     * @return \StructType\Sections
     */
    public function addToAffectedSection(\StructType\AffectedSectionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedSectionStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedSection property can only contain items of \StructType\AffectedSectionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedSection[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Sections
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
