<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadOrCarriagewayOrLaneManagement StructType
 * @subpackage Structs
 */
class RoadOrCarriagewayOrLaneManagement extends NetworkManagement
{
    /**
     * The roadOrCarriagewayOrLaneManagementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $roadOrCarriagewayOrLaneManagementType;
    /**
     * The minimumCarOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $minimumCarOccupancy;
    /**
     * The specifiedCarriageway
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $specifiedCarriageway;
    /**
     * The specifiedLane
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $specifiedLane;
    /**
     * The roadOrCarriagewayOrLaneManagementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $roadOrCarriagewayOrLaneManagementExtension;
    /**
     * Constructor method for RoadOrCarriagewayOrLaneManagement
     * @uses RoadOrCarriagewayOrLaneManagement::setRoadOrCarriagewayOrLaneManagementType()
     * @uses RoadOrCarriagewayOrLaneManagement::setMinimumCarOccupancy()
     * @uses RoadOrCarriagewayOrLaneManagement::setSpecifiedCarriageway()
     * @uses RoadOrCarriagewayOrLaneManagement::setSpecifiedLane()
     * @uses RoadOrCarriagewayOrLaneManagement::setRoadOrCarriagewayOrLaneManagementExtension()
     * @param string $roadOrCarriagewayOrLaneManagementType
     * @param int $minimumCarOccupancy
     * @param string[] $specifiedCarriageway
     * @param string[] $specifiedLane
     * @param \StructType\ExtensionType $roadOrCarriagewayOrLaneManagementExtension
     */
    public function __construct($roadOrCarriagewayOrLaneManagementType = null, $minimumCarOccupancy = null, array $specifiedCarriageway = array(), array $specifiedLane = array(), \StructType\ExtensionType $roadOrCarriagewayOrLaneManagementExtension = null)
    {
        $this
            ->setRoadOrCarriagewayOrLaneManagementType($roadOrCarriagewayOrLaneManagementType)
            ->setMinimumCarOccupancy($minimumCarOccupancy)
            ->setSpecifiedCarriageway($specifiedCarriageway)
            ->setSpecifiedLane($specifiedLane)
            ->setRoadOrCarriagewayOrLaneManagementExtension($roadOrCarriagewayOrLaneManagementExtension);
    }
    /**
     * Get roadOrCarriagewayOrLaneManagementType value
     * @return string
     */
    public function getRoadOrCarriagewayOrLaneManagementType()
    {
        return $this->roadOrCarriagewayOrLaneManagementType;
    }
    /**
     * Set roadOrCarriagewayOrLaneManagementType value
     * @uses \EnumType\RoadOrCarriagewayOrLaneManagementTypeEnum::valueIsValid()
     * @uses \EnumType\RoadOrCarriagewayOrLaneManagementTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roadOrCarriagewayOrLaneManagementType
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function setRoadOrCarriagewayOrLaneManagementType($roadOrCarriagewayOrLaneManagementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoadOrCarriagewayOrLaneManagementTypeEnum::valueIsValid($roadOrCarriagewayOrLaneManagementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roadOrCarriagewayOrLaneManagementType, implode(', ', \EnumType\RoadOrCarriagewayOrLaneManagementTypeEnum::getValidValues())), __LINE__);
        }
        $this->roadOrCarriagewayOrLaneManagementType = $roadOrCarriagewayOrLaneManagementType;
        return $this;
    }
    /**
     * Get minimumCarOccupancy value
     * @return int|null
     */
    public function getMinimumCarOccupancy()
    {
        return $this->minimumCarOccupancy;
    }
    /**
     * Set minimumCarOccupancy value
     * @param int $minimumCarOccupancy
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function setMinimumCarOccupancy($minimumCarOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minimumCarOccupancy) && !is_numeric($minimumCarOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumCarOccupancy)), __LINE__);
        }
        $this->minimumCarOccupancy = $minimumCarOccupancy;
        return $this;
    }
    /**
     * Get specifiedCarriageway value
     * @return string[]|null
     */
    public function getSpecifiedCarriageway()
    {
        return $this->specifiedCarriageway;
    }
    /**
     * Set specifiedCarriageway value
     * @uses \EnumType\CarriagewayEnum::valueIsValid()
     * @uses \EnumType\CarriagewayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $specifiedCarriageway
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function setSpecifiedCarriageway(array $specifiedCarriageway = array())
    {
        $invalidValues = array();
        foreach ($specifiedCarriageway as $roadOrCarriagewayOrLaneManagementSpecifiedCarriagewayItem) {
            if (!\EnumType\CarriagewayEnum::valueIsValid($roadOrCarriagewayOrLaneManagementSpecifiedCarriagewayItem)) {
                $invalidValues[] = var_export($roadOrCarriagewayOrLaneManagementSpecifiedCarriagewayItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\CarriagewayEnum::getValidValues())), __LINE__);
        }
        $this->specifiedCarriageway = $specifiedCarriageway;
        return $this;
    }
    /**
     * Add item to specifiedCarriageway value
     * @uses \EnumType\CarriagewayEnum::valueIsValid()
     * @uses \EnumType\CarriagewayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function addToSpecifiedCarriageway($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CarriagewayEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\CarriagewayEnum::getValidValues())), __LINE__);
        }
        $this->specifiedCarriageway[] = $item;
        return $this;
    }
    /**
     * Get specifiedLane value
     * @return string[]|null
     */
    public function getSpecifiedLane()
    {
        return $this->specifiedLane;
    }
    /**
     * Set specifiedLane value
     * @uses \EnumType\LaneEnum::valueIsValid()
     * @uses \EnumType\LaneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $specifiedLane
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function setSpecifiedLane(array $specifiedLane = array())
    {
        $invalidValues = array();
        foreach ($specifiedLane as $roadOrCarriagewayOrLaneManagementSpecifiedLaneItem) {
            if (!\EnumType\LaneEnum::valueIsValid($roadOrCarriagewayOrLaneManagementSpecifiedLaneItem)) {
                $invalidValues[] = var_export($roadOrCarriagewayOrLaneManagementSpecifiedLaneItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\LaneEnum::getValidValues())), __LINE__);
        }
        $this->specifiedLane = $specifiedLane;
        return $this;
    }
    /**
     * Add item to specifiedLane value
     * @uses \EnumType\LaneEnum::valueIsValid()
     * @uses \EnumType\LaneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function addToSpecifiedLane($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LaneEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\LaneEnum::getValidValues())), __LINE__);
        }
        $this->specifiedLane[] = $item;
        return $this;
    }
    /**
     * Get roadOrCarriagewayOrLaneManagementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getRoadOrCarriagewayOrLaneManagementExtension()
    {
        return $this->roadOrCarriagewayOrLaneManagementExtension;
    }
    /**
     * Set roadOrCarriagewayOrLaneManagementExtension value
     * @param \StructType\ExtensionType $roadOrCarriagewayOrLaneManagementExtension
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public function setRoadOrCarriagewayOrLaneManagementExtension(\StructType\ExtensionType $roadOrCarriagewayOrLaneManagementExtension = null)
    {
        $this->roadOrCarriagewayOrLaneManagementExtension = $roadOrCarriagewayOrLaneManagementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoadOrCarriagewayOrLaneManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
